/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.webdav.utils.ICalendar;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.actionlist.base.ActionItemLogList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.admin.base.UserGroup;
import org.aspcfs.modules.admin.base.UserGroupList;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.tasks.base.TaskList;
import org.aspcfs.modules.troubletickets.base.TicketLog;
import org.aspcfs.modules.troubletickets.base.TicketLogList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class Ticket
extends GenericBean {
    Contact thisContact = new Contact();
    private String errorMessage = "";
    private int id = -1;
    private int orgId = -1;
    private int contractId = -1;
    private String serviceContractNumber = null;
    private double totalHoursRemaining = -1.0;
    private Timestamp contractStartDate = null;
    private Timestamp contractEndDate = null;
    private int contractOnsiteResponseModel = -1;
    private int assetId = -1;
    private String assetSerialNumber = null;
    private int assetManufacturerCode = -1;
    private int assetVendorCode = -1;
    private String assetModelVersion = null;
    private String assetLocation = null;
    private int assetOnsiteResponseModel = -1;
    private int contactId = -1;
    private int assignedTo = -1;
    private Timestamp assignedDate = null;
    private String problem = "";
    private String location = null;
    private String comment = "";
    private Timestamp estimatedResolutionDate = null;
    private String estimatedResolutionDateTimeZone = null;
    private String cause = null;
    private String solution = "";
    private int priorityCode = -1;
    private int levelCode = -1;
    private int departmentCode = -1;
    private int sourceCode = -1;
    private int catCode = 0;
    private int subCat1 = 0;
    private int subCat2 = 0;
    private int subCat3 = 0;
    private int severityCode = -1;
    private Timestamp resolutionDate = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private Timestamp closed = null;
    private int productId = -1;
    private int statusId = -1;
    private int customerProductId = -1;
    private int expectation = -1;
    private String productSku = null;
    private String productName = null;
    private String assignedDateTimeZone = null;
    private String resolutionDateTimeZone = null;
    private Timestamp trashedDate = null;
    private int userGroupId = -1;
    private int causeId = -1;
    private int resolutionId = -1;
    private int defectId = -1;
    private int escalationLevel = -1;
    private boolean resolvable = true;
    private int resolvedBy = -1;
    private int resolvedByDeptCode = -1;
    private int stateId = -1;
    private int siteId = -1;
    private String companyName = "";
    private String categoryName = "";
    private String departmentName = "";
    private String resolvedByDeptName = "";
    private String priorityName = "";
    private String severityName = "";
    private String sourceName = "";
    private String projectName = "";
    private String escalationLevelName = "";
    private boolean closeIt = false;
    private boolean companyEnabled = true;
    private int orgSiteId = -1;
    private int ageDays = 0;
    private int ageHours = 0;
    private int campaignId = -1;
    private boolean hasEnabledOwnerAccount = true;
    private int projectId = -1;
    private int projectTicketCount = -1;
    private boolean buildFiles = false;
    private boolean buildTasks = false;
    private boolean buildHistory = false;
    private boolean buildOrgHierarchy = true;
    private TicketLogList history = new TicketLogList();
    private FileItemList files = new FileItemList();
    private TaskList tasks = new TaskList();
    private int actionId = -1;
    private SystemStatus systemStatus = null;
    private int actionPlanId = -1;
    private boolean insertActionPlan = false;
    private String userGroupName = null;
    private ActionPlan plan = null;
    private String companyNameHierarchy = null;

    public Ticket() {
    }

    public Ticket(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Ticket(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Ticket Number");
        }
        PreparedStatement pst = db.prepareStatement("SELECT t.*, o.name AS orgname, o.enabled AS orgenabled, o.site_id AS orgsiteid, ld.description AS dept, lrd.description AS resolvedept, tp.description AS ticpri, ts.description AS ticsev, tc.description AS catname, lu_ts.description AS sourcename, sc.contract_number AS contractnumber, sc.total_hours_remaining AS hoursremaining, sc.current_start_date AS contractstartdate, sc.current_end_date AS contractenddate, sc.onsite_service_model AS contractonsiteservicemodel, a.serial_number AS serialnumber, a.manufacturer_code AS assetmanufacturercode, a.vendor_code AS assetvendorcode, a.model_version AS modelversion, a.location AS assetlocation, a.onsite_service_model AS assetonsiteservicemodel, pc.sku AS productsku , pc.product_name AS productname, tlp.project_id, proj.title as projectname, ug.group_name as usergroupname, lu_te.description AS escalationlevelname FROM ticket t LEFT JOIN organization o ON (t.org_id = o.org_id) LEFT JOIN lookup_department ld ON (t.department_code = ld.code) LEFT JOIN lookup_department lrd ON (t.resolvedby_department_code = lrd.code) LEFT JOIN ticket_priority tp ON (t.pri_code = tp.code) LEFT JOIN ticket_severity ts ON (t.scode = ts.code) LEFT JOIN ticket_category tc ON (t.cat_code = tc.id) LEFT JOIN lookup_ticketsource lu_ts ON (t.source_code = lu_ts.code) LEFT JOIN service_contract sc ON (t.link_contract_id = sc.contract_id) LEFT JOIN asset a ON (t.link_asset_id = a.asset_id) LEFT JOIN product_catalog pc ON (t.product_id = pc.product_id) LEFT JOIN ticketlink_project tlp ON (t.ticketid = tlp.ticket_id) LEFT JOIN projects proj ON (tlp.project_id = proj.project_id) LEFT JOIN user_group ug ON (t.user_group_id = ug.group_id) LEFT JOIN lookup_ticket_escalation lu_te ON (t.escalation_level = lu_te.code) WHERE t.ticketid = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        this.thisContact = this.getContactId() > 0 && this.checkContactRecord(db, this.getContactId()) ? new Contact(db, this.getContactId()) : null;
        if (this.buildHistory) {
            if (this.getSystemStatus() != null) {
                this.buildHistory(db, this.getSystemStatus());
            } else {
                this.buildHistory(db);
            }
        }
        if (this.buildFiles) {
            this.buildFiles(db);
        }
        if (this.buildTasks) {
            this.buildTasks(db);
        }
        if (this.buildOrgHierarchy) {
            this.companyNameHierarchy = OrganizationList.buildParentNameHierarchy(db, this.getOrgId(), true, new HashMap());
        }
        this.buildActionPlan(db);
    }

    public void buildRelatedInformation(Connection db) throws SQLException {
        if (this.getProductId() != -1) {
            ProductCatalogList list = new ProductCatalogList();
            list.setId(this.getProductId());
            list.buildList(db);
            if (list.size() == 1) {
                ProductCatalog catalogEntry = (ProductCatalog)((Object)list.get(0));
                this.setProductName(catalogEntry.getName());
                this.setProductSku(catalogEntry.getSku());
            }
        }
        if (this.getUserGroupId() != -1) {
            UserGroupList groupList = new UserGroupList();
            groupList.setGroupId(this.getUserGroupId());
            groupList.buildList(db);
            if (groupList.size() == 1) {
                UserGroup group = (UserGroup)((Object)groupList.get(0));
                this.setUserGroupName(group.getName());
            }
        }
    }

    public void buildActionPlan(Connection db) throws SQLException {
        ActionPlanWorkList list = new ActionPlanWorkList();
        list.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
        list.setLinkItemId(this.getId());
        list.setSiteId(this.getSiteId());
        list.setIncludeAllSites(true);
        list.buildList(db);
        if (list.size() > 0) {
            ActionPlanWork work = null;
            work = list.size() == 1 ? (ActionPlanWork)((Object)list.get(0)) : list.getLatestPlan();
            if (work != null && work.getId() != -1) {
                this.setActionPlanId(work.getActionPlanId());
                this.plan = new ActionPlan();
                this.plan.setBuildPhases(true);
                this.plan.setBuildSteps(true);
                this.plan.queryRecord(db, work.getActionPlanId());
            }
        }
    }

    public void buildHistory(Connection db) throws SQLException {
        this.history.setTicketId(this.getId());
        this.history.buildList(db);
    }

    public void buildHistory(Connection db, SystemStatus systemStatus) throws SQLException {
        this.history.setTicketId(this.getId());
        this.history.setSystemStatus(systemStatus);
        this.history.buildList(db);
    }

    public void buildFiles(Connection db) throws SQLException {
        this.files.clear();
        this.files.setLinkModuleId(6);
        this.files.setLinkItemId(this.getId());
        this.files.buildList(db);
    }

    public void buildTasks(Connection db) throws SQLException {
        this.tasks.setTicketId(this.getId());
        this.tasks.buildList(db);
    }

    public boolean checkContactRecord(Connection db, int id) throws SQLException {
        boolean contactFound = false;
        if (id != -1) {
            PreparedStatement pst = db.prepareStatement("SELECT contact_id from contact c WHERE c.contact_id = ? ");
            pst.setInt(1, id);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                contactFound = true;
            }
            rs.close();
            pst.close();
        }
        return contactFound;
    }

    public String getResolvedByDeptName() {
        return this.resolvedByDeptName;
    }

    public void setResolvedByDeptName(String tmp) {
        this.resolvedByDeptName = tmp;
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String tmp) {
        this.projectName = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public int getProductId() {
        return this.productId;
    }

    public void setClosed(Timestamp closed) {
        this.closed = closed;
    }

    public void setClosed(String tmp) {
        this.closed = DateUtils.parseTimestampString(tmp);
    }

    public void setExpectation(int tmp) {
        this.expectation = tmp;
    }

    public void setExpectation(String tmp) {
        this.expectation = Integer.parseInt(tmp);
    }

    public void setProductSku(String tmp) {
        this.productSku = tmp;
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public void setThisContact(Contact thisContact) {
        this.thisContact = thisContact;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public boolean getResolvable() {
        return this.resolvable;
    }

    public void setResolvable(boolean tmp) {
        this.resolvable = tmp;
    }

    public void setResolvable(String tmp) {
        this.resolvable = DatabaseUtils.parseBoolean(tmp);
    }

    public int getResolvedBy() {
        return this.resolvedBy;
    }

    public void setResolvedBy(int tmp) {
        this.resolvedBy = tmp;
    }

    public void setResolvedBy(String tmp) {
        this.resolvedBy = Integer.parseInt(tmp);
    }

    public int getResolvedByDeptCode() {
        return this.resolvedByDeptCode;
    }

    public void setResolvedByDeptCode(int tmp) {
        this.resolvedByDeptCode = tmp;
    }

    public void setResolvedByDeptCode(String tmp) {
        this.resolvedByDeptCode = Integer.parseInt(tmp);
    }

    public void setActionId(String actionId) {
        this.actionId = Integer.parseInt(actionId);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setAssignedDateTimeZone(String tmp) {
        this.assignedDateTimeZone = tmp;
    }

    public void setResolutionDateTimeZone(String tmp) {
        this.resolutionDateTimeZone = tmp;
    }

    public String getAssignedDateTimeZone() {
        return this.assignedDateTimeZone;
    }

    public String getResolutionDateTimeZone() {
        return this.resolutionDateTimeZone;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void setTasks(TaskList tasks) {
        this.tasks = tasks;
    }

    public TaskList getTasks() {
        return this.tasks;
    }

    public boolean getCompanyEnabled() {
        return this.companyEnabled;
    }

    public int getOrgSiteId() {
        return this.orgSiteId;
    }

    public void setCompanyEnabled(boolean companyEnabled) {
        this.companyEnabled = companyEnabled;
    }

    public void setOrgSiteId(int tmp) {
        this.orgSiteId = tmp;
    }

    public void setOrgSiteId(String tmp) {
        this.orgSiteId = Integer.parseInt(tmp);
    }

    public void setNewticketlogentry(String newticketlogentry) {
        this.comment = newticketlogentry;
    }

    public void setAssignedTo(int assignedTo) {
        this.assignedTo = assignedTo;
    }

    public void setAssignedDate(Timestamp tmp) {
        this.assignedDate = tmp;
    }

    public void setAssignedDate(String tmp) {
        this.assignedDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setSubCat1(int tmp) {
        this.subCat1 = tmp;
    }

    public void setSubCat2(int tmp) {
        this.subCat2 = tmp;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setEscalationLevelName(String tmp) {
        this.escalationLevelName = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setSubCat3(int tmp) {
        this.subCat3 = tmp;
    }

    public void setSubCat1(String tmp) {
        this.subCat1 = Integer.parseInt(tmp);
    }

    public void setSubCat2(String tmp) {
        this.subCat2 = Integer.parseInt(tmp);
    }

    public void setSubCat3(String tmp) {
        this.subCat3 = Integer.parseInt(tmp);
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = Integer.parseInt(assignedTo);
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public void setCloseIt(boolean closeIt) {
        this.closeIt = closeIt;
    }

    public void setCloseNow(String tmp) {
        this.closeIt = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSeverityName(String severityName) {
        this.severityName = severityName;
    }

    public void setErrorMessage(String tmp) {
        this.errorMessage = tmp;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public void setHistory(TicketLogList history) {
        this.history = history;
    }

    public void setFiles(FileItemList tmp) {
        this.files = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
        this.history.setTicketId(tmp);
    }

    public void setId(String tmp) {
        this.setId(Integer.parseInt(tmp));
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContractId(int tmp) {
        this.contractId = tmp;
    }

    public void setContractId(String tmp) {
        this.contractId = Integer.parseInt(tmp);
    }

    public void setServiceContractNumber(String tmp) {
        this.serviceContractNumber = tmp;
    }

    public void setTotalHoursRemaining(double tmp) {
        this.totalHoursRemaining = tmp;
    }

    public void setTotalHoursRemaining(String tmp) {
        this.totalHoursRemaining = Double.parseDouble(tmp);
    }

    public void setContractStartDate(Timestamp tmp) {
        this.contractStartDate = tmp;
    }

    public void setContractStartDate(String tmp) {
        this.contractStartDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setContractEndDate(Timestamp tmp) {
        this.contractEndDate = tmp;
    }

    public void setContractEndDate(String tmp) {
        this.contractEndDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setContractOnsiteResponseModel(int tmp) {
        this.contractOnsiteResponseModel = tmp;
    }

    public void setContractOnsiteResponseModel(String tmp) {
        this.contractOnsiteResponseModel = Integer.parseInt(tmp);
    }

    public void setAssetId(int tmp) {
        this.assetId = tmp;
    }

    public void setAssetId(String tmp) {
        this.assetId = Integer.parseInt(tmp);
    }

    public void setAssetSerialNumber(String tmp) {
        this.assetSerialNumber = tmp;
    }

    public void setAssetManufacturerCode(int tmp) {
        this.assetManufacturerCode = tmp;
    }

    public void setAssetManufacturerCode(String tmp) {
        this.assetManufacturerCode = Integer.parseInt(tmp);
    }

    public void setAssetVendorCode(int tmp) {
        this.assetVendorCode = tmp;
    }

    public void setAssetVendorCode(String tmp) {
        this.assetVendorCode = Integer.parseInt(tmp);
    }

    public void setAssetModelVersion(String tmp) {
        this.assetModelVersion = tmp;
    }

    public void setAssetLocation(String tmp) {
        this.assetLocation = tmp;
    }

    public void setAssetOnsiteResponseModel(int tmp) {
        this.assetOnsiteResponseModel = tmp;
    }

    public void setAssetOnsiteResponseModel(String tmp) {
        this.assetOnsiteResponseModel = Integer.parseInt(tmp);
    }

    public void setBuildFiles(boolean buildFiles) {
        this.buildFiles = buildFiles;
    }

    public void setBuildTasks(boolean buildTasks) {
        this.buildTasks = buildTasks;
    }

    public void setBuildHistory(boolean buildHistory) {
        this.buildHistory = buildHistory;
    }

    public void setCustomerProductId(int tmp) {
        this.customerProductId = tmp;
    }

    public void setCustomerProductId(String tmp) {
        this.customerProductId = Integer.parseInt(tmp);
    }

    public int getCustomerProductId() {
        return this.customerProductId;
    }

    public boolean getBuildFiles() {
        return this.buildFiles;
    }

    public boolean getBuildTasks() {
        return this.buildTasks;
    }

    public boolean getBuildHistory() {
        return this.buildHistory;
    }

    public boolean getHasEnabledOwnerAccount() {
        return this.hasEnabledOwnerAccount;
    }

    public void setHasEnabledOwnerAccount(boolean hasEnabledOwnerAccount) {
        this.hasEnabledOwnerAccount = hasEnabledOwnerAccount;
    }

    public void setProjectId(int tmp) {
        this.projectId = tmp;
    }

    public void setProjectId(String tmp) {
        this.projectId = Integer.parseInt(tmp);
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectTicketCount(int tmp) {
        this.projectTicketCount = tmp;
    }

    public void setProjectTicketCount(String tmp) {
        this.projectTicketCount = Integer.parseInt(tmp);
    }

    public int getProjectTicketCount() {
        return this.projectTicketCount;
    }

    public String getPaddedProjectTicketCount() {
        String padded = String.valueOf(this.getProjectTicketCount());
        while (padded.length() < 6) {
            padded = "0" + padded;
        }
        return padded;
    }

    public String getPaddedTicketId() {
        if (this.projectId == -1) {
            return this.getPaddedId();
        }
        return this.getPaddedProjectTicketCount();
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setPriorityName(String priorityName) {
        this.priorityName = priorityName;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setAgeDays(int ageOf) {
        this.ageDays = ageOf;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setProblem(String tmp) {
        this.problem = tmp;
    }

    public void setLocation(String tmp) {
        this.location = tmp;
    }

    public void setComment(String tmp) {
        this.comment = tmp;
    }

    public void setEstimatedResolutionDate(Timestamp tmp) {
        this.estimatedResolutionDate = tmp;
    }

    public void setEstimatedResolutionDate(String tmp) {
        this.estimatedResolutionDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setEstimatedResolutionDateTimeZone(String tmp) {
        this.estimatedResolutionDateTimeZone = tmp;
    }

    public void setCause(String tmp) {
        this.cause = tmp;
    }

    public void setSolution(String tmp) {
        this.solution = tmp;
    }

    public void setPriorityCode(int tmp) {
        this.priorityCode = tmp;
    }

    public void setPriorityCode(String tmp) {
        this.priorityCode = Integer.parseInt(tmp);
    }

    public void setLevelCode(int tmp) {
        this.levelCode = tmp;
    }

    public void setLevelCode(String tmp) {
        this.levelCode = Integer.parseInt(tmp);
    }

    public void setDepartmentCode(int tmp) {
        this.departmentCode = tmp;
    }

    public void setDepartmentCode(String tmp) {
        this.departmentCode = Integer.parseInt(tmp);
    }

    public void setSourceCode(int tmp) {
        this.sourceCode = tmp;
    }

    public void setSourceCode(String tmp) {
        this.sourceCode = Integer.parseInt(tmp);
    }

    public void setCatCode(int tmp) {
        this.catCode = tmp;
    }

    public void setCatCode(String tmp) {
        this.catCode = Integer.parseInt(tmp);
    }

    public void setSeverityCode(int tmp) {
        this.severityCode = tmp;
    }

    public void setSeverityCode(String tmp) {
        this.severityCode = Integer.parseInt(tmp);
    }

    public void setResolutionDate(Timestamp tmp) {
        this.resolutionDate = tmp;
    }

    public void setResolutionDate(String tmp) {
        this.resolutionDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setEscalationLevel(int tmp) {
        this.escalationLevel = tmp;
    }

    public void setEscalationLevel(String tmp) {
        this.escalationLevel = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setRequestItems(HttpServletRequest request) throws Exception {
        this.history = new TicketLogList(request, this.getModifiedBy());
    }

    public Timestamp getClosed() {
        return this.closed;
    }

    public String getClosedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.closed);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public boolean isClosed() {
        return this.closed != null;
    }

    public int getExpectation() {
        return this.expectation;
    }

    public String getProductSku() {
        return this.productSku;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getPaddedId() {
        String padded = String.valueOf(this.getId());
        while (padded.length() < 6) {
            padded = "0" + padded;
        }
        return padded;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString(int dateStyle, int timeStyle) {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(dateStyle, timeStyle).format(this.entered);
        }
        catch (NullPointerException e) {
            return tmp;
        }
    }

    public String getModifiedDateTimeString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Contact getThisContact() {
        return this.thisContact;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getEscalationLevelName() {
        return this.escalationLevelName;
    }

    public int getSubCat1() {
        return this.subCat1;
    }

    public int getSubCat2() {
        return this.subCat2;
    }

    public int getSubCat3() {
        return this.subCat3;
    }

    public String getNewticketlogentry() {
        return this.comment;
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public boolean isAssigned() {
        return this.assignedTo > 0;
    }

    public Timestamp getAssignedDate() {
        return this.assignedDate;
    }

    public boolean getCloseIt() {
        return this.closeIt;
    }

    public String getSeverityName() {
        return this.severityName;
    }

    public String getPriorityName() {
        return this.priorityName;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public TicketLogList getHistory() {
        return this.history;
    }

    public FileItemList getFiles() {
        return this.files;
    }

    public String getAgeOf() {
        return this.ageDays + "d " + this.ageHours + "h";
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContractId() {
        return this.contractId;
    }

    public String getServiceContractNumber() {
        return this.serviceContractNumber;
    }

    public double getTotalHoursRemaining() {
        return Ticket.round((double)this.totalHoursRemaining, (int)2);
    }

    public Timestamp getContractStartDate() {
        return this.contractStartDate;
    }

    public Timestamp getContractEndDate() {
        return this.contractEndDate;
    }

    public int getContractOnsiteResponseModel() {
        return this.contractOnsiteResponseModel;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public String getAssetSerialNumber() {
        return this.assetSerialNumber;
    }

    public int getAssetManufacturerCode() {
        return this.assetManufacturerCode;
    }

    public int getAssetVendorCode() {
        return this.assetVendorCode;
    }

    public String getAssetModelVersion() {
        return this.assetModelVersion;
    }

    public String getAssetLocation() {
        return this.assetLocation;
    }

    public int getAssetOnsiteResponseModel() {
        return this.assetOnsiteResponseModel;
    }

    public int getContactId() {
        return this.contactId;
    }

    public String getProblem() {
        return this.problem;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProblemHeader() {
        if (this.problem.trim().length() > 100) {
            return this.problem.substring(0, 100) + "...";
        }
        return this.getProblem();
    }

    public void checkEnabledOwnerAccount(Connection db) throws SQLException {
        if (this.getAssignedTo() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? AND enabled = ? ");
        pst.setInt(1, this.getAssignedTo());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setHasEnabledOwnerAccount(true);
        } else {
            this.setHasEnabledOwnerAccount(false);
        }
        rs.close();
        pst.close();
    }

    public String getComment() {
        return this.comment;
    }

    public Timestamp getEstimatedResolutionDate() {
        return this.estimatedResolutionDate;
    }

    public String getEstimatedResolutionDateTimeZone() {
        return this.estimatedResolutionDateTimeZone;
    }

    public String getCause() {
        return this.cause;
    }

    public String getSolution() {
        return this.solution;
    }

    public int getPriorityCode() {
        return this.priorityCode;
    }

    public int getLevelCode() {
        return this.levelCode;
    }

    public int getDepartmentCode() {
        return this.departmentCode;
    }

    public int getSourceCode() {
        return this.sourceCode;
    }

    public int getCatCode() {
        return this.catCode;
    }

    public int getSeverityCode() {
        return this.severityCode;
    }

    public Timestamp getResolutionDate() {
        return this.resolutionDate;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getActionPlanId() {
        return this.actionPlanId;
    }

    public void setActionPlanId(int tmp) {
        this.actionPlanId = tmp;
    }

    public void setActionPlanId(String tmp) {
        this.actionPlanId = Integer.parseInt(tmp);
    }

    public boolean getInsertActionPlan() {
        return this.insertActionPlan;
    }

    public void setInsertActionPlan(boolean tmp) {
        this.insertActionPlan = tmp;
    }

    public void setInsertActionPlan(String tmp) {
        this.insertActionPlan = DatabaseUtils.parseBoolean(tmp);
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public String getUserGroupName() {
        return this.userGroupName;
    }

    public void setUserGroupName(String tmp) {
        this.userGroupName = tmp;
    }

    public int getCauseId() {
        return this.causeId;
    }

    public void setCauseId(int tmp) {
        this.causeId = tmp;
    }

    public void setCauseId(String tmp) {
        this.causeId = Integer.parseInt(tmp);
    }

    public int getResolutionId() {
        return this.resolutionId;
    }

    public void setResolutionId(int tmp) {
        this.resolutionId = tmp;
    }

    public void setResolutionId(String tmp) {
        this.resolutionId = Integer.parseInt(tmp);
    }

    public int getDefectId() {
        return this.defectId;
    }

    public void setDefectId(int tmp) {
        this.defectId = tmp;
    }

    public void setDefectId(String tmp) {
        this.defectId = Integer.parseInt(tmp);
    }

    public int getEscalationLevel() {
        return this.escalationLevel;
    }

    public ActionPlan getPlan() {
        return this.plan;
    }

    public void setPlan(ActionPlan tmp) {
        this.plan = tmp;
    }

    public boolean getBuildOrgHierarchy() {
        return this.buildOrgHierarchy;
    }

    public void setBuildOrgHierarchy(boolean tmp) {
        this.buildOrgHierarchy = tmp;
    }

    public void setBuildOrgHierarchy(String tmp) {
        this.buildOrgHierarchy = DatabaseUtils.parseBoolean(tmp);
    }

    public String getCompanyNameHierarchy() {
        return this.companyNameHierarchy;
    }

    public void setCompanyNameHierarchy(String tmp) {
        this.companyNameHierarchy = tmp;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int tmp) {
        this.stateId = tmp;
    }

    public void setStateId(String tmp) {
        this.stateId = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void buildContactInformation(Connection db) throws SQLException {
        if (this.contactId > -1) {
            this.thisContact = new Contact(db, this.contactId);
        }
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            if (this.projectId > -1 && this.projectTicketCount == -1) {
                this.updateProjectTicketCount(db, this.projectId);
            }
            this.id = DatabaseUtils.getNextSeq(db, "ticket_ticketid_seq");
            sql.append("INSERT INTO ticket (contact_id, problem, pri_code, department_code, cat_code, scode, org_id, link_contract_id, link_asset_id, expectation, product_id, customer_product_id, key_count, status_id, trashed_date, user_group_id, cause_id, resolution_id, defect_id, escalation_level, resolvable, resolvedby, resolvedby_department_code, state_id, site_id, ");
            if (this.id > -1) {
                sql.append("ticketid, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sql.append("?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?,");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getContactId());
            pst.setString(++i, this.getProblem());
            if (this.getPriorityCode() > 0) {
                pst.setInt(++i, this.getPriorityCode());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getDepartmentCode() > 0) {
                pst.setInt(++i, this.getDepartmentCode());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getCatCode() > 0) {
                pst.setInt(++i, this.getCatCode());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getSeverityCode() > 0) {
                pst.setInt(++i, this.getSeverityCode());
            } else {
                pst.setNull(++i, 4);
            }
            DatabaseUtils.setInt(pst, ++i, this.orgId);
            DatabaseUtils.setInt(pst, ++i, this.contractId);
            DatabaseUtils.setInt(pst, ++i, this.assetId);
            DatabaseUtils.setInt(pst, ++i, this.expectation);
            DatabaseUtils.setInt(pst, ++i, this.productId);
            DatabaseUtils.setInt(pst, ++i, this.customerProductId);
            DatabaseUtils.setInt(pst, ++i, this.projectTicketCount);
            DatabaseUtils.setInt(pst, ++i, this.statusId);
            DatabaseUtils.setTimestamp(pst, ++i, this.trashedDate);
            DatabaseUtils.setInt(pst, ++i, this.userGroupId);
            DatabaseUtils.setInt(pst, ++i, this.causeId);
            DatabaseUtils.setInt(pst, ++i, this.resolutionId);
            DatabaseUtils.setInt(pst, ++i, this.defectId);
            DatabaseUtils.setInt(pst, ++i, this.escalationLevel);
            pst.setBoolean(++i, this.resolvable);
            if (this.resolvedBy > 0) {
                pst.setInt(++i, this.resolvedBy);
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getResolvedByDeptCode() > 0) {
                pst.setInt(++i, this.getResolvedByDeptCode());
            } else {
                pst.setNull(++i, 4);
            }
            DatabaseUtils.setInt(pst, ++i, this.getStateId());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_ticketid_seq", this.id);
            this.update(db, true);
            if (this.getEntered() == null) {
                this.updateEntry(db);
            }
            if (this.actionId > 0) {
                this.updateLog(db);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void updateLog(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemLog thisLog = new ActionItemLog();
            thisLog.setEnteredBy(this.getEnteredBy());
            thisLog.setModifiedBy(this.getModifiedBy());
            thisLog.setItemId(this.getActionId());
            thisLog.setLinkItemId(this.getId());
            thisLog.setType(42420030);
            thisLog.insert(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ticket SET link_contract_id = ?, link_asset_id = ?, department_code = ?, pri_code = ?, scode = ?, cat_code = ?, assigned_to = ?, subcat_code1 = ?, subcat_code2 = ?, subcat_code3 = ?, source_code = ?, contact_id = ?, problem = ?, status_id = ?, trashed_date = ?, site_id = ? , ");
        if (!override) {
            sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", modifiedby = ?, ");
        }
        if (this.getCloseIt()) {
            sql.append("closed = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        } else if (this.closed != null) {
            sql.append("closed = ?, ");
        }
        if (this.orgId != -1) {
            sql.append(" org_id = ?, ");
        }
        sql.append("solution = ?, location = ?, assigned_date = ?, assigned_date_timezone = ?, est_resolution_date = ?, est_resolution_date_timezone = ?, resolution_date = ?, resolution_date_timezone = ?, cause = ?, expectation = ?, product_id = ?, customer_product_id = ?, user_group_id = ?, cause_id = ?, resolution_id = ?, defect_id = ?, state_id = ?, escalation_level = ?, resolvable = ?, resolvedby = ?, resolvedby_department_code = ? WHERE ticketid = ? ");
        if (!override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getContractId());
        DatabaseUtils.setInt(pst, ++i, this.getAssetId());
        if (this.getDepartmentCode() > 0) {
            pst.setInt(++i, this.getDepartmentCode());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getPriorityCode() > 0) {
            pst.setInt(++i, this.getPriorityCode());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSeverityCode() > 0) {
            pst.setInt(++i, this.getSeverityCode());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getCatCode() > 0) {
            pst.setInt(++i, this.getCatCode());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.assignedTo > 0) {
            pst.setInt(++i, this.assignedTo);
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSubCat1() > 0) {
            pst.setInt(++i, this.getSubCat1());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSubCat2() > 0) {
            pst.setInt(++i, this.getSubCat2());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSubCat3() > 0) {
            pst.setInt(++i, this.getSubCat3());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSourceCode() > 0) {
            pst.setInt(++i, this.getSourceCode());
        } else {
            pst.setNull(++i, 4);
        }
        DatabaseUtils.setInt(pst, ++i, this.getContactId());
        pst.setString(++i, this.getProblem());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
        DatabaseUtils.setInt(pst, ++i, this.getSiteId());
        if (!override) {
            pst.setInt(++i, this.getModifiedBy());
        }
        if (!this.getCloseIt() && this.closed != null) {
            pst.setTimestamp(++i, this.closed);
        }
        if (this.orgId != -1) {
            DatabaseUtils.setInt(pst, ++i, this.orgId);
        }
        pst.setString(++i, this.getSolution());
        pst.setString(++i, this.location);
        DatabaseUtils.setTimestamp(pst, ++i, this.assignedDate);
        pst.setString(++i, this.assignedDateTimeZone);
        DatabaseUtils.setTimestamp(pst, ++i, this.estimatedResolutionDate);
        pst.setString(++i, this.estimatedResolutionDateTimeZone);
        DatabaseUtils.setTimestamp(pst, ++i, this.resolutionDate);
        pst.setString(++i, this.resolutionDateTimeZone);
        pst.setString(++i, this.cause);
        DatabaseUtils.setInt(pst, ++i, this.expectation);
        DatabaseUtils.setInt(pst, ++i, this.productId);
        DatabaseUtils.setInt(pst, ++i, this.customerProductId);
        DatabaseUtils.setInt(pst, ++i, this.userGroupId);
        DatabaseUtils.setInt(pst, ++i, this.causeId);
        DatabaseUtils.setInt(pst, ++i, this.resolutionId);
        DatabaseUtils.setInt(pst, ++i, this.defectId);
        DatabaseUtils.setInt(pst, ++i, this.getStateId());
        DatabaseUtils.setInt(pst, ++i, this.escalationLevel);
        pst.setBoolean(++i, this.resolvable);
        if (this.resolvedBy > 0) {
            pst.setInt(++i, this.resolvedBy);
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getResolvedByDeptCode() > 0) {
            pst.setInt(++i, this.getResolvedByDeptCode());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setInt(++i, this.id);
        if (!override && this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        if (this.getCloseIt()) {
            TicketLog thisEntry = new TicketLog();
            thisEntry.setEnteredBy(this.getModifiedBy());
            thisEntry.setDepartmentCode(this.getDepartmentCode());
            thisEntry.setAssignedTo(this.getAssignedTo());
            thisEntry.setPriorityCode(this.getPriorityCode());
            thisEntry.setSeverityCode(this.getSeverityCode());
            thisEntry.setEscalationCode(this.getEscalationLevel());
            thisEntry.setTicketId(this.getId());
            thisEntry.setClosed(true);
            thisEntry.setStateId(this.getStateId());
            thisEntry.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
        if (this.actionPlanId != -1 && this.insertActionPlan) {
            this.parseActionPlanMapping(db);
        }
        return resultCount;
    }

    public boolean parseActionPlanMapping(Connection db) throws SQLException {
        ActionPlan actionPlan = new ActionPlan();
        actionPlan.setBuildPhases(true);
        actionPlan.setBuildSteps(true);
        actionPlan.queryRecord(db, this.actionPlanId);
        boolean exists = false;
        ActionPlanWorkList workList = new ActionPlanWorkList();
        workList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
        workList.setLinkItemId(this.getId());
        workList.buildList(db);
        for (ActionPlanWork work : workList) {
            if (work.getActionPlanId() != this.getActionPlanId()) continue;
            exists = true;
            break;
        }
        if (!exists && this.getAssignedTo() != -1) {
            ActionPlanWork actionPlanWork = new ActionPlanWork();
            actionPlanWork.setActionPlanId(this.actionPlanId);
            actionPlanWork.setManagerId(this.getAssignedTo());
            actionPlanWork.setAssignedTo(this.getAssignedTo());
            actionPlanWork.setLinkModuleId(workList.getLinkModuleId());
            actionPlanWork.setLinkItemId(this.getId());
            actionPlanWork.setEnteredBy(this.getModifiedBy());
            actionPlanWork.setModifiedBy(this.getModifiedBy());
            actionPlanWork.insert(db, actionPlan);
        }
        return true;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ticket SET trashed_date = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "user_group_id = ? , " + "modifiedby = ? " + "WHERE ticketid = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (toTrash) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
        } else {
            DatabaseUtils.setTimestamp(pst, ++i, null);
        }
        DatabaseUtils.setInt(pst, ++i, -1);
        DatabaseUtils.setInt(pst, ++i, tmpUserId);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        if (!toTrash) {
            this.getTasks().setIncludeOnlyTrashed(true);
        }
        this.buildTasks(db);
        this.getTasks().updateStatus(db, toTrash, tmpUserId);
        if (toTrash) {
            ActionPlanWorkList workList = new ActionPlanWorkList();
            workList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            workList.setLinkItemId(this.getId());
            workList.setSiteId(this.getSiteId());
            workList.buildList(db);
            workList.delete(db);
            ActionItemLog.deleteLink(db, this.getId(), 42420030);
        }
        ContactHistory.trash(db, 9, this.getId(), !toTrash);
        return resultCount == 1;
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setAssignedTo(newOwner);
        result = this.update(db);
        return result != -1;
    }

    public int reopen(Connection db) throws SQLException {
        int resultCount = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = null;
            String sql = "UPDATE ticket SET closed = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", modifiedby = ? " + "WHERE ticketid = ? ";
            int i = 0;
            pst = db.prepareStatement(sql);
            pst.setNull(++i, 93);
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            this.setClosed((Timestamp)null);
            TicketLog thisEntry = new TicketLog();
            thisEntry.setEnteredBy(this.getModifiedBy());
            thisEntry.setDepartmentCode(this.getDepartmentCode());
            thisEntry.setAssignedTo(this.getAssignedTo());
            thisEntry.setPriorityCode(this.getPriorityCode());
            thisEntry.setSeverityCode(this.getSeverityCode());
            thisEntry.setEscalationCode(this.getEscalationLevel());
            thisEntry.setEntryText(this.getComment());
            thisEntry.setTicketId(this.getId());
            thisEntry.setStateId(this.getStateId());
            thisEntry.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        ResultSet rs;
        PreparedStatement pst;
        int i;
        DependencyList dependencyList = new DependencyList();
        int numberOfLinkedActionItems = ActionItemLogList.getLinkedActionItemLogCount(db, this.getId(), 42420030);
        if (numberOfLinkedActionItems != 0) {
            Dependency thisDependency2 = new Dependency();
            thisDependency2.setName("actionLists");
            thisDependency2.setCount(numberOfLinkedActionItems);
            thisDependency2.setCanDelete(true);
            dependencyList.add(thisDependency2);
        }
        try {
            int linkcount;
            int i2 = 0;
            PreparedStatement pst2 = db.prepareStatement("SELECT count(*) as linkcount FROM tasklink_ticket WHERE ticket_id = ? ");
            pst2.setInt(++i2, this.getId());
            ResultSet rs2 = pst2.executeQuery();
            if (rs2.next() && (linkcount = rs2.getInt("linkcount")) != 0) {
                Dependency thisDependency3 = new Dependency();
                thisDependency3.setName("tasks");
                thisDependency3.setCount(linkcount);
                thisDependency3.setCanDelete(true);
                dependencyList.add(thisDependency3);
            }
            rs2.close();
            pst2.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        Dependency docDependency = new Dependency();
        docDependency.setName("documents");
        docDependency.setCount(FileItemList.retrieveRecordCount((Connection)db, (int)6, (int)this.getId()));
        docDependency.setCanDelete(true);
        dependencyList.add(docDependency);
        Dependency folderDependency = new Dependency();
        folderDependency.setName("folders");
        folderDependency.setCount(CustomFieldRecordList.retrieveRecordCount(db, 11072003, this.getId()));
        folderDependency.setCanDelete(true);
        dependencyList.add(folderDependency);
        try {
            int linkcount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as linkcount FROM ticket_sun_form WHERE link_ticket_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (linkcount = rs.getInt("linkcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("maintenanceNotes");
                thisDependency.setCount(linkcount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            int quotecount;
            i = 0;
            pst = db.prepareStatement("SELECT COUNT(DISTINCT(group_id)) AS quotecount FROM quote_entry WHERE ticketid = ? AND trashed_date IS NULL ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (quotecount = rs.getInt("quotecount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("quotes");
                thisDependency.setCount(quotecount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            int plancount;
            i = 0;
            int linkModuleId = ActionPlan.getMapIdGivenConstantId(db, 912051329);
            PreparedStatement pst3 = db.prepareStatement("SELECT count(*) AS plancount FROM action_plan_work WHERE link_module_id = ? AND link_item_id = ? ");
            pst3.setInt(++i, linkModuleId);
            pst3.setInt(++i, this.getId());
            ResultSet rs3 = pst3.executeQuery();
            if (rs3.next() && (plancount = rs3.getInt("plancount")) != 0) {
                Dependency thisDependency4 = new Dependency();
                thisDependency4.setName("actionPlanRecords");
                thisDependency4.setCount(plancount);
                thisDependency4.setCanDelete(true);
                dependencyList.add(thisDependency4);
            }
            rs3.close();
            pst3.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            int linkcount;
            i = 0;
            PreparedStatement pst4 = db.prepareStatement("SELECT count(*) as linkcount FROM ticket_csstm_form WHERE link_ticket_id = ? ");
            pst4.setInt(++i, this.getId());
            rs = pst4.executeQuery();
            if (rs.next() && (linkcount = rs.getInt("linkcount")) != 0) {
                Dependency thisDependency5 = new Dependency();
                thisDependency5.setName("activities");
                thisDependency5.setCount(linkcount);
                thisDependency5.setCanDelete(false);
                dependencyList.add(thisDependency5);
            }
            rs.close();
            pst4.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Ticket ID not specified.");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemLog.deleteLink(db, this.getId(), 42420030);
            FileItemList fileList = new FileItemList();
            fileList.setLinkModuleId(6);
            fileList.setLinkItemId(this.getId());
            fileList.buildList(db);
            fileList.delete(db, this.getFileLibraryPath(baseFilePath, "tickets"));
            fileList = null;
            CustomFieldRecordList folderList = new CustomFieldRecordList();
            folderList.setLinkModuleId(11072003);
            folderList.setLinkItemId(this.getId());
            folderList.buildList(db);
            folderList.delete(db);
            folderList = null;
            ActionPlanWorkList workList = new ActionPlanWorkList();
            workList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            workList.setIncludeAllSites(true);
            workList.setSiteId(this.getSiteId());
            workList.setLinkItemId(this.getId());
            workList.buildList(db);
            workList.delete(db);
            if (this.tasks == null || this.tasks.size() == 0) {
                this.buildTasks(db);
            }
            this.getTasks().delete(db);
            PreparedStatement pst = db.prepareStatement("DELETE FROM ticketlog WHERE ticketid = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM ticketlink_project WHERE ticket_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM tasklink_ticket WHERE ticket_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM trouble_asset_replacement WHERE link_form_id IN (SELECT form_id FROM ticket_sun_form WHERE link_ticket_id = ?)");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM ticket_sun_form WHERE link_ticket_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM ticket_activity_item WHERE link_form_id IN (SELECT form_id FROM ticket_csstm_form WHERE link_ticket_id = ?) ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM ticket_csstm_form WHERE link_ticket_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            ContactHistory.deleteObject(db, 9, this.getId());
            pst = db.prepareStatement("DELETE FROM ticket WHERE ticketid = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int i = -1;
        try {
            db.setAutoCommit(false);
            i = this.update(db, false);
            this.updateEntry(db);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return i;
    }

    public void updateEntry(Connection db) throws SQLException {
        TicketLog thisEntry = new TicketLog();
        thisEntry.setEnteredBy(this.getModifiedBy());
        thisEntry.setDepartmentCode(this.getDepartmentCode());
        thisEntry.setAssignedTo(this.getAssignedTo());
        thisEntry.setEntryText(this.getComment());
        thisEntry.setTicketId(this.getId());
        thisEntry.setPriorityCode(this.getPriorityCode());
        thisEntry.setSeverityCode(this.getSeverityCode());
        thisEntry.setStateId(this.getStateId());
        thisEntry.setEscalationCode(this.getEscalationLevel());
        if (this.getCloseIt()) {
            thisEntry.setClosed(true);
        }
        this.history.add(thisEntry);
        for (TicketLog thisLog : this.history) {
            thisLog.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("ticketid"));
        this.orgId = DatabaseUtils.getInt(rs, "org_id");
        this.contactId = DatabaseUtils.getInt(rs, "contact_id");
        this.problem = rs.getString("problem");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.closed = rs.getTimestamp("closed");
        if (!rs.wasNull()) {
            this.closeIt = true;
        }
        this.priorityCode = DatabaseUtils.getInt(rs, "pri_code");
        this.levelCode = DatabaseUtils.getInt(rs, "level_code");
        this.departmentCode = DatabaseUtils.getInt(rs, "department_code");
        this.sourceCode = DatabaseUtils.getInt(rs, "source_code");
        this.catCode = DatabaseUtils.getInt(rs, "cat_code", 0);
        this.subCat1 = DatabaseUtils.getInt(rs, "subcat_code1", 0);
        this.subCat2 = DatabaseUtils.getInt(rs, "subcat_code2", 0);
        this.subCat3 = DatabaseUtils.getInt(rs, "subcat_code3", 0);
        this.assignedTo = DatabaseUtils.getInt(rs, "assigned_to");
        this.solution = rs.getString("solution");
        this.severityCode = DatabaseUtils.getInt(rs, "scode");
        this.location = rs.getString("location");
        this.assignedDate = rs.getTimestamp("assigned_date");
        this.estimatedResolutionDate = rs.getTimestamp("est_resolution_date");
        this.resolutionDate = rs.getTimestamp("resolution_date");
        this.cause = rs.getString("cause");
        this.contractId = DatabaseUtils.getInt(rs, "link_contract_id");
        this.assetId = DatabaseUtils.getInt(rs, "link_asset_id");
        this.productId = DatabaseUtils.getInt(rs, "product_id");
        this.customerProductId = DatabaseUtils.getInt(rs, "customer_product_id");
        this.expectation = DatabaseUtils.getInt(rs, "expectation");
        this.projectTicketCount = rs.getInt("key_count");
        this.estimatedResolutionDateTimeZone = rs.getString("est_resolution_date_timezone");
        this.assignedDateTimeZone = rs.getString("assigned_date_timezone");
        this.resolutionDateTimeZone = rs.getString("resolution_date_timezone");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.userGroupId = DatabaseUtils.getInt(rs, "user_group_id");
        this.causeId = DatabaseUtils.getInt(rs, "cause_id");
        this.resolutionId = DatabaseUtils.getInt(rs, "resolution_id");
        this.defectId = DatabaseUtils.getInt(rs, "defect_id");
        this.escalationLevel = DatabaseUtils.getInt(rs, "escalation_level");
        this.resolvable = rs.getBoolean("resolvable");
        this.resolvedBy = rs.getInt("resolvedby");
        this.resolvedByDeptCode = DatabaseUtils.getInt(rs, "resolvedby_department_code");
        this.stateId = DatabaseUtils.getInt(rs, "state_id");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.companyName = rs.getString("orgname");
        this.companyEnabled = rs.getBoolean("orgenabled");
        this.orgSiteId = DatabaseUtils.getInt(rs, "orgsiteid");
        this.departmentName = rs.getString("dept");
        this.resolvedByDeptName = rs.getString("resolvedept");
        this.priorityName = rs.getString("ticpri");
        this.severityName = rs.getString("ticsev");
        this.categoryName = rs.getString("catname");
        this.sourceName = rs.getString("sourcename");
        this.serviceContractNumber = rs.getString("contractnumber");
        this.totalHoursRemaining = rs.getFloat("hoursremaining");
        this.contractStartDate = rs.getTimestamp("contractstartdate");
        this.contractEndDate = rs.getTimestamp("contractenddate");
        this.contractOnsiteResponseModel = DatabaseUtils.getInt(rs, "contractonsiteservicemodel");
        this.assetSerialNumber = rs.getString("serialnumber");
        this.assetManufacturerCode = DatabaseUtils.getInt(rs, "assetmanufacturercode");
        this.assetVendorCode = DatabaseUtils.getInt(rs, "assetvendorcode");
        this.assetModelVersion = rs.getString("modelversion");
        this.assetLocation = rs.getString("assetlocation");
        this.assetOnsiteResponseModel = DatabaseUtils.getInt(rs, "assetonsiteservicemodel");
        this.productSku = rs.getString("productsku");
        this.productName = rs.getString("productname");
        this.projectId = DatabaseUtils.getInt(rs, "project_id");
        this.projectName = rs.getString("projectname");
        this.userGroupName = rs.getString("usergroupname");
        this.escalationLevelName = rs.getString("escalationlevelname");
        if (this.entered != null) {
            if (this.closed != null) {
                float ageCheck = (this.closed.getTime() - this.entered.getTime()) / 3600000L;
                int totalHours = Math.round(ageCheck);
                this.ageDays = Math.round(totalHours / 24);
                this.ageHours = Math.round(totalHours - 24 * this.ageDays);
            } else {
                float ageCheck = (System.currentTimeMillis() - this.entered.getTime()) / 3600000L;
                int totalHours = Math.round(ageCheck);
                this.ageDays = Math.round(totalHours / 24);
                this.ageHours = Math.round(totalHours - 24 * this.ageDays);
            }
        }
    }

    public boolean hasFiles() {
        return this.files != null && this.files.size() > 0;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("assignedDate");
        thisList.add("estimatedResolutionDate");
        thisList.add("resolutionDate");
        thisList.add("contractStartDate");
        thisList.add("contractEndDate");
        return thisList;
    }

    public void insertProjectLink(Connection db, int projectId) throws SQLException {
        String sql = "INSERT INTO ticketlink_project (ticket_id, project_id) VALUES (?, ?) ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getId());
        pst.setInt(++i, projectId);
        pst.execute();
        pst.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectTicketCount(Connection db, int projectId) throws SQLException {
        Exception errorMessage = null;
        boolean autoCommit = db.getAutoCommit();
        try {
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            PreparedStatement pst = db.prepareStatement("UPDATE project_ticket_count SET key_count = key_count + 1 WHERE project_id = ? ");
            pst.setInt(++i, projectId);
            pst.execute();
            pst.close();
            i = 0;
            pst = db.prepareStatement("SELECT key_count FROM project_ticket_count WHERE project_id = ? ");
            pst.setInt(++i, projectId);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                this.projectTicketCount = rs.getInt("key_count");
            }
            rs.close();
            pst.close();
            if (autoCommit) {
                db.commit();
            }
        }
        catch (Exception e) {
            errorMessage = e;
            if (autoCommit) {
                db.rollback();
            }
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
        if (errorMessage != null) {
            throw new SQLException(errorMessage.getMessage());
        }
    }

    public String generateWebcalEvent(TimeZone tz, Timestamp created, int type) {
        StringBuffer webcal = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        String description = "";
        if (this.getId() != -1) {
            description = description + "Ticket #: ";
            if (type == 2) {
                description = description + this.getPaddedId();
            } else if (type == 3) {
                description = description + this.getProjectTicketCount();
            }
        }
        if (type == 2) {
            if (this.companyName != null) {
                description = description + "\\nCompany: " + this.companyName;
            }
            if (this.thisContact != null) {
                description = description + "\\nContact: " + this.thisContact.getNameFirstLast();
            }
        } else if (type == 3 && this.projectName != null) {
            description = description + "\\nProject: " + this.projectName;
        }
        webcal.append("BEGIN:VEVENT" + CRLF);
        if (type == 2) {
            webcal.append("UID:www.centriccrm.com-ticket-alerts-" + this.getId() + CRLF);
        } else if (type == 3) {
            webcal.append("UID:www.centriccrm.com-project-ticket-alerts-" + this.getId() + CRLF);
        }
        if (created != null) {
            webcal.append("DTSTAMP:" + ICalendar.getDateTimeUTC((Timestamp)created) + CRLF);
        }
        if (this.entered != null) {
            webcal.append("CREATED:" + ICalendar.getDateTimeUTC((Timestamp)this.entered) + CRLF);
        }
        if (this.estimatedResolutionDate != null) {
            webcal.append("DTSTART;TZID=" + tz.getID() + ":" + ICalendar.getDateTime((TimeZone)tz, (Timestamp)this.estimatedResolutionDate) + CRLF);
        }
        if (this.problem != null) {
            webcal.append(ICalendar.foldLine((String)("SUMMARY:" + ICalendar.parseNewLine((String)this.problem))) + CRLF);
        }
        if (description != null) {
            webcal.append(ICalendar.foldLine((String)("DESCRIPTION:" + description)) + CRLF);
        }
        webcal.append("END:VEVENT" + CRLF);
        return webcal.toString();
    }

    public int getProjectIdByTicket(Connection db) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT project_id FROM ticketlink_project WHERE ticket_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = DatabaseUtils.getInt(rs, "project_id");
        }
        rs.close();
        pst.close();
        return result;
    }
}

