/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.servicecontracts.base.ServiceContract;
import org.aspcfs.modules.servicecontracts.base.ServiceContractHours;
import org.aspcfs.modules.troubletickets.base.TicketPerDayDescription;
import org.aspcfs.modules.troubletickets.base.TicketPerDayDescriptionList;
import org.aspcfs.utils.DatabaseUtils;

public class TicketActivityLog
extends GenericBean {
    private int id = -1;
    private int linkTicketId = -1;
    private String phoneResponseTime = null;
    private String engineerResponseTime = null;
    private Timestamp alertDate = null;
    private String alertDateTimeZone = null;
    private boolean followUpRequired = false;
    private String followUpDescription = null;
    private TicketPerDayDescriptionList ticketPerDayDescriptionList = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private int totalTravelHours = 0;
    private int totalTravelMinutes = 0;
    private int totalLaborHours = 0;
    private int totalLaborMinutes = 0;
    private boolean travelTowardsServiceContract = true;
    private boolean laborTowardsServiceContract = true;
    private Timestamp firstActivityDate = null;
    private Timestamp lastActivityDate = null;
    private boolean override = false;
    private HttpServletRequest request = null;
    private int relatedContractId = -1;

    public TicketActivityLog() {
    }

    public TicketActivityLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkTicketId(int tmp) {
        this.linkTicketId = tmp;
    }

    public void setLinkTicketId(String tmp) {
        this.linkTicketId = Integer.parseInt(tmp);
    }

    public void setPhoneResponseTime(String tmp) {
        this.phoneResponseTime = tmp;
    }

    public void setEngineerResponseTime(String tmp) {
        this.engineerResponseTime = tmp;
    }

    public void setAlertDate(Timestamp tmp) {
        this.alertDate = tmp;
    }

    public void setAlertDate(String tmp) {
        this.alertDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setAlertDateTimeZone(String tmp) {
        this.alertDateTimeZone = tmp;
    }

    public void setFollowUpRequired(String tmp) {
        this.followUpRequired = "true".equalsIgnoreCase(tmp) || "on".equalsIgnoreCase(tmp);
    }

    public void setFollowUpRequired(boolean tmp) {
        this.followUpRequired = tmp;
    }

    public void setFollowUpDescription(String tmp) {
        this.followUpDescription = tmp;
    }

    public void setTicketPerDayDescriptionList(TicketPerDayDescriptionList tmp) {
        this.ticketPerDayDescriptionList = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTotalTravelHours(int tmp) {
        this.totalTravelHours = tmp;
    }

    public void setTotalTravelHours(String tmp) {
        this.totalTravelHours = Integer.parseInt(tmp);
    }

    public void setTotalTravelMinutes(int tmp) {
        this.totalTravelMinutes = tmp;
    }

    public void setTotalTravelMinutes(String tmp) {
        this.totalTravelMinutes = Integer.parseInt(tmp);
    }

    public void setTotalLaborHours(int tmp) {
        this.totalLaborHours = tmp;
    }

    public void setTotalLaborHours(String tmp) {
        this.totalLaborHours = Integer.parseInt(tmp);
    }

    public void setTotalLaborMinutes(int tmp) {
        this.totalLaborMinutes = tmp;
    }

    public void setTotalLaborMinutes(String tmp) {
        this.totalLaborMinutes = Integer.parseInt(tmp);
    }

    public void setTravelTowardsServiceContract(boolean tmp) {
        this.travelTowardsServiceContract = tmp;
    }

    public void setTravelTowardsServiceContract(String tmp) {
        this.travelTowardsServiceContract = "true".equalsIgnoreCase(tmp) || "on".equalsIgnoreCase(tmp);
    }

    public void setLaborTowardsServiceContract(boolean tmp) {
        this.laborTowardsServiceContract = tmp;
    }

    public void setLaborTowardsServiceContract(String tmp) {
        this.laborTowardsServiceContract = "true".equalsIgnoreCase(tmp) || "on".equalsIgnoreCase(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRequestItems(HttpServletRequest request) {
        this.ticketPerDayDescriptionList = new TicketPerDayDescriptionList(request, this.errors);
        this.totalTravelHours = this.ticketPerDayDescriptionList.getTotalTravelHours();
        this.totalTravelMinutes = this.ticketPerDayDescriptionList.getTotalTravelMinutes();
        this.totalLaborHours = this.ticketPerDayDescriptionList.getTotalLaborHours();
        this.totalLaborMinutes = this.ticketPerDayDescriptionList.getTotalLaborMinutes();
    }

    public void setRequest(HttpServletRequest tmp) {
        this.request = tmp;
    }

    public void setRelatedContractId(int tmp) {
        this.relatedContractId = tmp;
    }

    public void setRelatedContractId(String tmp) {
        this.relatedContractId = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getLinkTicketId() {
        return this.linkTicketId;
    }

    public String getPhoneResponseTime() {
        return this.phoneResponseTime;
    }

    public String getEngineerResponseTime() {
        return this.engineerResponseTime;
    }

    public Timestamp getAlertDate() {
        return this.alertDate;
    }

    public String getAlertDateTimeZone() {
        return this.alertDateTimeZone;
    }

    public boolean getFollowUpRequired() {
        return this.followUpRequired;
    }

    public String getFollowUpDescription() {
        return this.followUpDescription;
    }

    public TicketPerDayDescriptionList getTicketPerDayDescriptionList() {
        return this.ticketPerDayDescriptionList;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getTotalTravelHours() {
        return this.totalTravelHours;
    }

    public int getTotalTravelMinutes() {
        return this.totalTravelMinutes;
    }

    public int getTotalLaborHours() {
        return this.totalLaborHours;
    }

    public int getTotalLaborMinutes() {
        return this.totalLaborMinutes;
    }

    public boolean getTravelTowardsServiceContract() {
        return this.travelTowardsServiceContract;
    }

    public boolean getLaborTowardsServiceContract() {
        return this.laborTowardsServiceContract;
    }

    public Timestamp getFirstActivityDate() {
        return this.firstActivityDate;
    }

    public Timestamp getLastActivityDate() {
        return this.lastActivityDate;
    }

    public boolean getOverride() {
        return this.override;
    }

    public void queryRecord(Connection db, int tmpId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT form_id, link_ticket_id, phone_response_time, engineer_response_time, follow_up_required, follow_up_description, alert_date,  entered, enteredby, modified, modifiedby, enabled, travel_towards_sc, labor_towards_sc, alert_date_timezone,  min(activity_date) as firstdate, max(activity_date) as lastdate FROM ticket_csstm_form LEFT JOIN  ticket_activity_item on (link_form_id = form_id) WHERE form_id = ? GROUP BY form_id,link_ticket_id,phone_response_time,engineer_response_time, follow_up_required, follow_up_description, alert_date,  entered, enteredby, modified,modifiedby, enabled, travel_towards_sc, labor_towards_sc, alert_date_timezone ");
        pst.setInt(1, tmpId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        this.buildPerDayDescriptionList(db);
        this.calculateTotalTravelTime();
        this.calculateTotalLaborTime();
    }

    void calculateTotalTravelTime() {
        Iterator itr = this.ticketPerDayDescriptionList.iterator();
        this.totalTravelHours = 0;
        this.totalTravelMinutes = 0;
        while (itr.hasNext()) {
            TicketPerDayDescription thisDay = (TicketPerDayDescription)((Object)itr.next());
            this.totalTravelMinutes += thisDay.getTravelMinutes();
            this.totalTravelHours += thisDay.getTravelHours();
        }
        this.totalTravelHours += this.totalTravelMinutes / 60;
        this.totalTravelMinutes %= 60;
    }

    void calculateTotalLaborTime() {
        Iterator itr = this.ticketPerDayDescriptionList.iterator();
        this.totalLaborHours = 0;
        this.totalLaborMinutes = 0;
        while (itr.hasNext()) {
            TicketPerDayDescription thisDay = (TicketPerDayDescription)((Object)itr.next());
            this.totalLaborMinutes += thisDay.getLaborMinutes();
            this.totalLaborHours += thisDay.getLaborHours();
        }
        this.totalLaborHours += this.totalLaborMinutes / 60;
        this.totalLaborMinutes %= 60;
    }

    public void buildPerDayDescriptionList(Connection db) throws SQLException {
        this.ticketPerDayDescriptionList = new TicketPerDayDescriptionList();
        this.ticketPerDayDescriptionList.setFormId(this.id);
        this.ticketPerDayDescriptionList.buildList(db);
    }

    public boolean deletePerDayDescriptionList(Connection db) throws SQLException {
        this.ticketPerDayDescriptionList = new TicketPerDayDescriptionList();
        this.ticketPerDayDescriptionList.setFormId(this.id);
        this.ticketPerDayDescriptionList.buildList(db);
        return this.ticketPerDayDescriptionList.deleteList(db);
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("alertDate");
        return thisList;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ticket_csstm_form SET phone_response_time = ? , engineer_response_time = ? , follow_up_required = ? , follow_up_description = ? , alert_date = ? , alert_date_timezone = ? , travel_towards_sc = ? , labor_towards_sc = ? ");
            if (!this.override) {
                sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
            }
            sql.append("WHERE form_id = ? ");
            if (!this.override) {
                sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            }
            pst = db.prepareStatement(sql.toString());
            int i = 0;
            pst.setString(++i, this.phoneResponseTime);
            pst.setString(++i, this.engineerResponseTime);
            pst.setBoolean(++i, this.followUpRequired);
            pst.setString(++i, this.followUpDescription);
            pst.setTimestamp(++i, this.alertDate);
            pst.setString(++i, this.alertDateTimeZone);
            pst.setBoolean(++i, this.travelTowardsServiceContract);
            pst.setBoolean(++i, this.laborTowardsServiceContract);
            if (!this.override) {
                pst.setInt(++i, this.modifiedBy);
            }
            pst.setInt(++i, this.id);
            if (!this.override && this.getModified() != null) {
                pst.setTimestamp(++i, this.modified);
            }
            resultCount = pst.executeUpdate();
            pst.close();
            if (resultCount == -1) {
                int n = resultCount;
                return n;
            }
            if (resultCount == 1) {
                TicketPerDayDescriptionList toDeleteDescriptionList = new TicketPerDayDescriptionList();
                toDeleteDescriptionList.setFormId(this.id);
                toDeleteDescriptionList.buildList(db);
                toDeleteDescriptionList.deleteList(db);
                TicketPerDayDescriptionList tmpPerDayDescriptionList = this.getTicketPerDayDescriptionList();
                this.insertPerDayDescriptionList(db, tmpPerDayDescriptionList);
                if (this.request != null) {
                    this.updateServiceContractHours(db);
                }
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public DependencyList processDependencies() {
        DependencyList dependencyList = new DependencyList();
        if (this.followUpRequired) {
            Calendar today = Calendar.getInstance();
            Timestamp timeStampToday = new Timestamp(today.getTimeInMillis());
            Dependency ticDependency = new Dependency();
            if (this.alertDate.compareTo(timeStampToday) > 0) {
                ticDependency.setName("hasFutureAlertDate");
                ticDependency.setCount(1);
                ticDependency.setCanDelete(true);
                dependencyList.add(ticDependency);
            }
        }
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Note Id not specified.");
        }
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.deletePerDayDescriptionList(db);
            PreparedStatement pst = null;
            pst = db.prepareStatement(" DELETE FROM ticket_csstm_form  WHERE form_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            this.reimburseHoursAfterDelete(db);
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            this.id = DatabaseUtils.getNextSeq(db, "ticket_csstm_form_form_id_seq");
            pst = db.prepareStatement("INSERT INTO  ticket_csstm_form (" + (this.id > -1 ? "form_id, " : "") + "link_ticket_id, " + "phone_response_time, " + "engineer_response_time, " + "follow_up_required, " + "follow_up_description, " + "alert_date, " + "alert_date_timezone, " + "enteredby, " + "modifiedby, " + "travel_towards_sc, " + "labor_towards_sc) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?,?,?,?,?)");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.linkTicketId);
            pst.setString(++i, this.phoneResponseTime);
            pst.setString(++i, this.engineerResponseTime);
            pst.setBoolean(++i, this.followUpRequired);
            pst.setString(++i, this.followUpDescription);
            pst.setTimestamp(++i, this.alertDate);
            pst.setString(++i, this.alertDateTimeZone);
            pst.setInt(++i, this.enteredBy);
            pst.setInt(++i, this.modifiedBy);
            pst.setBoolean(++i, this.travelTowardsServiceContract);
            pst.setBoolean(++i, this.laborTowardsServiceContract);
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_csstm_form_form_id_seq", this.id);
            pst.close();
            TicketPerDayDescriptionList tmpPerDayDescriptionList = this.getTicketPerDayDescriptionList();
            this.insertPerDayDescriptionList(db, tmpPerDayDescriptionList);
            if (this.request != null) {
                this.updateServiceContractHours(db);
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void insertPerDayDescriptionList(Connection db, TicketPerDayDescriptionList tmpPerDayDescriptionList) throws SQLException {
        for (TicketPerDayDescription thisPerDayDescription : tmpPerDayDescriptionList) {
            thisPerDayDescription.setLinkFormId(this.id);
            thisPerDayDescription.insert(db);
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("form_id");
        this.linkTicketId = rs.getInt("link_ticket_id");
        this.phoneResponseTime = rs.getString("phone_response_time");
        this.engineerResponseTime = rs.getString("engineer_response_time");
        this.followUpRequired = rs.getBoolean("follow_up_required");
        this.followUpDescription = rs.getString("follow_up_description");
        this.alertDate = rs.getTimestamp("alert_date");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.travelTowardsServiceContract = rs.getBoolean("travel_towards_sc");
        this.laborTowardsServiceContract = rs.getBoolean("labor_towards_sc");
        this.alertDateTimeZone = rs.getString("alert_date_timezone");
        this.firstActivityDate = rs.getTimestamp("firstdate");
        this.lastActivityDate = rs.getTimestamp("lastdate");
    }

    public void updateServiceContractHours(Connection db) throws SQLException {
        if (this.relatedContractId == -1) {
            return;
        }
        String prevTravelTowardsServiceContract = this.request.getParameter("prevTravelTowardsServiceContract");
        String prevLaborTowardsServiceContract = this.request.getParameter("prevLaborTowardsServiceContract");
        String prevTravelMinutes = this.request.getParameter("prevTotalTravelMinutes");
        String prevTravelHours = this.request.getParameter("prevTotalTravelHours");
        String prevLaborMinutes = this.request.getParameter("prevTotalLaborMinutes");
        String prevLaborHours = this.request.getParameter("prevTotalLaborHours");
        int prevTotalHours = 0;
        int prevTotalMinutes = 0;
        double prevHoursUsed = 0.0;
        if ("on".equals(prevLaborTowardsServiceContract) || "true".equals(prevLaborTowardsServiceContract)) {
            prevTotalHours += prevLaborHours == null ? 0 : Integer.parseInt(prevLaborHours);
            prevTotalMinutes += prevLaborMinutes == null ? 0 : Integer.parseInt(prevLaborMinutes);
        }
        if ("on".equals(prevTravelTowardsServiceContract) || "true".equals(prevTravelTowardsServiceContract)) {
            prevTotalHours += prevTravelHours == null ? 0 : Integer.parseInt(prevTravelHours);
            prevTotalMinutes += prevTravelMinutes == null ? 0 : Integer.parseInt(prevTravelMinutes);
        }
        prevHoursUsed = (double)prevTotalHours + (prevTotalMinutes == 0 ? 0.0 : (double)prevTotalMinutes * 1.0 / 60.0);
        String travelTowardsServiceContract = this.request.getParameter("travelTowardsServiceContract");
        String laborTowardsServiceContract = this.request.getParameter("laborTowardsServiceContract");
        int travelMinutes = this.getTotalTravelMinutes();
        int travelHours = this.getTotalTravelHours();
        int laborMinutes = this.getTotalLaborMinutes();
        int laborHours = this.getTotalLaborHours();
        int totalHours = 0;
        int totalMinutes = 0;
        double hoursUsed = 0.0;
        if ("on".equals(laborTowardsServiceContract) || "true".equals(laborTowardsServiceContract)) {
            totalHours += laborHours;
            totalMinutes += laborMinutes;
        }
        if ("on".equals(travelTowardsServiceContract) || "true".equals(travelTowardsServiceContract)) {
            totalHours += travelHours;
            totalMinutes += travelMinutes;
        }
        hoursUsed = (double)totalHours + (totalMinutes == 0 ? 0.0 : (double)totalMinutes * 1.0 / 60.0);
        double netAdjustedHours = prevHoursUsed - hoursUsed;
        ServiceContract.updateHoursRemaining(db, this.relatedContractId, netAdjustedHours);
        ServiceContractHours sch = new ServiceContractHours();
        sch.setServiceContractId(this.relatedContractId);
        sch.setAdjustmentHours(netAdjustedHours);
        sch.setEnteredBy(this.getModifiedBy());
        sch.setModifiedBy(this.getModifiedBy());
        sch.setAdjustmentNotes("Adjusted due to an activity in ticket  #" + this.linkTicketId);
        sch.insert(db);
    }

    public void reimburseHoursAfterDelete(Connection db) throws SQLException {
        if (this.relatedContractId == -1) {
            return;
        }
        int totalHours = 0;
        int totalMinutes = 0;
        double hoursUsed = 0.0;
        if (this.laborTowardsServiceContract) {
            totalHours += this.totalLaborHours;
            totalMinutes += this.totalLaborMinutes;
        }
        if (this.travelTowardsServiceContract) {
            totalHours += this.totalTravelHours;
            totalMinutes += this.totalTravelMinutes;
        }
        hoursUsed = (double)totalHours + (totalMinutes == 0 ? 0.0 : (double)totalMinutes * 1.0 / 60.0);
        ServiceContract.updateHoursRemaining(db, this.relatedContractId, hoursUsed);
        ServiceContractHours sch = new ServiceContractHours();
        sch.setServiceContractId(this.relatedContractId);
        sch.setAdjustmentHours(hoursUsed);
        sch.setEnteredBy(this.getModifiedBy());
        sch.setModifiedBy(this.getModifiedBy());
        sch.setAdjustmentNotes("Reimbursement due to deletion of an activity in ticket  #" + this.linkTicketId);
        sch.insert(db);
    }
}

