/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftList;
import org.aspcfs.utils.DatabaseUtils;

public class TicketCategory
extends GenericBean {
    private int id = -1;
    private int categoryLevel = -1;
    private int parentCode = -1;
    private String description = "";
    private boolean enabled = true;
    private int level = -1;
    private int siteId = -1;
    private TicketCategoryDraftList shortChildList = new TicketCategoryDraftList();

    public TicketCategory() {
    }

    public TicketCategory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TicketCategory(Connection db, int id) throws SQLException {
        if (id < 0) {
            throw new SQLException("Ticket Category not specified");
        }
        String sql = "SELECT tc.* FROM ticket_category tc WHERE tc.id > -1 AND tc.id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Ticket Category record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryLevel(int tmp) {
        this.categoryLevel = tmp;
    }

    public void setCategoryLevel(String tmp) {
        this.categoryLevel = Integer.parseInt(tmp);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLevel(String level) {
        this.level = Integer.parseInt(level);
    }

    public void setParentCode(int tmp) {
        this.parentCode = tmp;
    }

    public void setParentCode(String tmp) {
        this.parentCode = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setShortChildList(TicketCategoryDraftList shortChildList) {
        this.shortChildList = shortChildList;
    }

    public TicketCategoryDraftList getShortChildList() {
        return this.shortChildList;
    }

    public int getLevel() {
        return this.level;
    }

    public int getId() {
        return this.id;
    }

    public int getCategoryLevel() {
        return this.categoryLevel;
    }

    public int getParentCode() {
        return this.parentCode;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        try {
            db.setAutoCommit(false);
            this.id = DatabaseUtils.getNextSeq(db, "ticket_category_id_seq");
            sql.append("INSERT INTO ticket_category (" + (this.id > -1 ? "id, " : "") + "cat_level, parent_cat_code, description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, site_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCategoryLevel());
            if (this.parentCode > 0) {
                pst.setInt(++i, this.getParentCode());
            } else {
                pst.setInt(++i, 0);
            }
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getLevel());
            pst.setBoolean(++i, this.getEnabled());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_category_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Id not specified");
        }
        int i = 0;
        int count = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE ticket_category SET description = ?, cat_level = ?, parent_cat_code = ?, " + DatabaseUtils.addQuotes(db, "level") + " = ?, enabled = ? " + "WHERE  id = ? ");
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getCategoryLevel());
            pst.setInt(++i, this.getParentCode());
            pst.setInt(++i, this.getLevel());
            pst.setBoolean(++i, this.getEnabled());
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.categoryLevel = rs.getInt("cat_level");
        this.parentCode = rs.getInt("parent_cat_code");
        this.description = rs.getString("description");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE from ticket_category_draft WHERE link_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM ticket_category WHERE id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public TicketCategory cloneCategory() {
        TicketCategory category = new TicketCategory();
        category.setCategoryLevel(this.getCategoryLevel());
        category.setDescription(this.getDescription());
        category.setEnabled(this.getEnabled());
        category.setLevel(this.getLevel());
        return category;
    }

    public int lookupCategory(Connection db, String description, int siteId) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT id FROM ticket_category WHERE site_id = ? AND description = ? AND cat_level = ? ");
        pst.setInt(1, siteId);
        pst.setString(2, description);
        pst.setInt(3, this.getCategoryLevel());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = DatabaseUtils.getInt(rs, "id");
        }
        pst.close();
        return result;
    }

    public String toString() {
        return this.getDescription() + "(" + this.getId() + ")";
    }
}

