/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserGroup;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryPlanMapList;
import org.aspcfs.utils.DatabaseUtils;

public class TicketCategoryAssignment
extends GenericBean {
    private int id = -1;
    private int categoryId = -1;
    private int departmentId = -1;
    private int assignedTo = -1;
    private int userGroupId = -1;
    private boolean buildPlanMapList = false;
    private TicketCategoryPlanMapList planMapList = null;
    private UserList users = null;
    private boolean buildDeptUsers = false;
    private boolean buildGroupUsers = false;
    private String userGroupName = null;
    private int siteId = -1;

    public TicketCategoryAssignment() {
    }

    public TicketCategoryAssignment(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TicketCategoryAssignment(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public TicketCategoryAssignment(Connection db, int categoryId, String fieldName) throws SQLException {
        String sql = new String("SELECT tcda.*, ug.group_name FROM ticket_category_assignment tcda LEFT JOIN user_group ug ON (tcda.group_id = ug.group_id) WHERE tcda.category_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, categoryId);
        this.setCategoryId(categoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id < 0) {
            throw new SQLException("Ticket Category Assignment not specified");
        }
        String sql = new String("SELECT tcda.*, ug.group_name FROM ticket_category_assignment tcda LEFT JOIN user_group ug ON (tcda.group_id = ug.group_id) WHERE tcda.map_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Ticket Category Assignment record not found.");
        }
        if (this.buildPlanMapList) {
            this.buildPlanMapList(db);
        }
        if (this.buildDeptUsers) {
            this.buildDepartmentUsers(db);
        } else if (this.buildGroupUsers) {
            this.buildGroupUsers(db);
        }
    }

    public void buildDepartmentUsers(Connection db) throws SQLException {
        this.users = new UserList();
        this.users.setHidden(0);
        this.users.setRoleType(0);
        this.users.setDepartment(this.getDepartmentId());
        this.users.setIncludeUsersWithAccessToAllSites(true);
        this.users.setSiteId(this.siteId);
        if (this.getDepartmentId() > -1) {
            this.users.buildList(db);
        }
    }

    public void buildGroupUsers(Connection db) throws SQLException {
        this.users = new UserList();
        this.users.setHidden(0);
        this.users.setExcludeDisabledIfUnselected(true);
        this.users.setExcludeExpiredIfUnselected(true);
        this.users.setRoleType(0);
        this.users.setUserGroupId(this.getUserGroupId());
        this.users.setIncludeUsersWithAccessToAllSites(true);
        this.users.setSiteId(this.siteId);
        if (this.getUserGroupId() > -1) {
            this.users.buildList(db);
        }
    }

    public void buildPlanMapList(Connection db) throws SQLException {
        this.planMapList = new TicketCategoryPlanMapList();
        this.planMapList.setCategoryId(this.getCategoryId());
        this.planMapList.buildList(db);
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("map_id");
        this.categoryId = rs.getInt("category_id");
        this.departmentId = DatabaseUtils.getInt(rs, "department_id", 0);
        this.assignedTo = DatabaseUtils.getInt(rs, "assigned_to");
        this.userGroupId = DatabaseUtils.getInt(rs, "group_id");
        this.userGroupName = rs.getString("group_name");
    }

    public boolean insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "ticket_category_assignment_map_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO ticket_category_assignment (" + (this.id > -1 ? "map_id, " : "") + "category_id, department_id, assigned_to, group_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCategoryId());
            DatabaseUtils.setInt(pst, ++i, this.departmentId == 0 ? -1 : this.departmentId);
            DatabaseUtils.setInt(pst, ++i, this.assignedTo);
            DatabaseUtils.setInt(pst, ++i, this.userGroupId);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_category_assignment_map_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Ticket Category Assignment Id not specified");
        }
        int i = 0;
        int count = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE ticket_category_assignment SET category_id = ?, department_id = ?, assigned_to = ?, group_id = ? WHERE  map_id = ? ");
            pst.setInt(++i, this.getCategoryId());
            DatabaseUtils.setInt(pst, ++i, this.departmentId == 0 ? -1 : this.departmentId);
            DatabaseUtils.setInt(pst, ++i, this.assignedTo);
            DatabaseUtils.setInt(pst, ++i, this.userGroupId);
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Ticket Category Assignment Id not specified");
        }
        PreparedStatement pst = null;
        boolean recordCount = false;
        pst = db.prepareStatement("DELETE FROM ticket_category_assignment WHERE map_id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        return recordCount;
    }

    public void copyAssignment(TicketCategoryDraftAssignment draftAssignment) {
        this.departmentId = draftAssignment.getDepartmentId();
        this.assignedTo = draftAssignment.getAssignedTo();
        this.userGroupId = draftAssignment.getUserGroupId();
    }

    public TicketCategoryAssignment cloneAssignment(Connection db, int siteId) throws SQLException {
        UserGroup group;
        User user;
        TicketCategoryAssignment assignment = new TicketCategoryAssignment();
        if (this.getAssignedTo() != -1 && ((user = new User(db, this.getAssignedTo())).getSiteId() == -1 || user.getSiteId() == siteId)) {
            assignment.setAssignedTo(this.getAssignedTo());
        }
        if (this.getUserGroupId() != -1 && ((group = new UserGroup(db, this.getUserGroupId())).getSiteId() == -1 || group.getSiteId() == siteId)) {
            assignment.setUserGroupId(this.getUserGroupId());
            assignment.setUserGroupName(this.getUserGroupName());
        }
        assignment.setDepartmentId(this.getDepartmentId());
        if (assignment.getAssignedTo() == -1 && assignment.getUserGroupId() == -1 && assignment.getDepartmentId() == -1) {
            return null;
        }
        return assignment;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(int tmp) {
        this.departmentId = tmp;
    }

    public void setDepartmentId(String tmp) {
        this.departmentId = Integer.parseInt(tmp);
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(int tmp) {
        this.assignedTo = tmp;
    }

    public void setAssignedTo(String tmp) {
        this.assignedTo = Integer.parseInt(tmp);
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public boolean getBuildPlanMapList() {
        return this.buildPlanMapList;
    }

    public void setBuildPlanMapList(boolean tmp) {
        this.buildPlanMapList = tmp;
    }

    public void setBuildPlanMapList(String tmp) {
        this.buildPlanMapList = DatabaseUtils.parseBoolean(tmp);
    }

    public TicketCategoryPlanMapList getPlanMapList() {
        return this.planMapList;
    }

    public void setPlanMapList(TicketCategoryPlanMapList tmp) {
        this.planMapList = tmp;
    }

    public UserList getUsers() {
        return this.users;
    }

    public void setUsers(UserList tmp) {
        this.users = tmp;
    }

    public boolean getBuildDeptUsers() {
        return this.buildDeptUsers;
    }

    public void setBuildDeptUsers(boolean tmp) {
        this.buildDeptUsers = tmp;
    }

    public void setBuildDeptUsers(String tmp) {
        this.buildDeptUsers = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildGroupUsers() {
        return this.buildGroupUsers;
    }

    public void setBuildGroupUsers(boolean tmp) {
        this.buildGroupUsers = tmp;
    }

    public void setBuildGroupUsers(String tmp) {
        this.buildGroupUsers = DatabaseUtils.parseBoolean(tmp);
    }

    public String getUserGroupName() {
        return this.userGroupName;
    }

    public void setUserGroupName(String tmp) {
        this.userGroupName = tmp;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }
}

