/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryAssignment;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketCategoryAssignmentList
extends ArrayList {
    PagedListInfo pagedListInfo = null;
    protected int id = -1;
    protected int categoryId = -1;
    protected int departmentId = -1;
    protected int assignedTo = -1;
    protected int userGroupId = -1;
    protected boolean checkSite = false;
    protected int siteId = -1;
    protected boolean exclusiveToSite = false;
    protected boolean buildPlanMapList = false;
    public static final String tableName = "ticket_category_assignment";
    public static final String uniqueField = "map_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM ticket_category_assignment tcda  LEFT JOIN user_group ug ON (tcda.group_id = ug.group_id)  WHERE tcda.map_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("tcda.map_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY tcda.map_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" tcda.*, ug.group_name  FROM ticket_category_assignment tcda  LEFT JOIN user_group ug ON (tcda.group_id = ug.group_id)  WHERE tcda.map_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            TicketCategoryAssignment thisMap = new TicketCategoryAssignment(rs);
            this.add(thisMap);
        }
        rs.close();
        pst.close();
        if (this.buildPlanMapList) {
            for (TicketCategoryAssignment assignment : this) {
                assignment.buildPlanMapList(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND tcda.map_id = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND tcda.category_id = ? ");
        }
        if (this.departmentId > -1) {
            if (this.departmentId == 0) {
                sqlFilter.append("AND tcda.department_id IS NULL ");
            } else {
                sqlFilter.append("AND tcda.department_id = ? ");
            }
        }
        if (this.assignedTo > -1) {
            sqlFilter.append("AND tcda.assigned_to = ? ");
        }
        if (this.userGroupId > -1) {
            sqlFilter.append("AND tcda.group_id = ? ");
        }
        if (this.checkSite) {
            if (this.siteId > -1) {
                sqlFilter.append("AND tcda.category_id IN (SELECT id FROM ticket_category tc WHERE tc.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR tc.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append("AND tcda.category_id IN (SELECT id FROM ticket_category tc WHERE tc.site_id IS NULL) ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.departmentId > 0) {
            pst.setInt(++i, this.departmentId);
        }
        if (this.assignedTo > -1) {
            pst.setInt(++i, this.assignedTo);
        }
        if (this.userGroupId > -1) {
            pst.setInt(++i, this.userGroupId);
        }
        if (this.checkSite && this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(int tmp) {
        this.departmentId = tmp;
    }

    public void setDepartmentId(String tmp) {
        this.departmentId = Integer.parseInt(tmp);
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(int tmp) {
        this.assignedTo = tmp;
    }

    public void setAssignedTo(String tmp) {
        this.assignedTo = Integer.parseInt(tmp);
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public boolean getBuildPlanMapList() {
        return this.buildPlanMapList;
    }

    public void setBuildPlanMapList(boolean tmp) {
        this.buildPlanMapList = tmp;
    }

    public void setBuildPlanMapList(String tmp) {
        this.buildPlanMapList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getCheckSite() {
        return this.checkSite;
    }

    public void setCheckSite(boolean tmp) {
        this.checkSite = tmp;
    }

    public void setCheckSite(String tmp) {
        this.checkSite = DatabaseUtils.parseBoolean(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }
}

