/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftPlanMap;
import org.aspcfs.utils.DatabaseUtils;

public class TicketCategoryDraft
extends GenericBean {
    private int id = -1;
    private int actualCatId = -1;
    private int categoryLevel = -1;
    private int parentCode = -1;
    private String description = "";
    private boolean enabled = true;
    private int level = 0;
    private int siteId = -1;
    private TicketCategoryDraftList shortChildList = new TicketCategoryDraftList();
    private String baseTableName = "ticket_category_draft";

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String tmp) {
        this.baseTableName = tmp;
    }

    public TicketCategoryDraft() {
    }

    public TicketCategoryDraft(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TicketCategoryDraft(Connection db, int id) throws SQLException {
        this.queryRecord(db, id, "ticket_category");
    }

    public TicketCategoryDraft(Connection db, int id, String tableName) throws SQLException {
        this.queryRecord(db, id, tableName);
    }

    public void queryRecord(Connection db, int id, String tableName) throws SQLException {
        if (id < 0) {
            throw new SQLException("Ticket Category not specified");
        }
        String sql = "SELECT tc.* FROM " + DatabaseUtils.getTableName(db, tableName + "_draft") + " tc " + "WHERE tc.id > -1 " + "AND tc.id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Ticket Category Draft record not found.");
        }
    }

    public TicketCategoryDraft(Connection db, int id, String tableName, int siteId) throws SQLException {
        if (id < 0) {
            throw new SQLException("Ticket Category not specified");
        }
        String sql = "SELECT tc.* FROM " + DatabaseUtils.getTableName(db, tableName + "_draft") + " tc " + "WHERE tc.id > -1 " + "AND tc.id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Ticket Category Draft record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryLevel(int tmp) {
        this.categoryLevel = tmp;
    }

    public void setCategoryLevel(String tmp) {
        this.categoryLevel = Integer.parseInt(tmp);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLevel(String level) {
        this.level = Integer.parseInt(level);
    }

    public void setParentCode(int tmp) {
        this.parentCode = tmp;
    }

    public void setParentCode(String tmp) {
        this.parentCode = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setActualCatId(int actualCatId) {
        this.actualCatId = actualCatId;
    }

    public void setActualCatId(String actualCatId) {
        this.actualCatId = Integer.parseInt(actualCatId);
    }

    public void setShortChildList(TicketCategoryDraftList shortChildList) {
        this.shortChildList = shortChildList;
    }

    public TicketCategoryDraftList getShortChildList() {
        return this.shortChildList;
    }

    public int getActualCatId() {
        return this.actualCatId;
    }

    public int getLevel() {
        return this.level;
    }

    public int getId() {
        return this.id;
    }

    public int getCategoryLevel() {
        return this.categoryLevel;
    }

    public int getParentCode() {
        return this.parentCode;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean insert(Connection db) throws SQLException {
        return this.insert(db, this.baseTableName);
    }

    public boolean insert(Connection db, String baseTableName) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (baseTableName == null) {
                baseTableName = "ticket_category_draft";
            }
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, baseTableName + "_draft_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO " + DatabaseUtils.getTableName(db, baseTableName + "_draft") + " " + "(" + (this.id > -1 ? "id, " : "") + "cat_level, link_id, parent_cat_code, description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, site_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCategoryLevel());
            DatabaseUtils.setInt(pst, ++i, this.getActualCatId());
            if (this.parentCode > 0) {
                pst.setInt(++i, this.getParentCode());
            } else {
                pst.setInt(++i, 0);
            }
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getLevel());
            pst.setBoolean(++i, this.getEnabled());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, baseTableName + "_draft_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db, String tableName) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Id not specified");
        }
        int i = 0;
        int count = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE " + tableName + "_draft " + "SET description = ?, cat_level = ?, " + DatabaseUtils.addQuotes(db, "level") + " = ?, " + (this.actualCatId != -1 ? "link_id = ?," : "") + " enabled = ? " + "WHERE  id = ? ");
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getCategoryLevel());
            pst.setInt(++i, this.getLevel());
            if (this.actualCatId != -1) {
                DatabaseUtils.setInt(pst, ++i, this.getActualCatId());
            }
            pst.setBoolean(++i, this.getEnabled());
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db, String tableName) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Category Id not specified");
        }
        PreparedStatement pst = null;
        int recordCount = 0;
        if (tableName.equals("ticket_category")) {
            pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.getTableName(db, tableName + "_draft_plan_map") + " " + "WHERE category_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.getTableName(db, "ticket_category_draft_assignment") + " " + "WHERE category_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
        }
        pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.getTableName(db, tableName + "_draft") + " " + "WHERE id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public void removeChild(int childId) {
        TicketCategoryDraft child = null;
        for (TicketCategoryDraft tmpCategory : this.shortChildList) {
            if (tmpCategory.getId() != childId) continue;
            child = tmpCategory;
        }
        if (child != null) {
            this.shortChildList.remove((Object)child);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.actualCatId = rs.getInt("link_id");
        this.categoryLevel = rs.getInt("cat_level");
        this.parentCode = rs.getInt("parent_cat_code");
        this.description = rs.getString("description");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
    }

    public void insertPlan(Connection db, int planId, String tableName) throws SQLException {
        TicketCategoryDraftPlanMap draftPlanMap = null;
        int mapId = -1;
        if (tableName.equals("ticket_category")) {
            draftPlanMap = new TicketCategoryDraftPlanMap(db, this.getId(), planId);
            if (draftPlanMap.getId() != -1) {
                mapId = draftPlanMap.getId();
            }
            if (mapId == -1) {
                draftPlanMap = new TicketCategoryDraftPlanMap();
                draftPlanMap.setPlanId(planId);
                draftPlanMap.setCategoryId(this.getId());
                draftPlanMap.insert(db);
            }
        }
    }

    public void insertAssignment(Connection db, int fieldId, String tableName, String fieldName) throws SQLException {
        TicketCategoryDraftAssignment assignment = null;
        int mapId = -1;
        if (tableName.equals("ticket_category")) {
            assignment = new TicketCategoryDraftAssignment(db, this.getId(), null);
            if (assignment.getId() != -1) {
                mapId = assignment.getId();
            }
            if (mapId == -1) {
                assignment = new TicketCategoryDraftAssignment();
                assignment.setCategoryId(this.getId());
                assignment.setFieldId(fieldId, fieldName);
                assignment.insert(db);
            } else if (!assignment.checkField(fieldId, fieldName)) {
                assignment.update(db);
            }
        }
    }

    public int getPlanMapId(Connection db, String tableName) throws SQLException {
        int mapId = -1;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT map_id FROM " + DatabaseUtils.getTableName(db, tableName + "_draft_plan_map") + " " + "WHERE category_id = ? ");
        pst.setInt(1, this.getId());
        rs = pst.executeQuery();
        if (rs.next()) {
            mapId = rs.getInt("map_id");
        }
        rs.close();
        pst.close();
        return mapId;
    }

    public TicketCategoryDraft(Connection db, String tableName, int linkId, boolean buildOnLinkId) throws SQLException {
        if (linkId < 0) {
            throw new SQLException("Ticket Category not specified");
        }
        String sql = "SELECT tc.* FROM " + DatabaseUtils.getTableName(db, tableName + "_draft") + " tc " + "WHERE tc.link_id > -1 " + "AND tc.link_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, linkId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Ticket Category Draft record not found.");
        }
    }

    public String toString() {
        return this.getDescription();
    }
}

