/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.troubletickets.base.TicketCategoryAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftPlanMapList;
import org.aspcfs.utils.DatabaseUtils;

public class TicketCategoryDraftAssignment
extends GenericBean {
    public static final String DEPARTMENT = "department_id";
    public static final String USER = "assigned_to";
    public static final String GROUP = "group_id";
    private int id = -1;
    private int categoryId = -1;
    private int departmentId = -1;
    private int assignedTo = -1;
    private int userGroupId = -1;
    private boolean buildPlanMapList = false;
    private TicketCategoryDraftPlanMapList planMapList = null;
    private String userGroupName = null;

    public TicketCategoryDraftAssignment() {
    }

    public TicketCategoryDraftAssignment(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TicketCategoryDraftAssignment(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public TicketCategoryDraftAssignment(Connection db, int categoryId, String fieldName) throws SQLException {
        String sql = new String("SELECT tcda.*, ug.group_name FROM " + DatabaseUtils.getTableName(db, "ticket_category_draft_assignment") + " tcda " + "LEFT JOIN user_group ug ON (tcda.group_id = ug.group_id) " + "WHERE tcda.category_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, categoryId);
        this.setCategoryId(categoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id < 0) {
            throw new SQLException("Ticket Category Draft Assignment not specified");
        }
        String sql = new String("SELECT tcda.*, ug.group_name FROM " + DatabaseUtils.getTableName(db, "ticket_category_draft_assignment") + " tcda " + "LEFT JOIN user_group ug ON (tcda.group_id = ug.group_id) " + "WHERE tcda.map_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Ticket Category Draft Assignment record not found.");
        }
        if (this.buildPlanMapList) {
            this.buildPlanMapList(db);
        }
    }

    public void buildPlanMapList(Connection db) throws SQLException {
        this.planMapList = new TicketCategoryDraftPlanMapList();
        this.planMapList.setBuildPlan(true);
        this.planMapList.setCategoryId(this.getCategoryId());
        if (this.getCategoryId() > -1) {
            this.planMapList.buildList(db);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("map_id");
        this.categoryId = rs.getInt("category_id");
        this.departmentId = DatabaseUtils.getInt(rs, DEPARTMENT, 0);
        this.assignedTo = DatabaseUtils.getInt(rs, USER);
        this.userGroupId = DatabaseUtils.getInt(rs, GROUP);
        this.userGroupName = rs.getString("group_name");
    }

    public boolean insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "ticket_category_draft_assignment_map_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO " + DatabaseUtils.getTableName(db, "ticket_category_draft_assignment") + " " + "(" + (this.id > -1 ? "map_id, " : "") + "category_id, department_id, assigned_to, group_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCategoryId());
            DatabaseUtils.setInt(pst, ++i, this.departmentId == 0 ? -1 : this.departmentId);
            DatabaseUtils.setInt(pst, ++i, this.assignedTo);
            DatabaseUtils.setInt(pst, ++i, this.userGroupId);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_category_draft_assignment_map_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Ticket Category Draft Assignment Id not specified");
        }
        int i = 0;
        int count = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE " + DatabaseUtils.getTableName(db, "ticket_category_draft_assignment") + " " + "SET category_id = ?, department_id = ?, assigned_to = ?, group_id = ? " + "WHERE  map_id = ? ");
            pst.setInt(++i, this.getCategoryId());
            DatabaseUtils.setInt(pst, ++i, this.departmentId == 0 ? -1 : this.departmentId);
            DatabaseUtils.setInt(pst, ++i, this.assignedTo);
            DatabaseUtils.setInt(pst, ++i, this.userGroupId);
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Ticket Category Draft Assignment Id not specified");
        }
        PreparedStatement pst = null;
        boolean recordCount = false;
        pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.getTableName(db, "ticket_category_draft_assignment") + " " + "WHERE map_id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        return recordCount;
    }

    public void setFieldId(int fieldId, String fieldName) {
        if (fieldName != null && fieldName.equals(DEPARTMENT)) {
            this.departmentId = fieldId;
        } else if (fieldName != null && fieldName.equals(USER)) {
            this.assignedTo = fieldId;
        } else if (fieldName != null && fieldName.equals(GROUP)) {
            this.userGroupId = fieldId;
        }
    }

    public boolean checkField(int fieldId, String fieldName) {
        if (fieldName != null && fieldName.equals(DEPARTMENT)) {
            return this.departmentId == fieldId;
        }
        if (fieldName != null && fieldName.equals(USER)) {
            return this.assignedTo == fieldId;
        }
        if (fieldName != null && fieldName.equals(GROUP)) {
            return this.userGroupId == fieldId;
        }
        return true;
    }

    public void copyAssignment(TicketCategoryAssignment assignment) {
        this.departmentId = assignment.getDepartmentId();
        this.assignedTo = assignment.getAssignedTo();
        this.userGroupId = assignment.getUserGroupId();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(int tmp) {
        this.departmentId = tmp;
    }

    public void setDepartmentId(String tmp) {
        this.departmentId = Integer.parseInt(tmp);
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(int tmp) {
        this.assignedTo = tmp;
    }

    public void setAssignedTo(String tmp) {
        this.assignedTo = Integer.parseInt(tmp);
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public boolean getBuildPlanMapList() {
        return this.buildPlanMapList;
    }

    public void setBuildPlanMapList(boolean tmp) {
        this.buildPlanMapList = tmp;
    }

    public void setBuildPlanMapList(String tmp) {
        this.buildPlanMapList = DatabaseUtils.parseBoolean(tmp);
    }

    public TicketCategoryDraftPlanMapList getPlanMapList() {
        return this.planMapList;
    }

    public void setPlanMapList(TicketCategoryDraftPlanMapList tmp) {
        this.planMapList = tmp;
    }

    public String getUserGroupName() {
        return this.userGroupName;
    }

    public void setUserGroupName(String tmp) {
        this.userGroupName = tmp;
    }

    public String toString() {
        return "" + this.getId();
    }
}

