/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraft;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketCategoryDraftList
extends ArrayList {
    public static final String tableName = "ticket_category_draft";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    HtmlSelect catListSelect = new HtmlSelect();
    private PagedListInfo pagedListInfo = null;
    private int parentCode = -1;
    private int catLevel = -1;
    private String htmlJsEvent = "";
    private int enabledState = -1;
    private boolean topLevelOnly = false;
    private boolean buildHierarchy = false;
    private String noneLabel = null;
    private int siteId = -1;
    private boolean exclusiveToSite = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setHtmlJsEvent(String htmlJsEvent) {
        this.htmlJsEvent = htmlJsEvent;
    }

    public void setCatListSelect(HtmlSelect catListSelect) {
        this.catListSelect = catListSelect;
    }

    public void setParentCode(int tmp) {
        this.parentCode = tmp;
    }

    public void setParentCode(String tmp) {
        this.parentCode = Integer.parseInt(tmp);
    }

    public void setCatLevel(int catLevel) {
        this.catLevel = catLevel;
    }

    public void setCatLevel(String catLevel) {
        this.catLevel = Integer.parseInt(catLevel);
    }

    public void setEnabledState(int tmp) {
        this.enabledState = tmp;
    }

    public void setBuildHierarchy(boolean buildHierarchy) {
        this.buildHierarchy = buildHierarchy;
    }

    public void setTopLevelOnly(boolean topLevelOnly) {
        this.topLevelOnly = topLevelOnly;
    }

    public boolean getTopLevelOnly() {
        return this.topLevelOnly;
    }

    public boolean getBuildHierarchy() {
        return this.buildHierarchy;
    }

    public HtmlSelect getCatListSelect() {
        return this.catListSelect;
    }

    public String getHtmlJsEvent() {
        return this.htmlJsEvent;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public int getCatLevel() {
        return this.catLevel;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getParentCode() {
        return this.parentCode;
    }

    public int getEnabledState() {
        return this.enabledState;
    }

    public String getNoneLabel() {
        return this.noneLabel;
    }

    public void setNoneLabel(String tmp) {
        this.noneLabel = tmp;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        Iterator i = this.iterator();
        this.catListSelect.clear();
        this.catListSelect.addAttribute(uniqueField, selectName);
        if (i.hasNext()) {
            while (i.hasNext()) {
                TicketCategoryDraft thisCat = (TicketCategoryDraft)((Object)i.next());
                String elementText = thisCat.getDescription();
                HashMap<String, String> colorAttribute = new HashMap<String, String>();
                if (!thisCat.getEnabled()) {
                    colorAttribute.put("style", "color: red");
                } else if (thisCat.getActualCatId() == -1) {
                    colorAttribute.put("style", "color: blue");
                }
                this.catListSelect.addItem(thisCat.getId(), elementText, colorAttribute);
            }
        } else if (this.noneLabel != null && !"".equals(this.noneLabel.trim())) {
            this.catListSelect.addItem(-1, this.noneLabel);
        } else {
            this.catListSelect.addItem(-1, "---------None---------");
        }
        this.catListSelect.setJsEvent(this.getHtmlJsEvent());
        this.catListSelect.setBuilt(false);
        return this.catListSelect.getHtml(selectName, defaultKey);
    }

    public void buildList(Connection db, String tableName) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + DatabaseUtils.getTableName(db, tableName + "_draft") + " tc " + "WHERE tc.id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND tc.id < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("tc.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY tc.description");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("tc.* FROM " + DatabaseUtils.getTableName(db, tableName + "_draft") + " tc " + "WHERE tc.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            TicketCategoryDraft thisCat = new TicketCategoryDraft(rs);
            thisCat.setBaseTableName(tableName);
            this.add(thisCat);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabledState > -1) {
            sqlFilter.append("AND tc.enabled = ? ");
        }
        if (this.parentCode != -1) {
            sqlFilter.append("AND tc.parent_cat_code = ? ");
        }
        if (this.catLevel != -1) {
            sqlFilter.append("AND tc.cat_level = ? ");
        }
        if (this.siteId > -1) {
            sqlFilter.append("AND (tc.site_id = ? ");
            if (!this.exclusiveToSite) {
                sqlFilter.append("OR tc.site_id IS NULL ");
            }
            sqlFilter.append(") ");
        } else {
            sqlFilter.append("AND tc.site_id IS NULL ");
        }
        if (this.topLevelOnly) {
            sqlFilter.append("AND tc.parent_cat_code = 0 ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabledState > -1) {
            pst.setBoolean(++i, this.enabledState == 1);
        }
        if (this.parentCode != -1) {
            pst.setInt(++i, this.parentCode);
        }
        if (this.catLevel != -1) {
            pst.setInt(++i, this.catLevel);
        }
        if (this.siteId > -1) {
            pst.setInt(++i, this.getSiteId());
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public static boolean deleteDraft(Connection db, String baseTableName, int siteId) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            if (baseTableName.equals("ticket_category")) {
                pst = db.prepareStatement("DELETE FROM ticket_category_draft_plan_map WHERE category_id IN (SELECT id FROM ticket_category_draft WHERE " + (siteId == -1 ? "site_id IS NULL" : "site_id = ?") + ") ");
                if (siteId > -1) {
                    pst.setInt(1, siteId);
                }
                pst.execute();
                pst.close();
                pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.getTableName(db, "ticket_category_draft_assignment") + " " + "WHERE category_id IN (SELECT id FROM ticket_category_draft WHERE " + (siteId == -1 ? "site_id IS NULL" : "site_id = ?") + ") ");
                if (siteId > -1) {
                    pst.setInt(1, siteId);
                }
                pst.execute();
                pst.close();
            }
            pst = db.prepareStatement("DELETE from " + DatabaseUtils.getTableName(db, baseTableName + "_draft") + " " + "WHERE " + (siteId == -1 ? "site_id IS NULL" : "site_id = ?"));
            if (siteId > -1) {
                pst.setInt(1, siteId);
            }
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }
}

