/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.utils.DatabaseUtils;

public class TicketCategoryDraftPlanMap
extends GenericBean {
    private int id = -1;
    private int categoryId = -1;
    private int planId = -1;
    private boolean buildActionPlan = false;
    private ActionPlan plan = null;

    public TicketCategoryDraftPlanMap() {
    }

    public TicketCategoryDraftPlanMap(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TicketCategoryDraftPlanMap(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public TicketCategoryDraftPlanMap(Connection db, int pId, int catId) throws SQLException {
        String sql = new String("SELECT tdpm.* FROM ticket_category_draft_plan_map tdpm WHERE tdpm.plan_id = ? AND tdpm.category_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, pId);
        pst.setInt(2, catId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id < 0) {
            throw new SQLException("Ticket Category Draft Plan Map not specified");
        }
        String sql = new String("SELECT tdpm.* FROM ticket_category_draft_plan_map tdpm WHERE tdpm.map_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Ticket Category Draft Plan Map record not found.");
        }
        if (this.buildActionPlan) {
            this.buildActionPlan(db);
        }
    }

    public void buildActionPlan(Connection db) throws SQLException {
        this.plan = new ActionPlan(db, this.planId);
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("map_id");
        this.planId = rs.getInt("plan_id");
        this.categoryId = rs.getInt("category_id");
    }

    public boolean insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "ticket_category_draft_plan_map_map_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO ticket_category_draft_plan_map (" + (this.id > -1 ? "map_id, " : "") + "category_id, plan_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCategoryId());
            pst.setInt(++i, this.getPlanId());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_category_draft_plan_map_map_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db, String tableName) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Ticket Category Draft Plan Map Id not specified");
        }
        int i = 0;
        int count = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE ticket_category_draft_plan_map SET category_id = ?, plan_id = ? WHERE  map_id = ? ");
            pst.setInt(++i, this.getCategoryId());
            pst.setInt(++i, this.getPlanId());
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Ticket Category Draft Plan Map Id not specified");
        }
        PreparedStatement pst = null;
        boolean recordCount = false;
        pst = db.prepareStatement("DELETE FROM ticket_category_draft_plan_map WHERE map_id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        return recordCount;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getPlanId() {
        return this.planId;
    }

    public void setPlanId(int tmp) {
        this.planId = tmp;
    }

    public void setPlanId(String tmp) {
        this.planId = Integer.parseInt(tmp);
    }

    public boolean getBuildActionPlan() {
        return this.buildActionPlan;
    }

    public void setBuildActionPlan(boolean tmp) {
        this.buildActionPlan = tmp;
    }

    public void setBuildActionPlan(String tmp) {
        this.buildActionPlan = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionPlan getPlan() {
        return this.plan;
    }

    public void setPlan(ActionPlan tmp) {
        this.plan = tmp;
    }
}

