/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftPlanMap;
import org.aspcfs.modules.troubletickets.base.TicketCategoryPlanMap;
import org.aspcfs.modules.troubletickets.base.TicketCategoryPlanMapList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketCategoryDraftPlanMapList
extends ArrayList {
    PagedListInfo pagedListInfo = null;
    protected int id = -1;
    protected int categoryId = -1;
    protected int planId = -1;
    protected boolean buildPlan = false;
    public static final String tableName = "ticket_category_draft_plan_map";
    public static final String uniqueField = "map_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM ticket_category_draft_plan_map tdpm  WHERE tdpm.map_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("tdpm.map_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY tdpm.map_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" tdpm.*  FROM ticket_category_draft_plan_map tdpm  WHERE tdpm.map_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            TicketCategoryDraftPlanMap thisMap = new TicketCategoryDraftPlanMap(rs);
            this.add(thisMap);
        }
        rs.close();
        pst.close();
        if (this.buildPlan) {
            for (TicketCategoryDraftPlanMap planMap : this) {
                planMap.buildActionPlan(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND tdpm.map_id = ? ");
        }
        if (this.planId > -1) {
            sqlFilter.append("AND tdpm.plan_id = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND tdpm.category_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.planId > -1) {
            pst.setInt(++i, this.planId);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean parsePlans(Connection db, HashMap map) throws SQLException {
        Iterator<Object> iter = this.iterator();
        while (iter.hasNext()) {
            TicketCategoryDraftPlanMap planMap = (TicketCategoryDraftPlanMap)((Object)iter.next());
            if (map.get(new Integer(planMap.getPlanId())) != null) {
                map.remove(new Integer(planMap.getPlanId()));
                continue;
            }
            planMap.delete(db);
            iter.remove();
        }
        for (Integer key : map.keySet()) {
            TicketCategoryDraftPlanMap planMap = new TicketCategoryDraftPlanMap();
            planMap.setCategoryId(this.getCategoryId());
            planMap.setPlanId(key);
            planMap.insert(db);
        }
        return true;
    }

    public void parseDraftPlans(Connection db, TicketCategoryPlanMapList mapList) throws SQLException {
        try {
            if (mapList.size() <= 0) {
                return;
            }
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                TicketCategoryDraftPlanMap draftPlanMap = (TicketCategoryDraftPlanMap)((Object)iter.next());
                TicketCategoryPlanMap planMap = mapList.getMapByPlanId(draftPlanMap.getPlanId());
                if (planMap != null) {
                    boolean removed = mapList.removeMapById(planMap.getId());
                    continue;
                }
                draftPlanMap.delete(db);
                iter.remove();
            }
            for (TicketCategoryPlanMap map : mapList) {
                TicketCategoryDraftPlanMap draftPlanMap = new TicketCategoryDraftPlanMap();
                draftPlanMap.setPlanId(map.getPlanId());
                draftPlanMap.setCategoryId(this.getCategoryId());
                draftPlanMap.insert(db);
                this.add(draftPlanMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
    }

    public TicketCategoryDraftPlanMap getMapByPlanId(int pId) {
        TicketCategoryDraftPlanMap result = null;
        for (TicketCategoryDraftPlanMap map : this) {
            if (map.getPlanId() != pId) continue;
            result = map;
            break;
        }
        return result;
    }

    public boolean removeMapById(int mapId) {
        boolean result = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            TicketCategoryDraftPlanMap map = (TicketCategoryDraftPlanMap)((Object)iter.next());
            if (map.getId() != mapId) continue;
            iter.remove();
            result = this.remove((Object)map);
            break;
        }
        return result;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getPlanId() {
        return this.planId;
    }

    public void setPlanId(int tmp) {
        this.planId = tmp;
    }

    public void setPlanId(String tmp) {
        this.planId = Integer.parseInt(tmp);
    }

    public boolean getBuildPlan() {
        return this.buildPlan;
    }

    public void setBuildPlan(boolean tmp) {
        this.buildPlan = tmp;
    }

    public void setBuildPlan(String tmp) {
        this.buildPlan = DatabaseUtils.parseBoolean(tmp);
    }
}

