/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.modules.troubletickets.base.TicketCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketCategoryList
extends Vector {
    HtmlSelect catListSelect = new HtmlSelect();
    private PagedListInfo pagedListInfo = null;
    private int parentCode = -1;
    private int catLevel = -1;
    private String HtmlJsEvent = "";
    private int enabledState = -1;
    private boolean includeDisabled = false;
    private int siteId = -1;
    private boolean exclusiveToSite = false;
    private boolean includeAllSites = false;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setHtmlJsEvent(String HtmlJsEvent) {
        this.HtmlJsEvent = HtmlJsEvent;
    }

    public void setCatListSelect(HtmlSelect catListSelect) {
        this.catListSelect = catListSelect;
    }

    public void setParentCode(int tmp) {
        this.parentCode = tmp;
    }

    public void setParentCode(String tmp) {
        this.parentCode = Integer.parseInt(tmp);
    }

    public void setCatLevel(int catLevel) {
        this.catLevel = catLevel;
    }

    public void setCatLevel(String catLevel) {
        this.catLevel = Integer.parseInt(catLevel);
    }

    public void setEnabledState(int tmp) {
        this.enabledState = tmp;
    }

    public void setIncludeDisabled(boolean includeDisabled) {
        this.includeDisabled = includeDisabled;
    }

    public boolean getIncludeDisabled() {
        return this.includeDisabled;
    }

    public HtmlSelect getCatListSelect() {
        return this.catListSelect;
    }

    public String getHtmlJsEvent() {
        return this.HtmlJsEvent;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public int getCatLevel() {
        return this.catLevel;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getParentCode() {
        return this.parentCode;
    }

    public int getEnabledState() {
        return this.enabledState;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public String getHtmlSelect(String selectName, String defaultKey) {
        if (defaultKey != null && !"".equals(defaultKey.trim())) {
            return this.getHtmlSelect(selectName, Integer.parseInt(defaultKey));
        }
        return this.getHtmlSelect(selectName);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        Iterator i = this.iterator();
        this.catListSelect.addAttribute("id", selectName);
        while (i.hasNext()) {
            TicketCategory thisCat = (TicketCategory)((Object)i.next());
            String elementText = thisCat.getDescription();
            if (thisCat.getEnabled()) {
                this.catListSelect.addItem(thisCat.getId(), elementText);
                continue;
            }
            if ((thisCat.getEnabled() || thisCat.getId() != defaultKey) && !this.includeDisabled) continue;
            if (this.catListSelect.getSelectSize() > 1) {
                HashMap<String, String> colorAttribute = new HashMap<String, String>();
                colorAttribute.put("style", "color: red");
                this.catListSelect.addItem(thisCat.getId(), elementText, colorAttribute);
                continue;
            }
            elementText = elementText + "*";
            this.catListSelect.addItem(thisCat.getId(), elementText);
        }
        if (!this.getHtmlJsEvent().equals("")) {
            this.catListSelect.setJsEvent(this.getHtmlJsEvent());
        }
        return this.catListSelect.getHtml(selectName, defaultKey);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM ticket_category tc WHERE tc.id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND tc.id < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("tc.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY tc.description");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("tc.* FROM ticket_category tc WHERE tc.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            TicketCategory thisCat = new TicketCategory(rs);
            this.addElement(thisCat);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabledState != -1) {
            sqlFilter.append("AND tc.enabled = ? ");
        }
        if (this.parentCode != -1) {
            sqlFilter.append("AND tc.parent_cat_code = ? ");
        }
        if (this.catLevel != -1) {
            sqlFilter.append("AND tc.cat_level = ? ");
        }
        if (!this.includeAllSites) {
            if (this.siteId > -1) {
                sqlFilter.append("AND (tc.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR tc.site_id IS NULL ");
                }
                sqlFilter.append(")");
            } else {
                sqlFilter.append("AND tc.site_id IS NULL ");
            }
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabledState != -1) {
            pst.setBoolean(++i, this.enabledState == 1);
        }
        if (this.parentCode != -1) {
            pst.setInt(++i, this.parentCode);
        }
        if (this.catLevel != -1) {
            pst.setInt(++i, this.catLevel);
        }
        if (this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        return i;
    }

    public HtmlSelect getHtmlSelect(int defaultKey) {
        HtmlSelect catListSelect = new HtmlSelect();
        for (TicketCategory thisCat : this) {
            String elementText = thisCat.getDescription();
            if (thisCat.getEnabled()) {
                catListSelect.addItem(thisCat.getId(), elementText);
                continue;
            }
            if ((thisCat.getEnabled() || thisCat.getId() != defaultKey) && !this.includeDisabled) continue;
            if (catListSelect.getSelectSize() > 1) {
                HashMap<String, String> colorAttribute = new HashMap<String, String>();
                colorAttribute.put("style", "color: red");
                catListSelect.addItem(thisCat.getId(), elementText, colorAttribute, false);
                continue;
            }
            elementText = elementText + "*";
            catListSelect.addItem(thisCat.getId(), elementText);
        }
        return catListSelect;
    }

    public int getIdFromValue(String value) {
        for (TicketCategory thisCategory : this) {
            if (!value.equals(thisCategory.getDescription())) continue;
            return thisCategory.getId();
        }
        return -1;
    }

    public String getValueFromId(int id) {
        String result = null;
        for (TicketCategory thisCategory : this) {
            if (id != thisCategory.getId()) continue;
            result = thisCategory.getDescription() + (!thisCategory.getEnabled() ? "*" : "");
            break;
        }
        return result;
    }

    public boolean isEnabled(int id) {
        boolean result = false;
        for (TicketCategory thisCategory : this) {
            if (id != thisCategory.getId()) continue;
            result = thisCategory.getEnabled();
            break;
        }
        return result;
    }
}

