/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DatabaseUtils;

public class TicketDefect
extends GenericBean {
    private int id = -1;
    protected String title = null;
    protected String description = null;
    protected Timestamp startDate = null;
    protected Timestamp endDate = null;
    protected boolean enabled = false;
    protected Timestamp trashedDate = null;
    protected TicketList tickets = new TicketList();
    protected boolean buildTickets = false;
    private int ageDays = 0;
    private int ageHours = 0;
    private int siteId = -1;
    private String siteName = null;

    public TicketDefect() {
    }

    public TicketDefect(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TicketDefect(Connection db, int id) throws SQLException {
        if (id <= -1) {
            throw new SQLException("Defect ID not specified");
        }
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id <= -1) {
            throw new SQLException("Defect ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT td.* , ls.description AS sitename FROM ticket_defect td LEFT JOIN lookup_site_id ls ON (td.site_id = ls.code) WHERE td.defect_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildTickets) {
            this.buildTickets(db, this.getSiteId());
        }
    }

    public int buildTickets(Connection db, int tmpTicketSiteId) throws SQLException {
        if (this.tickets == null) {
            this.tickets = new TicketList();
        }
        this.tickets.setDefectId(this.getId());
        this.tickets.setSiteId(tmpTicketSiteId);
        if (tmpTicketSiteId > -1) {
            this.tickets.setExclusiveToSite(true);
            this.tickets.setIncludeAllSites(false);
        }
        this.tickets.buildList(db);
        return this.tickets.size();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("defect_id"));
        this.title = rs.getString("title");
        this.description = rs.getString("description");
        this.startDate = rs.getTimestamp("start_date");
        this.endDate = rs.getTimestamp("end_date");
        this.enabled = rs.getBoolean("enabled");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.siteName = rs.getString("sitename");
        if (this.trashedDate != null) {
            this.title = new String(this.title + " (X)");
        }
        this.buildAge();
    }

    public void buildAge() {
        if (this.startDate != null) {
            if (this.endDate != null) {
                float ageCheck = (this.endDate.getTime() - this.startDate.getTime()) / 3600000L;
                int totalHours = Math.round(ageCheck);
                this.ageDays = Math.round(totalHours / 24);
                this.ageHours = Math.round(totalHours - 24 * this.ageDays);
            } else {
                float ageCheck = (System.currentTimeMillis() - this.startDate.getTime()) / 3600000L;
                int totalHours = Math.round(ageCheck);
                this.ageDays = Math.round(totalHours / 24);
                this.ageHours = Math.round(totalHours - 24 * this.ageDays);
            }
        }
    }

    public String getAgeOf() {
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        if (currentTime.before(this.startDate)) {
            return "";
        }
        return this.ageDays + "d " + this.ageHours + "h";
    }

    public void printDefect() {
        System.out.println("TickietDefect::toString id is " + this.getId());
        System.out.println("TickietDefect::toString title is " + this.getTitle());
        System.out.println("TickietDefect::toString description is " + this.getDescription());
        System.out.println("TickietDefect::toString start date is " + (this.startDate != null ? this.startDate.toString() : "null"));
        System.out.println("TickietDefect::toString end date is " + (this.endDate != null ? this.endDate.toString() : "null"));
        System.out.println("TickietDefect::toString enabled is " + this.enabled);
        System.out.println("TickietDefect::toString trashedDate is " + (this.trashedDate != null ? this.trashedDate.toString() : ""));
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "ticket_defect_defect_id_seq");
            sql.append("INSERT INTO ticket_defect (" + (this.id > -1 ? "defect_id," : "") + " title, description, " + (this.startDate != null ? " start_date, " : ""));
            if (this.endDate != null) {
                sql.append("end_date, ");
            }
            sql.append("enabled, site_id ) ");
            sql.append("VALUES (" + (this.id > -1 ? "?," : "") + " ?, ?, " + (this.startDate != null ? "?," : ""));
            if (this.endDate != null) {
                sql.append("?, ");
            }
            sql.append("?,?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.getTitle());
            pst.setString(++i, this.getDescription());
            if (this.startDate != null) {
                DatabaseUtils.setTimestamp(pst, ++i, this.startDate);
            }
            if (this.endDate != null) {
                DatabaseUtils.setTimestamp(pst, ++i, this.endDate);
            }
            pst.setBoolean(++i, this.getEnabled());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_defect_defect_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ticket_defect SET  title = ?,  start_date = ?,  end_date = ?,  description = ?,  enabled = ? , site_id = ?  WHERE defect_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getTitle());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getEndDate());
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.enabled);
        DatabaseUtils.setInt(pst, ++i, this.getSiteId());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ticket_defect SET trashed_date = ? WHERE defect_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (toTrash) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
        } else {
            DatabaseUtils.setTimestamp(pst, ++i, null);
        }
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return true;
    }

    public boolean getIsNotExpired() {
        Timestamp current = new Timestamp(Calendar.getInstance().getTimeInMillis());
        return this.enabled && (this.endDate == null || current.before(this.endDate));
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public boolean isDisabled() {
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        return !this.getEnabled() || this.getEndDate() != null && !this.getEndDate().after(currentTime) || !this.getStartDate().before(currentTime) || this.getStartDate() != null && !this.getStartDate().before(currentTime);
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("startDate");
        thisList.add("endDate");
        return thisList;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Defect ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int ticketCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as ticketcount FROM ticket WHERE defect_id = ? AND trashed_date IS NULL ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (ticketCount = rs.getInt("ticketcount")) != 0) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("ticketMap");
                thisDependency.setCount(ticketCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE ticket SET defect_id=? WHERE defect_id = ? ");
        pst.setInt(1, -1);
        pst.setInt(2, this.getId());
        pst.executeUpdate();
        pst.close();
        pst = db.prepareStatement("DELETE FROM ticket_defect WHERE defect_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public TicketList getTickets() {
        return this.tickets;
    }

    public void setTickets(TicketList tmp) {
        this.tickets = tmp;
    }

    public boolean getBuildTickets() {
        return this.buildTickets;
    }

    public void setBuildTickets(boolean tmp) {
        this.buildTickets = tmp;
    }

    public void setBuildTickets(String tmp) {
        this.buildTickets = DatabaseUtils.parseBoolean(tmp);
    }

    public int getAgeDays() {
        return this.ageDays;
    }

    public void setAgeDays(int tmp) {
        this.ageDays = tmp;
    }

    public void setAgeDays(String tmp) {
        this.ageDays = Integer.parseInt(tmp);
    }

    public int getAgeHours() {
        return this.ageHours;
    }

    public void setAgeHours(int tmp) {
        this.ageHours = tmp;
    }

    public void setAgeHours(String tmp) {
        this.ageHours = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteName(String tmp) {
        this.siteName = tmp;
    }

    public String getSiteName() {
        return this.siteName;
    }
}

