/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.troubletickets.base.TicketDefect;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketDefectList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    protected int id = -1;
    protected String title = null;
    protected String description = null;
    private Timestamp trashedDate = null;
    private int includeOnlyTrashed = 0;
    private int siteId = -1;
    private boolean includeAllSites = false;
    private boolean exclusiveToSite = false;
    protected boolean buildTickets = false;
    protected int enabledOnly = -1;
    protected int includeIfUsed = -1;
    public static final String tableName = "ticket_defect";
    public static final String uniqueField = "defect_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM ticket_defect td  WHERE td.defect_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(td.title) < ?  ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("td.title", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY td.defect_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" td.* , ls.description AS sitename  FROM ticket_defect td  LEFT JOIN lookup_site_id ls ON (td.site_id = ls.code)  WHERE td.defect_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            TicketDefect thisDefect = new TicketDefect(rs);
            thisDefect.buildAge();
            this.add(thisDefect);
        }
        rs.close();
        pst.close();
        if (this.buildTickets) {
            for (TicketDefect defect : this) {
                defect.setBuildTickets(true);
                defect.buildTickets(db, defect.getSiteId());
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND td.defect_id = ? ");
        }
        if (this.title != null) {
            sqlFilter.append("AND td.title LIKE ? ");
        }
        if (this.description != null) {
            sqlFilter.append("AND td.desctiption LIKE ? ");
        }
        if (this.includeIfUsed > -1) {
            sqlFilter.append("AND (td.defect_id IN (SELECT defect_id FROM ticket WHERE ticketid = ?) ");
            if (this.enabledOnly == 1) {
                sqlFilter.append("OR (td.enabled = ? OR (td.start_date IS NOT NULL AND td.start_date < " + DatabaseUtils.getCurrentTimestamp(db) + ")) ");
            } else if (this.enabledOnly == 0) {
                sqlFilter.append("OR (td.enabled = ? AND (td.start_date IS NULL OR td.start_date >= " + DatabaseUtils.getCurrentTimestamp(db) + ")) ");
            }
            sqlFilter.append(") ");
        } else if (this.enabledOnly == 1) {
            sqlFilter.append("AND (td.enabled = ? OR (td.start_date IS NOT NULL AND td.start_date < " + DatabaseUtils.getCurrentTimestamp(db) + ")) ");
        } else if (this.enabledOnly == 0) {
            sqlFilter.append("AND (td.enabled = ? AND (td.start_date IS NULL OR td.start_date >= " + DatabaseUtils.getCurrentTimestamp(db) + ")) ");
        }
        if (this.includeOnlyTrashed == 1) {
            sqlFilter.append("AND td.trashed_date IS NOT NULL ");
        } else if (this.includeOnlyTrashed == 0) {
            sqlFilter.append("AND td.trashed_date IS NULL ");
        }
        if (!this.includeAllSites) {
            if (this.siteId != -1) {
                sqlFilter.append("AND ( site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR site_id IS NULL ");
                }
                sqlFilter.append(" ) ");
            } else {
                sqlFilter.append("AND site_id IS NULL ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.title != null) {
            pst.setString(++i, this.title);
        }
        if (this.description != null) {
            pst.setString(++i, this.description);
        }
        if (this.includeIfUsed > -1) {
            pst.setInt(++i, this.includeIfUsed);
        }
        if (this.enabledOnly == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabledOnly == 0) {
            pst.setBoolean(++i, false);
        }
        if (!this.includeAllSites && this.siteId != -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public HashMap getHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (TicketDefect defect : this) {
            map.put(String.valueOf(defect.getId()), defect.getTitle() + (defect.getSiteId() != -1 ? " (" + defect.getSiteName() + ")" : "") + (defect.isTrashed() ? " (X)" : ""));
        }
        return map;
    }

    public HtmlSelect getHtmlSelectObj(int selectedKey) {
        HtmlSelect defectListSelect = new HtmlSelect();
        for (TicketDefect thisDefect : this) {
            Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
            if (!thisDefect.isDisabled()) {
                defectListSelect.addItem(thisDefect.getId(), thisDefect.getTitle() + (thisDefect.getSiteId() != -1 ? " (" + thisDefect.getSiteName() + ")" : "") + (thisDefect.getId() == selectedKey && thisDefect.isTrashed() ? " (X)" : ""));
                continue;
            }
            if (thisDefect.getId() != selectedKey) continue;
            defectListSelect.addItem(thisDefect.getId(), thisDefect.getTitle() + (thisDefect.getSiteId() != -1 ? " (" + thisDefect.getSiteName() + ")" : "") + " (X)");
        }
        return defectListSelect;
    }

    public boolean delete(Connection db) throws SQLException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            TicketDefect thisDefect = (TicketDefect)((Object)iter.next());
            thisDefect.delete(db);
            iter.remove();
        }
        return true;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public void setIncludeOnlyTrashed(int tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public boolean getBuildTickets() {
        return this.buildTickets;
    }

    public void setBuildTickets(boolean tmp) {
        this.buildTickets = tmp;
    }

    public void setBuildTickets(String tmp) {
        this.buildTickets = DatabaseUtils.parseBoolean(tmp);
    }

    public int getEnabledOnly() {
        return this.enabledOnly;
    }

    public void setEnabledOnly(int tmp) {
        this.enabledOnly = tmp;
    }

    public void setEnabledOnly(String tmp) {
        this.enabledOnly = Integer.parseInt(tmp);
    }

    public int getIncludeIfUsed() {
        return this.includeIfUsed;
    }

    public void setIncludeIfUsed(int tmp) {
        this.includeIfUsed = tmp;
    }

    public void setIncludeIfUsed(String tmp) {
        this.includeIfUsed = Integer.parseInt(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }
}

