/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.Indexer;
import com.zeroio.utils.ContentUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.DatabaseUtils;

public class TicketIndexer
implements Indexer {
    public static void add(IndexWriter writer, Connection db, ActionContext context) throws SQLException, IOException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT ticketid, project_id, problem, solution, location, cause, modified, key_count FROM ticket t, ticketlink_project l WHERE t.ticketid = l.ticket_id ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ++count;
            Ticket ticket = new Ticket();
            ticket.setId(rs.getInt("ticketid"));
            ticket.setProjectId(rs.getInt("project_id"));
            ticket.setProblem(rs.getString("problem"));
            ticket.setSolution(rs.getString("solution"));
            ticket.setLocation(rs.getString("location"));
            ticket.setCause(rs.getString("cause"));
            ticket.setModified(rs.getTimestamp("modified"));
            ticket.setProjectTicketCount(rs.getInt("key_count"));
            TicketIndexer.add(writer, ticket, false);
            DatabaseUtils.renewConnection(context, db);
        }
        rs.close();
        pst.close();
        System.out.println("TicketIndexer-> Finished: " + count);
    }

    public static void add(IndexWriter writer, Ticket ticket, boolean modified) throws IOException {
        Document document = new Document();
        document.add(Field.Keyword((String)"type", (String)"ticket"));
        document.add(Field.Keyword((String)"ticketId", (String)String.valueOf(ticket.getId())));
        if (ticket.getProjectTicketCount() > 0) {
            document.add(Field.Keyword((String)"projectTicketId", (String)String.valueOf(ticket.getProjectTicketCount())));
        }
        document.add(Field.Keyword((String)"projectId", (String)String.valueOf(ticket.getProjectId())));
        document.add(Field.Text((String)"title", (String)("#" + ticket.getProjectTicketCount() + " " + (ticket.getProblem().length() > 150 ? ContentUtils.toText((String)ticket.getProblem().substring(0, 150)) : ContentUtils.toText((String)ticket.getProblem())))));
        document.add(Field.Text((String)"contents", (String)(ContentUtils.toText((String)ticket.getProblem()) + " " + ContentUtils.toText((String)ticket.getSolution()) + " " + ContentUtils.toText((String)ticket.getLocation()) + " " + ContentUtils.toText((String)ticket.getCause()))));
        if (modified) {
            document.add(Field.Keyword((String)"modified", (String)String.valueOf(System.currentTimeMillis())));
        } else {
            document.add(Field.Keyword((String)"modified", (String)String.valueOf(ticket.getModified().getTime())));
        }
        writer.addDocument(document);
        if (System.getProperty("DEBUG") != null && modified) {
            System.out.println("TicketIndexer-> Added: " + ticket.getId());
        }
    }

    public static Term getSearchTerm(Ticket ticket) {
        Term searchTerm = new Term("ticketId", String.valueOf(ticket.getId()));
        return searchTerm;
    }

    public static Term getDeleteTerm(Ticket ticket) {
        Term searchTerm = new Term("ticketId", String.valueOf(ticket.getId()));
        return searchTerm;
    }
}

