/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketList
extends ArrayList
implements SyncableList {
    public static final String tableName = "ticket";
    public static final String uniqueField = "ticketid";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int enteredBy = -1;
    private boolean onlyOpen = false;
    private boolean onlyClosed = false;
    private int id = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int serviceContractId = -1;
    private int assetId = -1;
    private int department = -1;
    private int assignedTo = -1;
    private int excludeAssignedTo = -1;
    private boolean onlyAssigned = false;
    private boolean onlyUnassigned = false;
    private boolean unassignedToo = false;
    private int severity = 0;
    private int priority = 0;
    private int escalationLevel = 0;
    private String accountOwnerIdRange = null;
    private String description = null;
    private int minutesOlderThan = -1;
    private int productId = -1;
    private int customerProductId = -1;
    private boolean onlyWithProducts = false;
    private boolean hasEstimatedResolutionDate = false;
    private int projectId = -1;
    private int forProjectUser = -1;
    private int userGroupId = -1;
    private int inMyUserGroups = -1;
    private int catCode = -1;
    private int subCat1 = -1;
    private int subCat2 = -1;
    private int subCat3 = -1;
    private int siteId = -1;
    private int stateId = -1;
    private String searchText = "";
    protected Timestamp alertRangeStart = null;
    protected Timestamp alertRangeEnd = null;
    protected java.sql.Date enteredDateStart = null;
    protected java.sql.Date enteredDateEnd = null;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private boolean exclusiveToSite = false;
    private boolean includeAllSites = true;
    private boolean projectTicketsOnly = false;
    private int defectId = -1;
    private boolean buildDepartmentTickets = false;
    protected HashMap errors = new HashMap();
    protected HashMap warnings = new HashMap();

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        try {
            this.lastAnchor = Timestamp.valueOf(tmp);
        }
        catch (Exception e) {
            this.lastAnchor = null;
        }
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        try {
            this.nextAnchor = Timestamp.valueOf(tmp);
        }
        catch (Exception e) {
            this.nextAnchor = null;
        }
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void setAssignedTo(int assignedTo) {
        this.assignedTo = assignedTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = Integer.parseInt(assignedTo);
    }

    public void setExcludeAssignedTo(int tmp) {
        this.excludeAssignedTo = tmp;
    }

    public void setExcludeAssignedTo(String tmp) {
        this.excludeAssignedTo = Integer.parseInt(tmp);
    }

    public void setOnlyAssigned(boolean tmp) {
        this.onlyAssigned = tmp;
    }

    public void setOnlyAssigned(String tmp) {
        this.onlyAssigned = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOnlyUnassigned(boolean tmp) {
        this.onlyUnassigned = tmp;
    }

    public void setOnlyUnassigned(String tmp) {
        this.onlyUnassigned = DatabaseUtils.parseBoolean(tmp);
    }

    public void setUnassignedToo(boolean unassignedToo) {
        this.unassignedToo = unassignedToo;
    }

    public void setSeverity(int tmp) {
        this.severity = tmp;
    }

    public void setPriority(int tmp) {
        this.priority = tmp;
    }

    public void setSeverity(String tmp) {
        this.severity = Integer.parseInt(tmp);
    }

    public void setEscalationLevel(int tmp) {
        this.escalationLevel = tmp;
    }

    public void setEscalationLevel(String tmp) {
        this.escalationLevel = Integer.parseInt(tmp);
    }

    public void setProjectId(int tmp) {
        this.projectId = tmp;
    }

    public void setForProjectUser(int tmp) {
        this.forProjectUser = tmp;
    }

    public void setForProjectUser(String tmp) {
        this.forProjectUser = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setCustomerProductId(int tmp) {
        this.customerProductId = tmp;
    }

    public void setCustomerProductId(String tmp) {
        this.customerProductId = Integer.parseInt(tmp);
    }

    public void setAlertRangeStart(Timestamp tmp) {
        this.alertRangeStart = tmp;
    }

    public void setAlertRangeStart(String tmp) {
        this.alertRangeStart = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setAlertRangeEnd(Timestamp tmp) {
        this.alertRangeEnd = tmp;
    }

    public void setAlertRangeEnd(String tmp) {
        this.alertRangeEnd = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getAlertRangeStart() {
        return this.alertRangeStart;
    }

    public Timestamp getAlertRangeEnd() {
        return this.alertRangeEnd;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getCustomerProductId() {
        return this.customerProductId;
    }

    public void setOnlyWithProducts(boolean tmp) {
        this.onlyWithProducts = tmp;
    }

    public void setHasEstimatedResolutionDate(boolean tmp) {
        this.hasEstimatedResolutionDate = tmp;
    }

    public void setHasEstimatedResolutionDate(String tmp) {
        this.hasEstimatedResolutionDate = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTicketEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setTicketEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPriority(String tmp) {
        this.priority = Integer.parseInt(tmp);
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setAccountOwnerIdRange(String accountOwnerIdRange) {
        this.accountOwnerIdRange = accountOwnerIdRange;
    }

    public void setOrgId(int orgId) {
        this.orgId = orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = Integer.parseInt(orgId);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setServiceContractId(int tmp) {
        this.serviceContractId = tmp;
    }

    public void setServiceContractId(String tmp) {
        this.serviceContractId = Integer.parseInt(tmp);
    }

    public void setAssetId(int tmp) {
        this.assetId = tmp;
    }

    public void setAssetId(String tmp) {
        this.assetId = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMinutesOlderThan(int tmp) {
        this.minutesOlderThan = tmp;
    }

    public void setMinutesOlderThan(String tmp) {
        this.minutesOlderThan = Integer.parseInt(tmp);
    }

    public void setOnlyClosed(boolean onlyClosed) {
        this.onlyClosed = onlyClosed;
    }

    public void setOnlyOpen(boolean onlyOpen) {
        this.onlyOpen = onlyOpen;
    }

    public void setDepartment(int department) {
        this.department = department;
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public int getExcludeAssignedTo() {
        return this.excludeAssignedTo;
    }

    public boolean getOnlyAssigned() {
        return this.onlyAssigned;
    }

    public boolean getOnlyUnassigned() {
        return this.onlyUnassigned;
    }

    public boolean getUnassignedToo() {
        return this.unassignedToo;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getEscalationLevel() {
        return this.escalationLevel;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getAccountOwnerIdRange() {
        return this.accountOwnerIdRange;
    }

    public boolean getOnlyClosed() {
        return this.onlyClosed;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getServiceContractId() {
        return this.serviceContractId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public int getId() {
        return this.id;
    }

    public boolean getOnlyOpen() {
        return this.onlyOpen;
    }

    public int getDepartment() {
        return this.department;
    }

    public boolean getHasEstimatedResolutionDate() {
        return this.hasEstimatedResolutionDate;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getForProjectUser() {
        return this.forProjectUser;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public int getInMyUserGroups() {
        return this.inMyUserGroups;
    }

    public void setInMyUserGroups(int tmp) {
        this.inMyUserGroups = tmp;
    }

    public void setInMyUserGroups(String tmp) {
        this.inMyUserGroups = Integer.parseInt(tmp);
    }

    public int getCatCode() {
        return this.catCode;
    }

    public void setCatCode(int tmp) {
        this.catCode = tmp;
    }

    public void setCatCode(String tmp) {
        this.catCode = Integer.parseInt(tmp);
    }

    public int getSubCat1() {
        return this.subCat1;
    }

    public void setSubCat1(int tmp) {
        this.subCat1 = tmp;
    }

    public void setSubCat1(String tmp) {
        this.subCat1 = Integer.parseInt(tmp);
    }

    public int getSubCat2() {
        return this.subCat2;
    }

    public void setSubCat2(int tmp) {
        this.subCat2 = tmp;
    }

    public void setSubCat2(String tmp) {
        this.subCat2 = Integer.parseInt(tmp);
    }

    public int getSubCat3() {
        return this.subCat3;
    }

    public void setSubCat3(int tmp) {
        this.subCat3 = tmp;
    }

    public void setSubCat3(String tmp) {
        this.subCat3 = Integer.parseInt(tmp);
    }

    public int getDefectId() {
        return this.defectId;
    }

    public void setDefectId(int tmp) {
        this.defectId = tmp;
    }

    public void setDefectId(String tmp) {
        this.defectId = Integer.parseInt(tmp);
    }

    public void setBuildDepartmentTickets(boolean tmp) {
        this.buildDepartmentTickets = tmp;
    }

    public void setBuildDepartmentTickets(String tmp) {
        this.buildDepartmentTickets = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildDepartmentTickets() {
        return this.buildDepartmentTickets;
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public java.sql.Date getEnteredDateStart() {
        return this.enteredDateStart;
    }

    public void setEnteredDateStart(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.enteredDateStart = new java.sql.Date(new Date().getTime());
            this.enteredDateStart.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.enteredDateStart = null;
        }
    }

    public void setEnteredDateStart(java.sql.Date tmp) {
        this.enteredDateStart = tmp;
    }

    public java.sql.Date getEnteredDateEnd() {
        return this.enteredDateEnd;
    }

    public void setEnteredDateEnd(java.sql.Date tmp) {
        this.enteredDateEnd = tmp;
    }

    public void setEnteredDateEnd(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.enteredDateEnd = new java.sql.Date(new Date().getTime());
            this.enteredDateEnd.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.enteredDateEnd = null;
        }
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getProjectTicketsOnly() {
        return this.projectTicketsOnly;
    }

    public void setProjectTicketsOnly(boolean tmp) {
        this.projectTicketsOnly = tmp;
    }

    public void setProjectTicketsOnly(String tmp) {
        this.projectTicketsOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM ticket t LEFT JOIN organization o ON (t.org_id = o.org_id) LEFT JOIN lookup_department ld ON (t.department_code = ld.code) LEFT JOIN lookup_department lrd ON (t.resolvedby_department_code = lrd.code) LEFT JOIN ticket_priority tp ON (t.pri_code = tp.code) LEFT JOIN ticket_severity ts ON (t.scode = ts.code) LEFT JOIN ticket_category tc ON (t.cat_code = tc.id) LEFT JOIN lookup_ticketsource lu_ts ON (t.source_code = lu_ts.code) LEFT JOIN service_contract sc ON (t.link_contract_id = sc.contract_id) LEFT JOIN asset a ON (t.link_asset_id = a.asset_id) LEFT JOIN product_catalog pc ON (t.product_id = pc.product_id) LEFT JOIN ticketlink_project tlp ON (t.ticketid = tlp.ticket_id) LEFT JOIN projects proj ON (tlp.project_id = proj.project_id) LEFT JOIN user_group ug ON (t.user_group_id = ug.group_id) WHERE t.ticketid > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("t.entered", null);
            if (this.pagedListInfo.getMode() == 2 && this.id > 0) {
                String direction = null;
                direction = "desc".equalsIgnoreCase(this.pagedListInfo.getSortOrder()) ? ">" : "<";
                String sqlSubCount = "AND " + (this.pagedListInfo.getColumnToSortBy().equals("t.problem") ? DatabaseUtils.convertToVarChar(db, this.pagedListInfo.getColumnToSortBy()) : this.pagedListInfo.getColumnToSortBy()) + " " + direction + " " + "(SELECT " + (this.pagedListInfo.getColumnToSortBy().equals("t.problem") ? DatabaseUtils.convertToVarChar(db, this.pagedListInfo.getColumnToSortBy()) : this.pagedListInfo.getColumnToSortBy()) + " " + "FROM ticket t WHERE ticketid = ?) ";
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + sqlSubCount);
                items = this.prepareFilter(pst);
                pst.setInt(++items, this.id);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY t.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("t.*, o.name AS orgname, o.enabled AS orgenabled, o.site_id AS orgsiteid, ld.description AS dept, lrd.description AS resolvedept, tp.description AS ticpri, ts.description AS ticsev, tc.description AS catname, lu_ts.description AS sourcename, sc.contract_number AS contractnumber, sc.total_hours_remaining AS hoursremaining, sc.current_start_date AS contractstartdate, sc.current_end_date AS contractenddate, sc.onsite_service_model AS contractonsiteservicemodel, a.serial_number AS serialnumber, a.manufacturer_code AS assetmanufacturercode, a.vendor_code AS assetvendorcode, a.model_version AS modelversion, a.location AS assetlocation, a.onsite_service_model AS assetonsiteservicemodel , pc.sku AS productsku , pc.product_name AS productname, tlp.project_id, proj.title AS projectname, ug.group_name AS usergroupname, lu_te.description AS escalationlevelname FROM ticket t LEFT JOIN organization o ON (t.org_id = o.org_id) LEFT JOIN lookup_department ld ON (t.department_code = ld.code) LEFT JOIN lookup_department lrd ON (t.resolvedby_department_code = lrd.code) LEFT JOIN ticket_priority tp ON (t.pri_code = tp.code) LEFT JOIN ticket_severity ts ON (t.scode = ts.code) LEFT JOIN ticket_category tc ON (t.cat_code = tc.id) LEFT JOIN lookup_ticketsource lu_ts ON (t.source_code = lu_ts.code) LEFT JOIN service_contract sc ON (t.link_contract_id = sc.contract_id) LEFT JOIN asset a ON (t.link_asset_id = a.asset_id) LEFT JOIN product_catalog pc ON (t.product_id = pc.product_id) LEFT JOIN ticketlink_project tlp ON (t.ticketid = tlp.ticket_id) LEFT JOIN projects proj ON (tlp.project_id = proj.project_id) LEFT JOIN user_group ug ON (t.user_group_id = ug.group_id) LEFT JOIN lookup_ticket_escalation lu_te ON (t.escalation_level = lu_te.code) WHERE t.ticketid > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println(pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Ticket thisTicket = new Ticket(rs);
            this.add(thisTicket);
        }
        rs.close();
        pst.close();
        for (Ticket thisTicket : this) {
            thisTicket.buildFiles(db);
            if (thisTicket.getAssignedTo() <= -1) continue;
            thisTicket.checkEnabledOwnerAccount(db);
        }
    }

    public void delete(Connection db, String basePath) throws SQLException {
        for (Ticket thisTicket : this) {
            thisTicket.delete(db, basePath);
        }
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (Ticket thisTicket : this) {
            if (!thisTicket.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (Ticket thisTicket : this) {
            thisTicket.setModifiedBy(userId);
            if (!thisTicket.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.enteredBy > -1) {
            sqlFilter.append("AND t.enteredby = ? ");
        }
        if (this.description != null) {
            if (this.description.indexOf("%") >= 0) {
                sqlFilter.append("AND (" + DatabaseUtils.toLowerCase(db) + "(" + DatabaseUtils.convertToVarChar(db, "t.problem") + ") LIKE ?) ");
            } else {
                sqlFilter.append("AND (" + DatabaseUtils.toLowerCase(db) + "(" + DatabaseUtils.convertToVarChar(db, "t.problem") + ") = ?) ");
            }
        }
        if (this.onlyOpen) {
            sqlFilter.append("AND t.closed IS NULL ");
        }
        if (this.onlyClosed) {
            sqlFilter.append("AND t.closed IS NOT NULL ");
        }
        if (this.id > -1 && this.pagedListInfo.getMode() != 2) {
            sqlFilter.append("AND t.ticketid = ? ");
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND t.org_id = ? ");
        }
        if (this.contactId > -1) {
            sqlFilter.append("AND t.contact_id = ? ");
        }
        if (this.serviceContractId > -1) {
            sqlFilter.append("AND t.link_contract_id = ? ");
        }
        if (this.assetId > -1) {
            sqlFilter.append("AND t.link_asset_id = ? ");
        }
        if (this.buildDepartmentTickets) {
            if (this.department > 0) {
                if (this.unassignedToo) {
                    sqlFilter.append("AND (t.department_code in (?, 0, -1) OR ((t.assigned_to IS NULL OR t.assigned_to = 0 OR t.assigned_to = -1) AND (t.user_group_id IS NULL OR t.user_group_id = 0 OR t.user_group_id = -1)))");
                } else {
                    sqlFilter.append("AND t.department_code = ? ");
                }
            } else {
                sqlFilter.append("AND t.department_code IS NULL ");
            }
        }
        if (this.assignedTo > -1) {
            sqlFilter.append("AND t.assigned_to = ? ");
        }
        if (this.excludeAssignedTo > -1) {
            sqlFilter.append("AND (t.assigned_to <> ? OR t.assigned_to IS NULL) ");
        }
        if (this.onlyAssigned) {
            sqlFilter.append("AND (t.assigned_to > 0 AND t.assigned_to IS NOT NULL) ");
        }
        if (this.onlyUnassigned) {
            sqlFilter.append("AND (t.assigned_to IS NULL OR t.assigned_to = 0 OR t.assigned_to = -1) ");
        }
        if (this.severity > 0) {
            sqlFilter.append("AND t.scode = ? ");
        }
        if (this.priority > 0) {
            sqlFilter.append("AND t.pri_code = ? ");
        }
        if (this.escalationLevel > 0) {
            sqlFilter.append("AND t.escalation_level = ? ");
        }
        if (this.accountOwnerIdRange != null) {
            sqlFilter.append("AND t.org_id IN (SELECT org_id FROM organization WHERE owner IN (" + this.accountOwnerIdRange + ")) ");
        }
        if (this.productId != -1) {
            sqlFilter.append("AND t.product_id = ? ");
        }
        if (this.customerProductId != -1) {
            sqlFilter.append("AND t.customer_product_id = ? ");
        }
        if (this.onlyWithProducts) {
            sqlFilter.append("AND t.product_id IS NOT NULL ");
        }
        if (this.projectId > 0) {
            sqlFilter.append("AND t.ticketid IN (SELECT ticket_id FROM ticketlink_project WHERE project_id = ?) ");
        }
        if (this.forProjectUser > -1) {
            sqlFilter.append("AND t.ticketid IN (SELECT ticket_id FROM ticketlink_project WHERE project_id in (SELECT DISTINCT project_id FROM project_team WHERE user_id = ? AND status IS NULL)) ");
        }
        if (this.projectId == -1 && this.forProjectUser == -1 && !this.projectTicketsOnly) {
            sqlFilter.append("AND t.ticketid NOT IN (SELECT ticket_id FROM ticketlink_project) ");
        } else if (this.projectTicketsOnly) {
            sqlFilter.append("AND t.ticketid IN (SELECT ticket_id FROM ticketlink_project) ");
        }
        if (this.catCode != -1) {
            sqlFilter.append("AND t.cat_code = ? ");
        }
        if (this.subCat1 != -1) {
            sqlFilter.append("AND t.subcat_code1 = ? ");
        }
        if (this.subCat2 != -1) {
            sqlFilter.append("AND t.subcat_code2 = ? ");
        }
        if (this.subCat3 != -1) {
            sqlFilter.append("AND t.subcat_code3 = ? ");
        }
        if (!this.includeAllSites || this.orgId == -1 && this.contactId == -1 && this.forProjectUser == -1 && this.id == -1 && this.serviceContractId == -1 && this.assetId == -1 && this.projectId == -1 && this.userGroupId == -1 && this.inMyUserGroups == -1) {
            if (this.siteId != -1) {
                sqlFilter.append("AND (t.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR t.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else if (this.exclusiveToSite) {
                sqlFilter.append("AND t.site_id IS NULL ");
            }
        }
        if (this.enteredDateStart != null) {
            sqlFilter.append("AND t.entered >= ? ");
        }
        if (this.enteredDateEnd != null) {
            sqlFilter.append("AND t.entered <= ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND t.entered >= ? ");
            }
            sqlFilter.append("AND t.entered < ? ");
        } else if (this.syncType == 3) {
            sqlFilter.append("AND t.modified >= ? ");
            sqlFilter.append("AND t.entered < ? ");
            sqlFilter.append("AND t.modified < ? ");
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND t.entered >= ? ");
            }
            if (this.nextAnchor != null) {
                sqlFilter.append("AND t.entered < ? ");
            }
        } else if (this.minutesOlderThan > 0) {
            sqlFilter.append("AND t.entered <= ? ");
        }
        if (this.searchText != null && !this.searchText.equals("")) {
            sqlFilter.append("AND (" + DatabaseUtils.toLowerCase(db, DatabaseUtils.convertToVarChar(db, "t.problem")) + " LIKE ? OR " + DatabaseUtils.toLowerCase(db, DatabaseUtils.convertToVarChar(db, "t." + DatabaseUtils.addQuotes(db, "comment"))) + " LIKE ? OR " + DatabaseUtils.toLowerCase(db, DatabaseUtils.convertToVarChar(db, "t.solution")) + " LIKE ?) ");
        }
        if (this.hasEstimatedResolutionDate) {
            sqlFilter.append("AND t.est_resolution_date IS NOT NULL ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND t.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND t.trashed_date = ? ");
        } else {
            sqlFilter.append("AND t.trashed_date IS NULL ");
        }
        if (this.userGroupId != -1) {
            sqlFilter.append("AND t.user_group_id = ? ");
        }
        if (this.inMyUserGroups != -1) {
            sqlFilter.append("AND t.user_group_id IN (SELECT group_id FROM user_group_map where user_id = ?) ");
        }
        if (this.defectId > -1) {
            sqlFilter.append("AND t.defect_id = ? ");
        }
        if (this.stateId > -1) {
            sqlFilter.append("AND t.state_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.description != null) {
            pst.setString(++i, this.description.toLowerCase());
        }
        if (this.id > -1 && this.pagedListInfo.getMode() != 2) {
            pst.setInt(++i, this.id);
        }
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.serviceContractId > -1) {
            pst.setInt(++i, this.serviceContractId);
        }
        if (this.assetId > -1) {
            pst.setInt(++i, this.assetId);
        }
        if (this.department > 0) {
            pst.setInt(++i, this.department);
        }
        if (this.assignedTo > -1) {
            pst.setInt(++i, this.assignedTo);
        }
        if (this.excludeAssignedTo > -1) {
            pst.setInt(++i, this.excludeAssignedTo);
        }
        if (this.severity > 0) {
            pst.setInt(++i, this.severity);
        }
        if (this.priority > 0) {
            pst.setInt(++i, this.priority);
        }
        if (this.escalationLevel > 0) {
            pst.setInt(++i, this.escalationLevel);
        }
        if (this.productId > 0) {
            pst.setInt(++i, this.productId);
        }
        if (this.customerProductId > 0) {
            pst.setInt(++i, this.customerProductId);
        }
        if (this.projectId > 0) {
            pst.setInt(++i, this.projectId);
        }
        if (this.forProjectUser > -1) {
            pst.setInt(++i, this.forProjectUser);
        }
        if (this.catCode != -1) {
            pst.setInt(++i, this.catCode);
        }
        if (this.subCat1 != -1) {
            pst.setInt(++i, this.subCat1);
        }
        if (this.subCat2 != -1) {
            pst.setInt(++i, this.subCat2);
        }
        if (this.subCat3 != -1) {
            pst.setInt(++i, this.subCat3);
        }
        if ((!this.includeAllSites || this.orgId == -1 && this.contactId == -1 && this.forProjectUser == -1 && this.id == -1 && this.serviceContractId == -1 && this.assetId == -1 && this.projectId == -1 && this.userGroupId == -1 && this.inMyUserGroups == -1) && this.siteId != -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.enteredDateStart != null) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(this.enteredDateStart.getTime()));
        }
        if (this.enteredDateEnd != null) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(this.enteredDateEnd.getTime()));
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 5) {
            Calendar now;
            Timestamp adjustedDate;
            if (this.lastAnchor != null) {
                adjustedDate = this.lastAnchor;
                if (this.minutesOlderThan > 0) {
                    now = Calendar.getInstance();
                    now.setTimeInMillis(this.lastAnchor.getTime());
                    now.add(12, this.minutesOlderThan - 2 * this.minutesOlderThan);
                    adjustedDate = new Timestamp(now.getTimeInMillis());
                }
                pst.setTimestamp(++i, adjustedDate);
            }
            if (this.nextAnchor != null) {
                adjustedDate = this.nextAnchor;
                if (this.minutesOlderThan > 0) {
                    now = Calendar.getInstance();
                    now.setTimeInMillis(this.nextAnchor.getTime());
                    now.add(12, this.minutesOlderThan - 2 * this.minutesOlderThan);
                    adjustedDate = new Timestamp(now.getTimeInMillis());
                }
                pst.setTimestamp(++i, adjustedDate);
            }
        } else if (this.minutesOlderThan > 0) {
            Calendar now = Calendar.getInstance();
            now.add(12, this.minutesOlderThan - 2 * this.minutesOlderThan);
            Timestamp adjustedDate = new Timestamp(now.getTimeInMillis());
            pst.setTimestamp(++i, adjustedDate);
        }
        if (this.searchText != null && !this.searchText.equals("")) {
            pst.setString(++i, this.searchText.toLowerCase());
            pst.setString(++i, this.searchText.toLowerCase());
            pst.setString(++i, this.searchText.toLowerCase());
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.userGroupId != -1) {
            pst.setInt(++i, this.userGroupId);
        }
        if (this.inMyUserGroups != -1) {
            pst.setInt(++i, this.inMyUserGroups);
        }
        if (this.defectId > -1) {
            pst.setInt(++i, this.defectId);
        }
        if (this.stateId > -1) {
            pst.setInt(++i, this.stateId);
        }
        return i;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        ResultSet rs;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) as itemcount FROM ticket t WHERE ticketid > 0 AND trashed_date IS NULL ");
        if (moduleId == 1) {
            sql.append("AND t.org_id = ?");
        }
        if (moduleId == 209041109) {
            sql.append("AND t.link_contract_id = ?");
        }
        if (moduleId == 209041110) {
            sql.append("AND t.link_asset_id = ?");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 1) {
            pst.setInt(1, itemId);
        }
        if (moduleId == 209041109) {
            pst.setInt(1, itemId);
        }
        if (moduleId == 209041110) {
            pst.setInt(1, itemId);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static void insertProjectTicketCount(Connection db, int projectId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("INSERT INTO project_ticket_count (project_id) VALUES (?) ");
        pst.setInt(1, projectId);
        pst.execute();
        pst.close();
    }

    public HashMap queryRecordCount(Connection db, TimeZone timeZone) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        HashMap<String, Integer> events = new HashMap<String, Integer>();
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlTail = new StringBuffer();
        this.createFilter(sqlFilter, db);
        sqlSelect.append("SELECT est_resolution_date, count(*) as nocols FROM ticket t WHERE ticketid > -1 ");
        sqlTail.append("GROUP BY est_resolution_date ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlTail.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            Timestamp estRes = rs.getTimestamp("est_resolution_date");
            String estResolutionDate = null;
            if (estRes == null) continue;
            estResolutionDate = DateUtils.getServerToUserDateString(timeZone, 3, estRes);
            int thisCount = rs.getInt("nocols");
            if (events.containsKey(estResolutionDate)) {
                int tmpCount = (Integer)events.get(estResolutionDate);
                thisCount += tmpCount;
            }
            events.put(estResolutionDate, new Integer(thisCount));
        }
        rs.close();
        pst.close();
        return events;
    }

    public static void deleteProjectTicketCount(Connection db, int projectId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM project_ticket_count WHERE project_id = ? ");
        pst.setInt(1, projectId);
        pst.execute();
        pst.close();
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        for (Ticket tmpTicket : this) {
            tmpTicket.updateStatus(db, toTrash, tmpUserId);
        }
        return true;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

