/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.TimeZone;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.ScheduledActions;
import org.aspcfs.modules.mycfs.base.CalendarEventList;
import org.aspcfs.modules.mycfs.base.TicketEventList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.CalendarView;

public class TicketListScheduledActions
extends TicketList
implements ScheduledActions {
    private int userId = -1;
    private ActionContext context = null;
    private CFSModule module = null;

    public void setModule(CFSModule tmp) {
        this.module = tmp;
    }

    public void setContext(ActionContext tmp) {
        this.context = tmp;
    }

    public ActionContext getContext() {
        return this.context;
    }

    public CFSModule getModule() {
        return this.module;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public int getUserId() {
        return this.userId;
    }

    public void buildAlerts(CalendarView companyCalendar, Connection db) throws SQLException {
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TicketListScheduledActions-> Building Ticket alerts for user " + this.userId);
            }
            User thisUser = null;
            if (this.context != null) {
                thisUser = this.module.getUser(this.context, this.userId);
            }
            TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            Timestamp todayTimestamp = new Timestamp(System.currentTimeMillis());
            String alertDate = DateUtils.getServerToUserDateString(timeZone, 3, todayTimestamp);
            this.setOnlyOpen(true);
            this.setOnlyWithProducts(true);
            this.clear();
            this.setOrgId(-1);
            this.setOnlyWithProducts(false);
            this.setAssignedTo(this.getUserId());
            this.setIncludeAllSites(true);
            this.setOnlyAssigned(true);
            this.setHasEstimatedResolutionDate(true);
            this.setOnlyOpen(true);
            this.buildList(db);
            for (Ticket thisTicket : this) {
                thisTicket.buildContactInformation(db);
                alertDate = DateUtils.getServerToUserDateString(timeZone, 3, thisTicket.getEstimatedResolutionDate());
                TicketEventList thisList = (TicketEventList)companyCalendar.getEventList(alertDate, CalendarEventList.EVENT_TYPES[12]);
                thisList.getOpenTickets().add(thisTicket);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Ticket Calendar Alerts 2");
        }
    }

    public void buildAlertCount(CalendarView companyCalendar, Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("TicketListScheduledActions --> Building Alert Counts ");
        }
        User thisUser = null;
        if (this.context != null) {
            thisUser = this.module.getUser(this.context, this.userId);
        }
        TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
        try {
            this.clear();
            this.setOrgId(-1);
            this.setOnlyWithProducts(false);
            timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            this.setAssignedTo(this.getUserId());
            this.setIncludeAllSites(true);
            this.setOnlyAssigned(true);
            this.setOnlyOpen(true);
            this.setHasEstimatedResolutionDate(true);
            this.setOnlyOpen(true);
            HashMap dayEvents = this.queryRecordCount(db, timeZone);
            for (String thisDay : dayEvents.keySet()) {
                companyCalendar.addEventCount(thisDay, CalendarEventList.EVENT_TYPES[12], dayEvents.get(thisDay));
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Ticket Calendar Alert Counts 2");
        }
    }
}

