/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class TicketLog
extends GenericBean {
    private int id = -1;
    private int ticketId = -1;
    private String entryText = "";
    private int assignedTo = -1;
    private boolean closed = false;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int priorityCode = -1;
    private int levelCode = -1;
    private int departmentCode = -1;
    private int catCode = -1;
    private int severityCode = -1;
    private int escalationCode = -1;
    private int stateId = -1;
    private String enteredByName = "";
    private String modifiedByName = "";
    private String companyName = "";
    private String categoryName = "";
    private String departmentName = "";
    private String stateName = null;
    private boolean systemMessage = false;
    private String assignedToName = "";
    private String priorityName = "";
    private String severityName = "";
    private String escalationName = "";

    public TicketLog() {
    }

    public TicketLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TicketLog(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Ticket Log Number");
        }
        PreparedStatement pst = db.prepareStatement("SELECT t.*, d.description as deptname, tp.description AS priorityname, ts.description AS severityname, lu_te.description AS escalationname, ct_eb.namelast AS eb_namelast, ct_eb.namefirst AS eb_namefirst, ct_at.namelast AS at_namelast, ct_at.namefirst AS at_namefirst, lu_ts.description AS state_name FROM ticketlog t LEFT JOIN ticket_category tc ON (t.cat_code = tc.id) LEFT JOIN contact ct_eb ON (t.enteredby = ct_eb.user_id) LEFT JOIN contact ct_at ON (t.assigned_to = ct_at.user_id) LEFT JOIN ticket_priority tp ON (t.pri_code = tp.code) LEFT JOIN ticket_severity ts ON (t.scode = ts.code) LEFT JOIN lookup_department d ON (t.department_code = d.code) LEFT JOIN lookup_ticket_escalation lu_te ON (t.escalation_code = lu_te.code) LEFT JOIN lookup_ticket_state lu_ts ON (t.state_id = lu_ts.code) WHERE t.id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Ticket Log not found");
        }
    }

    public void setPriorityName(String priorityName) {
        this.priorityName = priorityName;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setAssignedToName(String assignedToName) {
        this.assignedToName = assignedToName;
    }

    public void setSeverityName(String severityName) {
        this.severityName = severityName;
    }

    public void setEscalationName(String tmp) {
        this.escalationName = tmp;
    }

    public void setSystemMessage(boolean systemMessage) {
        this.systemMessage = systemMessage;
    }

    public void setTicketId(int tmp) {
        this.ticketId = tmp;
    }

    public void setTicketId(String tmp) {
        this.ticketId = Integer.parseInt(tmp);
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public void setEntryText(String tmp) {
        this.entryText = tmp;
    }

    public void setAssignedTo(int tmp) {
        this.assignedTo = tmp;
    }

    public void setAssignedTo(String tmp) {
        this.assignedTo = Integer.parseInt(tmp);
    }

    public void s(String tmp) {
        this.assignedTo = Integer.parseInt(tmp);
    }

    public void setClosed(boolean tmp) {
        this.closed = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setPriorityCode(int tmp) {
        this.priorityCode = tmp;
    }

    public void setPriorityCode(String tmp) {
        this.priorityCode = Integer.parseInt(tmp);
    }

    public void setLevelCode(int tmp) {
        this.levelCode = tmp;
    }

    public void setLevelCode(String tmp) {
        this.levelCode = Integer.parseInt(tmp);
    }

    public void setDepartmentCode(int tmp) {
        this.departmentCode = tmp;
    }

    public void setDepartmentCode(String tmp) {
        this.departmentCode = Integer.parseInt(tmp);
    }

    public void setCatCode(int tmp) {
        this.catCode = tmp;
    }

    public void setCatCode(String tmp) {
        this.catCode = Integer.parseInt(tmp);
    }

    public void setSeverityCode(int tmp) {
        this.severityCode = tmp;
    }

    public void setSeverityCode(String tmp) {
        this.severityCode = Integer.parseInt(tmp);
    }

    public void setEscalationCode(int tmp) {
        this.escalationCode = tmp;
    }

    public void setEscalationCode(String tmp) {
        this.escalationCode = Integer.parseInt(tmp);
    }

    public void setEnteredByName(String tmp) {
        this.enteredByName = tmp;
    }

    public void setModifiedByName(String tmp) {
        this.modifiedByName = tmp;
    }

    public void setCompanyName(String tmp) {
        this.companyName = tmp;
    }

    public void setCategoryName(String tmp) {
        this.categoryName = tmp;
    }

    public String getPriorityName() {
        return this.priorityName;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getAssignedToName() {
        return this.assignedToName;
    }

    public String getSeverityName() {
        return this.severityName;
    }

    public String getEscalationName() {
        return this.escalationName;
    }

    public boolean getSystemMessage() {
        return this.systemMessage;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public int getId() {
        return this.id;
    }

    public int getTicketId() {
        return this.ticketId;
    }

    public String getEntryText() {
        return this.entryText;
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getPriorityCode() {
        return this.priorityCode;
    }

    public int getLevelCode() {
        return this.levelCode;
    }

    public int getDepartmentCode() {
        return this.departmentCode;
    }

    public int getCatCode() {
        return this.catCode;
    }

    public int getSeverityCode() {
        return this.severityCode;
    }

    public int getEscalationCode() {
        return this.escalationCode;
    }

    public String getEnteredByName() {
        return this.enteredByName;
    }

    public String getModifiedByName() {
        return this.modifiedByName;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int tmp) {
        this.stateId = tmp;
    }

    public void setStateId(String tmp) {
        this.stateId = Integer.parseInt(tmp);
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String tmp) {
        this.stateName = tmp;
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.ticketId == -1) {
            throw new SQLException("Log Entry must be associated to a Ticket " + this.getId());
        }
        StringBuffer sql = new StringBuffer();
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "ticketlog_id_seq");
            sql.append("INSERT INTO ticketlog (pri_code, level_code, department_code, cat_code, scode, escalation_code, ticketid, " + DatabaseUtils.addQuotes(db, "comment") + ", closed, state_id, ");
            if (this.id > -1) {
                sql.append("id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getPriorityCode());
            pst.setInt(++i, this.getLevelCode());
            if (this.getDepartmentCode() > 0) {
                pst.setInt(++i, this.getDepartmentCode());
            } else {
                pst.setNull(++i, 4);
            }
            DatabaseUtils.setInt(pst, ++i, this.getCatCode());
            DatabaseUtils.setInt(pst, ++i, this.getSeverityCode());
            DatabaseUtils.setInt(pst, ++i, this.getEscalationCode());
            DatabaseUtils.setInt(pst, ++i, this.getTicketId());
            pst.setString(++i, this.getEntryText());
            pst.setBoolean(++i, this.getClosed());
            DatabaseUtils.setInt(pst, ++i, this.getStateId());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "ticketlog_id_seq", this.id);
            this.update(db, true);
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void process(Connection db, int ticketId, int enteredBy, int modifiedBy) throws SQLException {
        if (ticketId != -1) {
            this.setEnteredBy(modifiedBy);
            this.setModifiedBy(modifiedBy);
            this.insert(db);
        }
    }

    public int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.ticketId == -1) {
            throw new SQLException("Log Entry must be associated to a Ticket");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ticketlog SET assigned_to = ? ");
        if (!override) {
            sql.append(", modified = " + DatabaseUtils.getCurrentTimestamp(db) + " ");
        }
        sql.append("WHERE id = ? ");
        if (!override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getAssignedTo());
        pst.setInt(++i, this.id);
        if (!override && this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Ticket Log ID not specified.");
        }
        try {
            db.setAutoCommit(false);
            Statement st = db.createStatement();
            st.executeUpdate("DELETE FROM ticketlog WHERE id = " + this.getId());
            st.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public void createSysMsg(TicketLog source) {
        this.setEnteredBy(source.getModifiedBy());
        this.setEntered(source.getEntered());
        this.setDepartmentCode(source.getDepartmentCode());
        this.setAssignedTo(source.getAssignedTo());
        this.setTicketId(source.getId());
        this.setPriorityCode(source.getPriorityCode());
        this.setSeverityCode(source.getSeverityCode());
        this.setSystemMessage(true);
        this.setClosed(source.getClosed());
        this.setPriorityName(source.getPriorityName());
        this.setSeverityName(source.getSeverityName());
        this.setEscalationName(source.getEscalationName());
        this.setAssignedToName(source.getAssignedToName());
        this.setEnteredByName(source.getEnteredByName());
        this.setDepartmentName(source.getDepartmentName());
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("id"));
        this.ticketId = rs.getInt("ticketid");
        if (rs.wasNull()) {
            this.ticketId = -1;
        }
        this.assignedTo = rs.getInt("assigned_to");
        if (rs.wasNull()) {
            this.assignedTo = 0;
        }
        this.entryText = rs.getString("comment");
        this.closed = rs.getBoolean("closed");
        this.priorityCode = rs.getInt("pri_code");
        if (rs.wasNull()) {
            this.priorityCode = -1;
        }
        this.levelCode = rs.getInt("level_code");
        this.departmentCode = rs.getInt("department_code");
        if (rs.wasNull()) {
            this.departmentCode = -1;
        }
        this.catCode = rs.getInt("cat_code");
        if (rs.wasNull()) {
            this.catCode = -1;
        }
        this.severityCode = rs.getInt("scode");
        if (rs.wasNull()) {
            this.severityCode = -1;
        }
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.escalationCode = DatabaseUtils.getInt(rs, "escalation_code");
        this.stateId = DatabaseUtils.getInt(rs, "state_id");
        this.departmentName = rs.getString("deptname");
        this.priorityName = rs.getString("priorityname");
        this.severityName = rs.getString("severityname");
        this.escalationName = rs.getString("escalationname");
        this.enteredByName = Contact.getNameLastFirst(rs.getString("eb_namelast"), rs.getString("eb_namefirst"));
        this.assignedToName = Contact.getNameLastFirst(rs.getString("at_namelast"), rs.getString("at_namefirst"));
        this.stateName = rs.getString("state_name");
    }

    protected void buildRecord(HttpServletRequest request) {
        this.setEntryText(request.getParameter("newticketlogentry"));
        this.setDepartmentCode(Integer.parseInt(request.getParameter("departmentCode")));
        this.setTicketId(Integer.parseInt(request.getParameter("id")));
    }
}

