/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.ObjectValidator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.troubletickets.base.TicketLog;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketLogList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int ticketId = -1;
    public static final String tableName = "ticketlog";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private boolean doSystemMessages = true;
    private int productId = -1;
    private int customerProductId = -1;
    private SystemStatus systemStatus = null;

    public TicketLogList() {
    }

    public TicketLogList(HttpServletRequest request, int userId) throws Exception {
        if (request.getParameter("newticketlogentry") != null) {
            TicketLog thisEntry = new TicketLog();
            thisEntry.setEnteredBy(userId);
            thisEntry.buildRecord(request);
            if (ObjectValidator.validate(null, null, (Object)thisEntry)) {
                this.add(thisEntry);
            }
        }
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setTicketId(int tmp) {
        this.ticketId = tmp;
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setCustomerProductId(int tmp) {
        this.customerProductId = tmp;
    }

    public void setCustomerProductId(String tmp) {
        this.customerProductId = Integer.parseInt(tmp);
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public int getCustomerProductId() {
        return this.customerProductId;
    }

    public int getProductId() {
        return this.productId;
    }

    public boolean getDoSystemMessages() {
        return this.doSystemMessages;
    }

    public void setDoSystemMessages(boolean doSystemMessages) {
        this.doSystemMessages = doSystemMessages;
    }

    public String getLabel(SystemStatus systemStatus, HashMap map, String input) {
        Template template = new Template(input);
        template.setParseElements(map);
        return template.getParsedText();
    }

    public boolean setSystemMessages(TicketLog current, TicketLog prev) {
        HashMap<String, String> map;
        String logEntry;
        TicketLog tempLog = null;
        if (prev == null) {
            HashMap<String, String> map2;
            String logEntry2;
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                tempLog.setEntryText("[ " + this.systemStatus.getLabel("ticketloglist.ticketOpened") + " ]");
            } else {
                tempLog.setEntryText("[ Ticket Opened ]");
            }
            this.add(tempLog);
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (tempLog.getAssignedToName() != null) {
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("ticketloglist.assignedTo");
                    if (logEntry2 != null) {
                        map2 = new HashMap<String, String>();
                        map2.put("${ticketLogList.assignedToName}", current.getAssignedToName());
                        tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    } else {
                        tempLog.setEntryText("[ Assigned to " + current.getAssignedToName() + " ]");
                    }
                } else {
                    tempLog.setEntryText("[ Assigned to " + current.getAssignedToName() + " ]");
                }
            } else if (this.systemStatus != null) {
                tempLog.setEntryText("[ " + this.systemStatus.getLabel("ticketloglist.ticketUnassigned") + " ]");
            } else {
                tempLog.setEntryText("[ Ticket is unassigned ]");
            }
            this.add(tempLog);
            if (current.getDepartmentCode() > 0) {
                tempLog = new TicketLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("ticketloglist.assignedDepartment");
                    if (logEntry2 != null) {
                        map2 = new HashMap();
                        map2.put("${ticketLogList.departmentName}", current.getDepartmentName());
                        tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    } else {
                        tempLog.setEntryText("[ Department assigned to " + current.getDepartmentName() + " ]");
                    }
                } else {
                    tempLog.setEntryText("[ Department assigned to " + current.getDepartmentName() + " ]");
                }
                this.add(tempLog);
            }
            if (current.getStateId() > 0) {
                tempLog = new TicketLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("ticketloglist.currentState");
                    if (logEntry2 != null) {
                        map2 = new HashMap();
                        map2.put("${ticketLogList.stateName}", current.getStateName());
                        tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    } else {
                        tempLog.setEntryText("[ Ticket state is " + current.getStateName() + " ]");
                    }
                } else {
                    tempLog.setEntryText("[ Ticket state is " + current.getStateName() + " ]");
                }
                this.add(tempLog);
            }
            if (current.getPriorityCode() > 0) {
                tempLog = new TicketLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("ticketloglist.priorityName");
                    if (logEntry2 != null) {
                        map2 = new HashMap();
                        map2.put("${ticketLogList.priorityName}", current.getPriorityName());
                        tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    } else {
                        tempLog.setEntryText("[ Priority set to " + current.getPriorityName() + " ]");
                    }
                } else {
                    tempLog.setEntryText("[ Priority set to " + current.getPriorityName() + " ]");
                }
                this.add(tempLog);
            }
            if (current.getSeverityCode() > 0) {
                tempLog = new TicketLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("ticketloglist.severityName");
                    if (logEntry2 != null) {
                        map2 = new HashMap();
                        map2.put("${ticketLogList.severityName}", current.getSeverityName());
                        tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    } else {
                        tempLog.setEntryText("[ Severity set to " + current.getSeverityName() + " ]");
                    }
                } else {
                    tempLog.setEntryText("[ Severity set to " + current.getSeverityName() + " ]");
                }
                this.add(tempLog);
            }
            if (current.getEscalationCode() > 0) {
                tempLog = new TicketLog();
                tempLog.createSysMsg(current);
                tempLog.setEntryText("[ Escalation level set to " + current.getEscalationName() + " ]");
                this.add(tempLog);
            }
            if (current.getClosed()) {
                tempLog = new TicketLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    tempLog.setEntryText("[ " + this.systemStatus.getLabel("ticketloglist.ticketImmediatelyClosed") + " ]");
                } else {
                    tempLog.setEntryText("[ Ticket was immediately closed ]");
                }
                this.add(tempLog);
            }
            return true;
        }
        if (current.getAssignedTo() != prev.getAssignedTo()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (tempLog.getAssignedToName() != null) {
                if (this.systemStatus != null) {
                    logEntry = this.systemStatus.getLabel("ticketloglist.reassignedFrom");
                    if (logEntry != null) {
                        map = new HashMap<String, String>();
                        map.put("${ticketLogList.previousAssignedToName}", this.isAssigned(prev.getAssignedToName()));
                        map.put("${ticketLogList.currentAssignedToName}", this.isAssigned(current.getAssignedToName()));
                        tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                    } else {
                        tempLog.setEntryText("[ Reassigned from " + this.isAssigned(prev.getAssignedToName()) + " to " + this.isAssigned(current.getAssignedToName()) + " ]");
                    }
                } else {
                    tempLog.setEntryText("[ Reassigned from " + this.isAssigned(prev.getAssignedToName()) + " to " + this.isAssigned(current.getAssignedToName()) + " ]");
                }
            } else if (this.systemStatus != null) {
                tempLog.setEntryText("[ " + this.systemStatus.getLabel("ticketloglist.ticketUnassigned") + " ]");
            } else {
                tempLog.setEntryText("[ Ticket is unassigned ]");
            }
            this.add(tempLog);
        }
        if (current.getDepartmentCode() != prev.getDepartmentCode()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("ticketloglist.departmentChanged");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${ticketLogList.previousDepartmentName}", this.isAssigned(prev.getDepartmentName()));
                    map.put("${ticketLogList.currentDepartmentName}", this.isAssigned(current.getDepartmentName()));
                    tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                } else {
                    tempLog.setEntryText("[ Department changed from " + this.isAssigned(prev.getDepartmentName()) + " to " + this.isAssigned(current.getDepartmentName()) + " ]");
                }
            } else {
                tempLog.setEntryText("[ Department changed from " + this.isAssigned(prev.getDepartmentName()) + " to " + this.isAssigned(current.getDepartmentName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getStateId() != prev.getStateId()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("ticketloglist.stateChanged");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${ticketLogList.previousStateName}", this.isAssigned(prev.getStateName()));
                    map.put("${ticketLogList.currentStateName}", this.isAssigned(current.getStateName()));
                    tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                } else {
                    tempLog.setEntryText("[ Ticket state changed from " + this.isAssigned(prev.getStateName()) + " to " + this.isAssigned(current.getStateName()) + " ]");
                }
            } else {
                tempLog.setEntryText("[ Ticket state changed from " + this.isAssigned(prev.getStateName()) + " to " + this.isAssigned(current.getStateName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getPriorityCode() != prev.getPriorityCode()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("ticketloglist.priorityChanged");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${ticketLogList.previousPriorityName}", this.isAssigned(prev.getPriorityName()));
                    map.put("${ticketLogList.currentPriorityName}", this.isAssigned(current.getPriorityName()));
                    tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                } else {
                    tempLog.setEntryText("[ Priority changed from " + this.isAssigned(prev.getPriorityName()) + " to " + this.isAssigned(current.getPriorityName()) + " ]");
                }
            } else {
                tempLog.setEntryText("[ Priority changed from " + this.isAssigned(prev.getPriorityName()) + " to " + this.isAssigned(current.getPriorityName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getSeverityCode() != prev.getSeverityCode()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("ticketloglist.severityChanged");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${ticketLogList.previousSeverityName}", this.isAssigned(prev.getSeverityName()));
                    map.put("${ticketLogList.currentSeverityName}", this.isAssigned(current.getSeverityName()));
                    tempLog.setEntryText("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                } else {
                    tempLog.setEntryText("[ Severity changed from " + this.isAssigned(prev.getSeverityName()) + " to " + this.isAssigned(current.getSeverityName()) + " ]");
                }
            } else {
                tempLog.setEntryText("[ Severity changed from " + this.isAssigned(prev.getSeverityName()) + " to " + this.isAssigned(current.getSeverityName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getEscalationCode() != prev.getEscalationCode()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            tempLog.setEntryText("[ Escalation level changed from " + this.isAssigned(prev.getEscalationName()) + " to " + this.isAssigned(current.getEscalationName()) + " ]");
            this.add(tempLog);
        }
        if (!current.getClosed() && prev.getClosed()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                tempLog.setEntryText("[ " + this.systemStatus.getLabel("ticketloglist.ticketReopened") + " ]");
            } else {
                tempLog.setEntryText("[ Ticket Reopened ]");
            }
            this.add(tempLog);
        }
        if (current.getClosed() && !prev.getClosed()) {
            tempLog = new TicketLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                tempLog.setEntryText("[ " + this.systemStatus.getLabel("ticketloglist.ticketClosed") + " ]");
            } else {
                tempLog.setEntryText("[ Ticket Closed ]");
            }
            this.add(tempLog);
        }
        return true;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM ticketlog t LEFT JOIN ticket_category tc ON (t.cat_code = tc.id) LEFT JOIN contact ct_eb ON (t.enteredby = ct_eb.user_id) LEFT JOIN contact ct_at ON (t.assigned_to = ct_at.user_id) LEFT JOIN ticket_priority tp ON (t.pri_code = tp.code) LEFT JOIN ticket_severity ts ON (t.scode = ts.code) LEFT JOIN lookup_department d ON (t.department_code = d.code) LEFT JOIN lookup_ticket_state lu_ts ON (t.state_id = lu_ts.code) WHERE t.id > 0 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(t." + DatabaseUtils.addQuotes(db, "comment") + ") < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("t.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY t.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("t.*, d.description as deptname, tp.description AS priorityname, ts.description AS severityname, lu_te.description AS escalationname, ct_eb.namelast AS eb_namelast, ct_eb.namefirst AS eb_namefirst, ct_at.namelast AS at_namelast, ct_at.namefirst AS at_namefirst, lu_ts.description AS state_name FROM ticketlog t LEFT JOIN ticket_category tc ON (t.cat_code = tc.id) LEFT JOIN contact ct_eb ON (t.enteredby = ct_eb.user_id) LEFT JOIN contact ct_at ON (t.assigned_to = ct_at.user_id) LEFT JOIN ticket_priority tp ON (t.pri_code = tp.code) LEFT JOIN ticket_severity ts ON (t.scode = ts.code) LEFT JOIN lookup_department d ON (t.department_code = d.code) LEFT JOIN lookup_ticket_escalation lu_te ON (t.escalation_code = lu_te.code) LEFT JOIN lookup_ticket_state lu_ts ON (t.state_id = lu_ts.code) WHERE t.id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        TicketLog prevTicketLog = null;
        while (rs.next()) {
            TicketLog thisTicketLog = new TicketLog(rs);
            if (this.doSystemMessages) {
                this.setSystemMessages(thisTicketLog, prevTicketLog);
                if (thisTicketLog.getEntryText() != null && !thisTicketLog.getEntryText().equals("")) {
                    this.add(thisTicketLog);
                }
            } else {
                this.add(thisTicketLog);
            }
            prevTicketLog = thisTicketLog;
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (this.ticketId > -1) {
            sqlFilter.append("AND t.ticketid = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.ticketId > -1) {
            pst.setInt(++i, this.ticketId);
        }
        return i;
    }

    private String isAssigned(String value) {
        if (value == null) {
            return "unassigned";
        }
        return value;
    }

    public String getComments() {
        StringBuffer comments = new StringBuffer("");
        for (TicketLog log : this) {
            comments.append(log.getEntryText() + " | ");
        }
        return comments.toString();
    }
}

