/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.troubletickets.base.TicketReplacementPart;
import org.aspcfs.modules.troubletickets.base.TicketReplacementPartList;
import org.aspcfs.utils.DatabaseUtils;

public class TicketMaintenanceNote
extends GenericBean {
    private int id = -1;
    private int linkTicketId = -1;
    private String formTypeName = null;
    private String descriptionOfService = null;
    private TicketReplacementPartList ticketReplacementPartList = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private boolean override = false;

    public TicketMaintenanceNote() {
    }

    public TicketMaintenanceNote(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkTicketId(int tmp) {
        this.linkTicketId = tmp;
    }

    public void setLinkTicketId(String tmp) {
        this.linkTicketId = Integer.parseInt(tmp);
    }

    public void setFormTypeName(String tmp) {
        this.formTypeName = tmp;
    }

    public void setDescriptionOfService(String tmp) {
        this.descriptionOfService = tmp;
    }

    public void setTicketReplacementPartList(TicketReplacementPartList tmp) {
        this.ticketReplacementPartList = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRequestItems(HttpServletRequest request) {
        this.ticketReplacementPartList = new TicketReplacementPartList(request);
    }

    public int getId() {
        return this.id;
    }

    public int getLinkTicketId() {
        return this.linkTicketId;
    }

    public String getFormTypeName() {
        return this.formTypeName;
    }

    public String getDescriptionOfService() {
        return this.descriptionOfService;
    }

    public TicketReplacementPartList getTicketReplacementPartList() {
        return this.ticketReplacementPartList;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getOverride() {
        return this.override;
    }

    public void queryRecord(Connection db, int tmpId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT tsf.*   FROM  ticket_sun_form tsf  WHERE tsf.form_id = ? ");
        pst.setInt(1, tmpId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("TicketSunMaintenance-> before build parts");
        }
        this.buildTicketReplacementPartList(db);
    }

    public void buildTicketReplacementPartList(Connection db) throws SQLException {
        this.ticketReplacementPartList = new TicketReplacementPartList();
        this.ticketReplacementPartList.queryList(db, this.id);
    }

    public boolean deleteTicketReplacementPartList(Connection db) throws SQLException {
        this.ticketReplacementPartList = new TicketReplacementPartList();
        return this.ticketReplacementPartList.deleteList(db, this.id);
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ticket_sun_form SET description_of_service = ? ");
            if (!this.override) {
                sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
            }
            sql.append("WHERE form_id = ? ");
            if (!this.override) {
                sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            }
            pst = db.prepareStatement(sql.toString());
            int i = 0;
            pst.setString(++i, this.descriptionOfService);
            if (!this.override) {
                pst.setInt(++i, this.modifiedBy);
            }
            pst.setInt(++i, this.id);
            if (!this.override && this.getModified() != null) {
                pst.setTimestamp(++i, this.modified);
            }
            resultCount = pst.executeUpdate();
            pst.close();
            if (resultCount == -1) {
                int n = resultCount;
                return n;
            }
            if (resultCount == 1) {
                TicketReplacementPartList tmpPartList = this.getTicketReplacementPartList();
                tmpPartList.deleteList(db, this.id);
                this.insertReplacementParts(db, tmpPartList);
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Note Id not specified.");
        }
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.deleteTicketReplacementPartList(db);
            PreparedStatement pst = null;
            pst = db.prepareStatement(" DELETE FROM ticket_sun_form  WHERE form_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            this.id = DatabaseUtils.getNextSeq(db, "ticket_sun_form_form_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO  ticket_sun_form (" + (this.id > -1 ? "form_id, " : "") + "link_ticket_id, " + "description_of_service, " + "enteredby, " + "modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?)");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.linkTicketId);
            pst.setString(++i, this.descriptionOfService);
            pst.setInt(++i, this.enteredBy);
            pst.setInt(++i, this.modifiedBy);
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "ticket_sun_form_form_id_seq", this.id);
            pst.close();
            this.insertReplacementParts(db, this.getTicketReplacementPartList());
            db.commit();
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public void insertReplacementParts(Connection db, TicketReplacementPartList tmpPartList) throws SQLException {
        for (TicketReplacementPart thisPart : tmpPartList) {
            thisPart.setLinkFormId(this.id);
            thisPart.insert(db);
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("form_id");
        this.linkTicketId = rs.getInt("link_ticket_id");
        this.descriptionOfService = rs.getString("description_of_service");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
    }
}

