/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.utils.DatabaseUtils;

public class TicketPerDayDescription
extends GenericBean {
    private int id = -1;
    private int linkFormId = -1;
    private Timestamp activityDate = null;
    private String descriptionOfService = null;
    private int travelHours = -1;
    private int travelMinutes = -1;
    private int laborHours = -1;
    private int laborMinutes = -1;
    private String activityDateTimeZone = null;

    public TicketPerDayDescription() {
    }

    public TicketPerDayDescription(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkFormId(int tmp) {
        this.linkFormId = tmp;
    }

    public void setLinkFormId(String tmp) {
        this.linkFormId = Integer.parseInt(tmp);
    }

    public void setActivityDate(Timestamp tmp) {
        this.activityDate = tmp;
    }

    public void setActivityDate(String tmp) {
        this.activityDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setDescriptionOfService(String tmp) {
        this.descriptionOfService = tmp;
    }

    public void setTravelHours(int tmp) {
        this.travelHours = tmp;
    }

    public void setTravelHours(String tmp) {
        this.travelHours = Integer.parseInt(tmp);
    }

    public void setTravelMinutes(int tmp) {
        this.travelMinutes = tmp;
    }

    public void setTravelMinutes(String tmp) {
        this.travelMinutes = Integer.parseInt(tmp);
    }

    public void setLaborHours(int tmp) {
        this.laborHours = tmp;
    }

    public void setLaborHours(String tmp) {
        this.laborHours = Integer.parseInt(tmp);
    }

    public void setLaborMinutes(int tmp) {
        this.laborMinutes = tmp;
    }

    public void setLaborMinutes(String tmp) {
        this.laborMinutes = Integer.parseInt(tmp);
    }

    public void setActivityDateTimeZone(String tmp) {
        this.activityDateTimeZone = tmp;
    }

    public String getActivityDateTimeZone() {
        return this.activityDateTimeZone;
    }

    public int getId() {
        return this.id;
    }

    public Timestamp getActivityDate() {
        return this.activityDate;
    }

    public String getDescriptionOfService() {
        return this.descriptionOfService;
    }

    public int getLinkFormId() {
        return this.linkFormId;
    }

    public int getTravelHours() {
        return this.travelHours;
    }

    public int getTravelMinutes() {
        return this.travelMinutes;
    }

    public int getLaborHours() {
        return this.laborHours;
    }

    public int getLaborMinutes() {
        return this.laborMinutes;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("activityDate");
        return thisList;
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "ticket_activity_item_item_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO  ticket_activity_item (" + (this.id > -1 ? "item_id, " : "") + "link_form_id, " + "activity_date, " + "activity_date_timezone, " + "description, " + "travel_hours, " + "travel_minutes, " + "labor_hours, " + "labor_minutes) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?,?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.linkFormId);
        pst.setTimestamp(++i, this.activityDate);
        pst.setString(++i, this.activityDateTimeZone);
        pst.setString(++i, this.descriptionOfService);
        pst.setInt(++i, this.travelHours);
        pst.setInt(++i, this.travelMinutes);
        pst.setInt(++i, this.laborHours);
        pst.setInt(++i, this.laborMinutes);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "ticket_activity_item_item_id_seq", this.id);
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM  ticket_activity_item WHERE item_id = ? ");
        int i = 0;
        pst.setInt(++i, this.id);
        pst.execute();
        pst.close();
    }

    public void buildRecord(HttpServletRequest request, int parseItem) throws ParseException {
        this.setDescriptionOfService(request.getParameter("descriptionOfService" + parseItem));
        this.setTravelHours(request.getParameter("travelHours" + parseItem));
        this.setTravelMinutes(request.getParameter("travelMinutes" + parseItem));
        this.setLaborHours(request.getParameter("laborHours" + parseItem));
        this.setLaborMinutes(request.getParameter("laborMinutes" + parseItem));
        this.setActivityDateTimeZone(request.getParameter("activityDate" + parseItem + "TimeZone"));
        this.sanitizeDate(request, request.getParameter("activityDate" + parseItem), "ActivityDate");
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("item_id");
        this.linkFormId = rs.getInt("link_form_id");
        this.activityDate = rs.getTimestamp("activity_date");
        this.descriptionOfService = rs.getString("description");
        this.travelHours = rs.getInt("travel_hours");
        this.travelMinutes = rs.getInt("travel_minutes");
        this.laborHours = rs.getInt("labor_hours");
        this.laborMinutes = rs.getInt("labor_minutes");
        this.activityDateTimeZone = rs.getString("activity_date_timezone");
    }
}

