/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.troubletickets.base.TicketPerDayDescription;
import org.aspcfs.utils.web.PagedListInfo;

public class TicketPerDayDescriptionList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int formId = -1;
    private int totalTravelHours = -1;
    private int totalTravelMinutes = -1;
    private int totalLaborHours = -1;
    private int totalLaborMinutes = -1;

    public TicketPerDayDescriptionList() {
    }

    public TicketPerDayDescriptionList(HttpServletRequest request, HashMap errors) {
        int i = 1;
        this.totalTravelHours = 0;
        this.totalTravelMinutes = 0;
        this.totalLaborHours = 0;
        this.totalLaborMinutes = 0;
        while (request.getParameter("activityDate" + i) != null) {
            if (!request.getParameter("activityDate" + i).trim().equals("")) {
                TicketPerDayDescription thisPerDayDescription = new TicketPerDayDescription();
                try {
                    thisPerDayDescription.buildRecord(request, i);
                    this.totalTravelHours += thisPerDayDescription.getTravelHours();
                    this.totalTravelMinutes += thisPerDayDescription.getTravelMinutes();
                    this.totalLaborHours += thisPerDayDescription.getLaborHours();
                    this.totalLaborMinutes += thisPerDayDescription.getLaborMinutes();
                }
                catch (Exception e) {
                    errors.put("activityDate" + i + "Error", "invalid date");
                }
                this.add(thisPerDayDescription);
            }
            ++i;
        }
        this.totalTravelHours += this.totalTravelMinutes / 60;
        this.totalTravelMinutes %= 60;
        this.totalLaborHours += this.totalLaborMinutes / 60;
        this.totalLaborMinutes %= 60;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setFormId(int tmp) {
        this.formId = tmp;
    }

    public void setFormId(String tmp) {
        this.formId = Integer.parseInt(tmp);
    }

    public void setTotalTravelHours(int tmp) {
        this.totalTravelHours = tmp;
    }

    public void setTotalTravelHours(String tmp) {
        this.totalTravelHours = Integer.parseInt(tmp);
    }

    public void setTotalTravelMinutes(int tmp) {
        this.totalTravelMinutes = tmp;
    }

    public void setTotalTravelMinutes(String tmp) {
        this.totalTravelMinutes = Integer.parseInt(tmp);
    }

    public void setTotalLaborHours(int tmp) {
        this.totalLaborHours = tmp;
    }

    public void setTotalLaborHours(String tmp) {
        this.totalLaborHours = Integer.parseInt(tmp);
    }

    public void setTotalLaborMinutes(int tmp) {
        this.totalLaborMinutes = tmp;
    }

    public void setTotalLaborMinutes(String tmp) {
        this.totalLaborMinutes = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getFormId() {
        return this.formId;
    }

    public int getTotalTravelHours() {
        return this.totalTravelHours;
    }

    public int getTotalTravelMinutes() {
        return this.totalTravelMinutes;
    }

    public int getTotalLaborHours() {
        return this.totalLaborHours;
    }

    public int getTotalLaborMinutes() {
        return this.totalLaborMinutes;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            TicketPerDayDescription thisDescription = this.getObject(rs);
            this.add(thisDescription);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM ticket_activity_item WHERE item_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("activity_date", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY activity_date ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("tai.* FROM ticket_activity_item tai WHERE item_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id > -1) {
            sqlFilter.append("AND item_id = ? ");
        }
        if (this.formId > -1) {
            sqlFilter.append("AND link_form_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.formId > -1) {
            pst.setInt(++i, this.formId);
        }
        return i;
    }

    public boolean deleteList(Connection db) throws SQLException {
        for (TicketPerDayDescription thisDescription : this) {
            thisDescription.delete(db);
        }
        return true;
    }

    public TicketPerDayDescription getObject(ResultSet rs) throws SQLException {
        TicketPerDayDescription thisDescription = new TicketPerDayDescription(rs);
        return thisDescription;
    }
}

