/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationReport;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Report;
import org.aspcfs.modules.base.ReportRow;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketCategoryList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class TicketReport
extends TicketList {
    protected Report rep = new Report();
    protected String delimiter = ",";
    protected String header = null;
    protected String tdFormat = "";
    protected String filePath = "";
    protected String filenameToUse = "";
    protected FileItem thisItem = new FileItem();
    protected int limitId = -1;
    protected String subject = "";
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected int createdBy = -1;
    protected ArrayList criteria = null;
    protected String[] params = new String[]{"ticketid", "organization", "problem"};
    protected boolean displayId = true;
    protected boolean displayProblem = true;
    protected boolean displayLocation = true;
    protected boolean displaySourceName = true;
    protected boolean displaySeverity = true;
    protected boolean displayPriority = true;
    protected boolean displayCategory = true;
    protected boolean displayDepartment = true;
    protected boolean displayOwner = true;
    protected boolean displaySolution = true;
    protected boolean displayClosed = true;
    protected boolean displayEntered = true;
    protected boolean displayEnteredBy = true;
    protected boolean displayModified = true;
    protected boolean displayModifiedBy = true;
    protected boolean displayAssignedTo = true;
    protected boolean displayIssueNotes = true;
    protected boolean displayOrganization = true;
    protected boolean displayEstimatedResolutionDate = true;
    protected boolean displayResolutionDate = true;
    protected boolean displayResolvedBy = true;
    protected boolean displayAssignmentDate = true;
    protected boolean displayComment = true;
    protected boolean displayContactName = true;
    protected OrganizationReport orgReportJoin = new OrganizationReport();
    protected boolean joinOrgs = false;

    public void setRep(Report tmp) {
        this.rep = tmp;
    }

    public void setDelimiter(String tmp) {
        this.delimiter = tmp;
    }

    public void setHeader(String tmp) {
        this.header = tmp;
    }

    public void setTdFormat(String tmp) {
        this.tdFormat = tmp;
    }

    public void setDisplayEstimatedResolutionDate(boolean tmp) {
        this.displayEstimatedResolutionDate = tmp;
    }

    public void setDisplayEstimatedResolutionDate(String tmp) {
        this.displayEstimatedResolutionDate = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDisplayResolutionDate(boolean tmp) {
        this.displayResolutionDate = tmp;
    }

    public void setDisplayResolutionDate(String tmp) {
        this.displayResolutionDate = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDisplayResolvedBy(boolean displayResolvedBy) {
        this.displayResolvedBy = displayResolvedBy;
    }

    public void setDisplayResolvedBy(String tmp) {
        this.displayResolvedBy = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDisplayAssignmentDate(boolean tmp) {
        this.displayAssignmentDate = tmp;
    }

    public void setDisplayAssignmentDate(String tmp) {
        this.displayAssignmentDate = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDisplayComment(boolean tmp) {
        this.displayComment = tmp;
    }

    public void setDisplayComment(String tmp) {
        this.displayComment = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDisplayIssueNotes(boolean tmp) {
        this.displayIssueNotes = tmp;
    }

    public void setDisplayIssueNotes(String tmp) {
        this.displayIssueNotes = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getDisplayIssueNotes() {
        return this.displayIssueNotes;
    }

    public boolean getDisplayEstimatedResolutionDate() {
        return this.displayEstimatedResolutionDate;
    }

    public boolean getDisplayResolutionDate() {
        return this.displayResolutionDate;
    }

    public boolean getDisplayResolvedBy() {
        return this.displayResolvedBy;
    }

    public boolean getDisplayAssignmentDate() {
        return this.displayAssignmentDate;
    }

    public boolean getDisplayComment() {
        return this.displayComment;
    }

    public Report getRep() {
        return this.rep;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getHeader() {
        return this.header;
    }

    public String getTdFormat() {
        return this.tdFormat;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public FileItem getThisItem() {
        return this.thisItem;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setThisItem(FileItem tmp) {
        this.thisItem = tmp;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public boolean getDisplayId() {
        return this.displayId;
    }

    public boolean getDisplayProblem() {
        return this.displayProblem;
    }

    public boolean getDisplayLocation() {
        return this.displayLocation;
    }

    public boolean getDisplaySourceName() {
        return this.displaySourceName;
    }

    public boolean getDisplayContactName() {
        return this.displayContactName;
    }

    public boolean getDisplaySeverity() {
        return this.displaySeverity;
    }

    public boolean getDisplayPriority() {
        return this.displayPriority;
    }

    public boolean getDisplayCategory() {
        return this.displayCategory;
    }

    public boolean getDisplayDepartment() {
        return this.displayDepartment;
    }

    public boolean getDisplayOwner() {
        return this.displayOwner;
    }

    public boolean getDisplaySolution() {
        return this.displaySolution;
    }

    public boolean getDisplayClosed() {
        return this.displayClosed;
    }

    public boolean getDisplayEntered() {
        return this.displayEntered;
    }

    public boolean getDisplayEnteredBy() {
        return this.displayEnteredBy;
    }

    public boolean getDisplayModified() {
        return this.displayModified;
    }

    public boolean getDisplayModifiedBy() {
        return this.displayModifiedBy;
    }

    public void setDisplayId(boolean tmp) {
        this.displayId = tmp;
    }

    public void setDisplayProblem(boolean tmp) {
        this.displayProblem = tmp;
    }

    public void setDisplayLocation(boolean tmp) {
        this.displayLocation = tmp;
    }

    public void setDisplaySourceName(boolean tmp) {
        this.displaySourceName = tmp;
    }

    public void setDisplayContactName(boolean tmp) {
        this.displayContactName = tmp;
    }

    public void setDisplaySeverity(boolean tmp) {
        this.displaySeverity = tmp;
    }

    public void setDisplayPriority(boolean tmp) {
        this.displayPriority = tmp;
    }

    public void setDisplayCategory(boolean tmp) {
        this.displayCategory = tmp;
    }

    public void setDisplayDepartment(boolean tmp) {
        this.displayDepartment = tmp;
    }

    public void setDisplayOwner(boolean tmp) {
        this.displayOwner = tmp;
    }

    public void setDisplaySolution(boolean tmp) {
        this.displaySolution = tmp;
    }

    public void setDisplayClosed(boolean tmp) {
        this.displayClosed = tmp;
    }

    public void setDisplayEntered(boolean tmp) {
        this.displayEntered = tmp;
    }

    public void setDisplayEnteredBy(boolean tmp) {
        this.displayEnteredBy = tmp;
    }

    public void setDisplayModified(boolean tmp) {
        this.displayModified = tmp;
    }

    public void setDisplayModifiedBy(boolean tmp) {
        this.displayModifiedBy = tmp;
    }

    public OrganizationReport getOrgReportJoin() {
        return this.orgReportJoin;
    }

    public boolean getJoinOrgs() {
        return this.joinOrgs;
    }

    public void setOrgReportJoin(OrganizationReport tmp) {
        this.orgReportJoin = tmp;
    }

    public void setJoinOrgs(boolean tmp) {
        this.joinOrgs = tmp;
    }

    public boolean getDisplayAssignedTo() {
        return this.displayAssignedTo;
    }

    public void setDisplayAssignedTo(boolean displayAssignedTo) {
        this.displayAssignedTo = displayAssignedTo;
    }

    public boolean getDisplayOrganization() {
        return this.displayOrganization;
    }

    public void setDisplayOrganization(boolean displayOrganization) {
        this.displayOrganization = displayOrganization;
    }

    public int getLimitId() {
        return this.limitId;
    }

    public void setLimitId(int limitId) {
        this.limitId = limitId;
    }

    public ArrayList getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String[] criteriaString) {
        if (criteriaString != null) {
            this.params = criteriaString;
        }
        this.criteria = new ArrayList<String>(Arrays.asList(this.params));
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(int createdBy) {
        this.createdBy = createdBy;
    }

    public void setCriteriaVars() {
        if (!this.criteria.contains("ticketid")) {
            this.displayId = false;
        }
        if (!this.criteria.contains("problem")) {
            this.displayProblem = false;
        }
        if (!this.criteria.contains("location")) {
            this.displayLocation = false;
        }
        if (!this.criteria.contains("source")) {
            this.displaySourceName = false;
        }
        if (!this.criteria.contains("contact")) {
            this.displayContactName = false;
        }
        if (!this.criteria.contains("severity")) {
            this.displaySeverity = false;
        }
        if (!this.criteria.contains("priority")) {
            this.displayPriority = false;
        }
        if (!this.criteria.contains("category")) {
            this.displayCategory = false;
        }
        if (!this.criteria.contains("department")) {
            this.displayDepartment = false;
        }
        if (!this.criteria.contains("owner")) {
            this.displayOwner = false;
        }
        if (!this.criteria.contains("solution")) {
            this.displaySolution = false;
        }
        if (!this.criteria.contains("closed")) {
            this.displayClosed = false;
        }
        if (!this.criteria.contains("entered")) {
            this.displayEntered = false;
        }
        if (!this.criteria.contains("enteredBy")) {
            this.displayEnteredBy = false;
        }
        if (!this.criteria.contains("modified")) {
            this.displayModified = false;
        }
        if (!this.criteria.contains("modifiedBy")) {
            this.displayModifiedBy = false;
        }
        if (!this.criteria.contains("assignedTo")) {
            this.displayAssignedTo = false;
        }
        if (!this.criteria.contains("contact")) {
            this.displayContactName = false;
        }
        if (!this.criteria.contains("comment")) {
            this.displayComment = false;
        }
        if (!this.criteria.contains("assignmentDate")) {
            this.displayAssignmentDate = false;
        }
        if (!this.criteria.contains("estimatedResolutionDate")) {
            this.displayEstimatedResolutionDate = false;
        }
        if (!this.criteria.contains("resolutionDate")) {
            this.displayResolutionDate = false;
        }
        if (!this.criteria.contains("resolvedBy")) {
            this.displayResolvedBy = false;
        }
        if (!this.criteria.contains("organization")) {
            this.displayOrganization = false;
        }
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getFilenameToUse() {
        return this.filenameToUse;
    }

    public void setFilenameToUse(String filenameToUse) {
        this.filenameToUse = filenameToUse;
    }

    public void buildReportBaseInfo() {
        this.rep.setDelimitedCharacter(this.delimiter);
        if (this.header != null) {
            this.rep.setHeader(this.header + ": " + this.subject);
        }
    }

    public void buildReportHeaders() {
        if (this.joinOrgs) {
            this.orgReportJoin.buildReportHeaders(this.rep);
        }
        for (String param : this.criteria) {
            if (param.equals("ticketid")) {
                this.rep.addColumn("Ticket Id");
            }
            if (param.equals("problem")) {
                this.rep.addColumn("Issue");
            }
            if (param.equals("location")) {
                this.rep.addColumn("Location");
            }
            if (param.equals("source")) {
                this.rep.addColumn("Source");
            }
            if (param.equals("severity")) {
                this.rep.addColumn("Severity");
            }
            if (param.equals("priority")) {
                this.rep.addColumn("Priority");
            }
            if (param.equals("category")) {
                this.rep.addColumn("Category");
            }
            if (param.equals("subcategory1")) {
                this.rep.addColumn("Subcategory 1");
            }
            if (param.equals("subcategory2")) {
                this.rep.addColumn("Subcategory 2");
            }
            if (param.equals("subcategory3")) {
                this.rep.addColumn("Subcategory 3");
            }
            if (param.equals("department")) {
                this.rep.addColumn("Department");
            }
            if (param.equals("solution")) {
                this.rep.addColumn("Solution");
            }
            if (param.equals("closed")) {
                this.rep.addColumn("Closed Date");
            }
            if (param.equals("entered")) {
                this.rep.addColumn("Entered");
            }
            if (param.equals("enteredBy")) {
                this.rep.addColumn("Entered By");
            }
            if (param.equals("modified")) {
                this.rep.addColumn("Modified");
            }
            if (param.equals("modifiedBy")) {
                this.rep.addColumn("Modified By");
            }
            if (param.equals("assignedTo")) {
                this.rep.addColumn("Resource Assigned");
            }
            if (param.equals("contact")) {
                this.rep.addColumn("Contact Name");
            }
            if (param.equals("comment")) {
                this.rep.addColumn("Issue Notes");
            }
            if (param.equals("assignmentDate")) {
                this.rep.addColumn("Assignment Date");
            }
            if (param.equals("estimatedResolutionDate")) {
                this.rep.addColumn("Estimated Resolution Date");
            }
            if (param.equals("resolutionDate")) {
                this.rep.addColumn("Resolution Date");
            }
            if (param.equals("resolvedBy")) {
                this.rep.addColumn("Resolved By");
            }
            if (!param.equals("organization")) continue;
            this.rep.addColumn("Organization");
        }
    }

    public void buildReportHeaders(Report passedReport) {
        for (String param : this.criteria) {
            if (param.equals("ticketid")) {
                passedReport.addColumn("Ticket Id");
            }
            if (param.equals("problem")) {
                passedReport.addColumn("Issue");
            }
            if (param.equals("location")) {
                this.rep.addColumn("Location");
            }
            if (param.equals("source")) {
                passedReport.addColumn("Source");
            }
            if (param.equals("severity")) {
                passedReport.addColumn("Severity");
            }
            if (param.equals("priority")) {
                passedReport.addColumn("Priority");
            }
            if (param.equals("category")) {
                passedReport.addColumn("Category");
            }
            if (param.equals("subcategory1")) {
                passedReport.addColumn("Subcategory 1");
            }
            if (param.equals("subcategory2")) {
                passedReport.addColumn("Subcategory 2");
            }
            if (param.equals("subcategory3")) {
                passedReport.addColumn("Subcategory 3");
            }
            if (param.equals("department")) {
                passedReport.addColumn("Department");
            }
            if (param.equals("solution")) {
                passedReport.addColumn("Solution");
            }
            if (param.equals("closed")) {
                passedReport.addColumn("Closed Date");
            }
            if (param.equals("entered")) {
                passedReport.addColumn("Entered");
            }
            if (param.equals("enteredBy")) {
                passedReport.addColumn("Entered By");
            }
            if (param.equals("modified")) {
                passedReport.addColumn("Modified");
            }
            if (param.equals("modifiedBy")) {
                passedReport.addColumn("Modified By");
            }
            if (param.equals("assignedTo")) {
                passedReport.addColumn("Resource Assigned");
            }
            if (param.equals("contact")) {
                passedReport.addColumn("Contact Name");
            }
            if (param.equals("comment")) {
                passedReport.addColumn("Issue Notes");
            }
            if (param.equals("assignmentDate")) {
                passedReport.addColumn("Assignment Date");
            }
            if (param.equals("estimatedResolutionDate")) {
                passedReport.addColumn("Estimated Resolution Date");
            }
            if (param.equals("resolutionDate")) {
                passedReport.addColumn("Resolution Date");
            }
            if (param.equals("resolvedBy")) {
                this.rep.addColumn("Resolved By");
            }
            if (!param.equals("organization")) continue;
            passedReport.addColumn("Organization");
        }
    }

    public void buildReportData(Connection db, ActionContext context) throws SQLException {
        TicketCategoryList categoryList = new TicketCategoryList();
        categoryList.setSiteId(this.getSiteId());
        categoryList.setExclusiveToSite(true);
        categoryList.buildList(db);
        this.buildList(db);
        boolean writeOut = false;
        Organization tempOrg = null;
        SystemStatus systemStatus = null;
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        for (Ticket thisTic : this) {
            if (systemStatus != null) {
                thisTic.buildHistory(db, systemStatus);
            } else {
                thisTic.buildHistory(db);
            }
            thisTic.buildContactInformation(db);
            ReportRow thisRow = new ReportRow();
            if (this.joinOrgs && thisTic.getOrgId() > -1) {
                tempOrg = new Organization(db, thisTic.getOrgId());
                if (this.limitId > -1) {
                    if (tempOrg.getOwner() == this.limitId) {
                        this.orgReportJoin.addDataRow(thisRow, tempOrg);
                        writeOut = true;
                    }
                } else {
                    this.orgReportJoin.addDataRow(thisRow, tempOrg);
                    writeOut = true;
                }
            }
            if (!this.joinOrgs || writeOut) {
                for (String param : this.criteria) {
                    if (param.equals("ticketid")) {
                        thisRow.addCell(thisTic.getId());
                    }
                    if (param.equals("problem")) {
                        thisRow.addCell(thisTic.getProblem());
                    }
                    if (param.equals("location")) {
                        thisRow.addCell(thisTic.getLocation());
                    }
                    if (param.equals("source")) {
                        thisRow.addCell(thisTic.getSourceName());
                    }
                    if (param.equals("severity")) {
                        thisRow.addCell(thisTic.getSeverityName());
                    }
                    if (param.equals("priority")) {
                        thisRow.addCell(thisTic.getPriorityName());
                    }
                    if (param.equals("category")) {
                        thisRow.addCell(categoryList.getValueFromId(thisTic.getCatCode()));
                    }
                    if (param.equals("subcategory1")) {
                        thisRow.addCell(categoryList.getValueFromId(thisTic.getSubCat1()));
                    }
                    if (param.equals("subcategory2")) {
                        thisRow.addCell(categoryList.getValueFromId(thisTic.getSubCat2()));
                    }
                    if (param.equals("subcategory3")) {
                        thisRow.addCell(categoryList.getValueFromId(thisTic.getSubCat3()));
                    }
                    if (param.equals("department")) {
                        thisRow.addCell(thisTic.getDepartmentName());
                    }
                    if (param.equals("solution")) {
                        thisRow.addCell(thisTic.getSolution());
                    }
                    if (param.equals("closed")) {
                        thisRow.addCell(thisTic.getClosedString());
                    }
                    if (param.equals("entered")) {
                        thisRow.addCell(thisTic.getEnteredString());
                    }
                    if (param.equals("enteredBy")) {
                        thisRow.addCell(UserList.retrieveUserContact(context, thisTic.getEnteredBy()).getNameLastFirst());
                    }
                    if (param.equals("modified")) {
                        thisRow.addCell(thisTic.getModifiedString());
                    }
                    if (param.equals("modifiedBy")) {
                        thisRow.addCell(UserList.retrieveUserContact(context, thisTic.getModifiedBy()).getNameLastFirst());
                    }
                    if (param.equals("assignedTo")) {
                        if (thisTic.getAssignedTo() > 0) {
                            thisRow.addCell(UserList.retrieveUserContact(context, thisTic.getAssignedTo()).getNameLastFirst());
                        } else {
                            thisRow.addCell("Unassigned");
                        }
                    }
                    if (param.equals("contact")) {
                        thisRow.addCell(thisTic.getThisContact().getNameLastFirst());
                    }
                    if (param.equals("comment")) {
                        thisRow.addCell(thisTic.getHistory().getComments());
                    }
                    if (param.equals("assignmentDate")) {
                        thisRow.addCell(DateUtils.getDateAsString(thisTic.getAssignedDate(), context));
                    }
                    if (param.equals("estimatedResolutionDate")) {
                        thisRow.addCell(DateUtils.getDateAsString(thisTic.getEstimatedResolutionDate(), context));
                    }
                    if (param.equals("resolutionDate")) {
                        thisRow.addCell(DateUtils.getDateAsString(thisTic.getResolutionDate(), context));
                    }
                    if (param.equals("resolvedBy")) {
                        if (thisTic.getResolvedBy() > 0) {
                            thisRow.addCell(UserList.retrieveUserContact(context, thisTic.getResolvedBy()).getNameLastFirst());
                        } else {
                            thisRow.addCell(" ");
                        }
                    }
                    if (!param.equals("organization")) continue;
                    thisRow.addCell(thisTic.getCompanyName());
                }
                this.rep.addRow(thisRow);
            }
            writeOut = false;
        }
    }

    public void buildReportFull(Connection db, ActionContext context) throws SQLException {
        this.buildReportBaseInfo();
        this.buildReportHeaders();
        this.buildReportData(db, context);
    }

    public boolean saveAndInsert(Connection db) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        this.filenameToUse = formatter.format(new Date());
        File f = new File(this.filePath);
        f.mkdirs();
        File fileLink = new File(this.filePath + this.filenameToUse + ".csv");
        this.rep.saveHtml(this.filePath + this.filenameToUse + ".html");
        this.rep.saveDelimited(this.filePath + this.filenameToUse + ".csv");
        if (this.joinOrgs) {
            this.thisItem.setLinkModuleId(10);
        } else {
            this.thisItem.setLinkModuleId(13);
        }
        this.thisItem.setLinkItemId(0);
        this.thisItem.setEnteredBy(this.enteredBy);
        this.thisItem.setModifiedBy(this.modifiedBy);
        this.thisItem.setSubject(this.subject);
        this.thisItem.setClientFilename(this.filenameToUse + ".csv");
        this.thisItem.setFilename(this.filenameToUse);
        this.thisItem.setSize((int)fileLink.length());
        this.thisItem.insert(db);
        return true;
    }
}

