/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.components;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.troubletickets.base.TicketList;

public class GenerateTicketList
extends ObjectHookComponent
implements ComponentInterface {
    public static final String ONLY_OPEN = "ticketList.onlyOpen";
    public static final String ONLY_ASSIGNED = "ticketList.onlyAssigned";
    public static final String ONLY_UNASSIGNED = "ticketList.onlyUnassigned";
    public static final String MINUTES_OLDER_THAN = "ticketList.minutesOlderThan";
    public static final String LAST_ANCHOR = "ticketList.lastAnchor";
    public static final String NEXT_ANCHOR = "ticketList.nextAnchor";

    public String getDescription() {
        return "Generate a list of tickets based on specified parameters.  Are there any tickets matching the parameters?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        TicketList tickets = new TicketList();
        tickets.setOnlyOpen(context.getParameterAsBoolean(ONLY_OPEN));
        if (context.hasParameter(ONLY_ASSIGNED)) {
            tickets.setOnlyAssigned(context.getParameterAsBoolean(ONLY_ASSIGNED));
        }
        if (context.hasParameter(ONLY_UNASSIGNED)) {
            tickets.setOnlyUnassigned(context.getParameterAsBoolean(ONLY_UNASSIGNED));
        }
        if (context.hasParameter(LAST_ANCHOR) || context.hasParameter(NEXT_ANCHOR)) {
            tickets.setSyncType(5);
            tickets.setLastAnchor(context.getParameter(LAST_ANCHOR));
            tickets.setNextAnchor(context.getParameter(NEXT_ANCHOR));
        }
        if (context.hasParameter(MINUTES_OLDER_THAN)) {
            tickets.setMinutesOlderThan(context.getParameterAsInt(MINUTES_OLDER_THAN));
        }
        Connection db = null;
        try {
            db = GenerateTicketList.getConnection(context);
            tickets.buildList(db);
            context.setObjects(tickets);
            if (tickets.size() > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
        }
        finally {
            GenerateTicketList.freeConnection(context, db);
        }
        return result;
    }
}

