/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketCategory;
import org.aspcfs.utils.web.LookupElement;

public class LoadTicketDetails
extends ObjectHookComponent
implements ComponentInterface {
    public static final String ORGANIZATION = "ticketOrganization";
    public static final String CONTACT = "ticketContact";
    public static final String CATEGORY_LOOKUP = "ticketCategoryLookup";
    public static final String SUBCATEGORY1_LOOKUP = "ticketSubCategory1Lookup";
    public static final String SUBCATEGORY2_LOOKUP = "ticketSubCategory2Lookup";
    public static final String SUBCATEGORY3_LOOKUP = "ticketSubCategory3Lookup";
    public static final String SEVERITY_LOOKUP = "ticketSeverityLookup";
    public static final String PRIORITY_LOOKUP = "ticketPriorityLookup";
    public static final String ENTERED_BY_CONTACT = "ticketEnteredByContact";
    public static final String MODIFIED_BY_CONTACT = "ticketModifiedByContact";
    public static final String ASSIGNED_TO_CONTACT = "ticketAssignedToContact";
    public static final String GROUP_USERS = "ticketGroupUsers";
    public static final String TICKET_CATEGORIES = "ticketCategories";
    public static final String ENTERED_DATE = "process.ticketEnteredDate";
    public static final String PROJECT_ID = "projectTicket.id";

    public String getDescription() {
        return "Load all ticket information for use in other steps";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        Ticket thisTicket = (Ticket)((Object)context.getThisObject());
        Ticket previousTicket = (Ticket)((Object)context.getPreviousObject());
        Connection db = null;
        try {
            Contact contact;
            LookupElement priorityLookup;
            TicketCategory temp;
            User user;
            db = LoadTicketDetails.getConnection(context);
            context.setAttribute(ENTERED_DATE, thisTicket.getEnteredString(1, 3));
            if (thisTicket.getOrgId() > -1) {
                Organization organization = new Organization(db, thisTicket.getOrgId());
                context.setAttribute(ORGANIZATION, (Object)organization);
            } else {
                context.setAttribute(ORGANIZATION, (Object)new Organization());
            }
            int projectId = thisTicket.getProjectIdByTicket(db);
            if (projectId > -1) {
                context.setAttribute(PROJECT_ID, String.valueOf(projectId));
            }
            if (thisTicket.getAssignedTo() > 0) {
                user = new User();
                user.setBuildContact(true);
                user.buildRecord(db, thisTicket.getAssignedTo());
                context.setAttribute(ASSIGNED_TO_CONTACT, (Object)user.getContact());
            } else {
                context.setAttribute(ASSIGNED_TO_CONTACT, (Object)new Contact());
            }
            if (thisTicket.getContactId() > 0) {
                Contact contact2 = new Contact(db, thisTicket.getContactId());
                context.setAttribute(CONTACT, (Object)contact2);
            } else {
                context.setAttribute(CONTACT, (Object)new Contact());
            }
            if (thisTicket.getCatCode() > 0) {
                TicketCategory categoryLookup = new TicketCategory(db, thisTicket.getCatCode());
                context.setAttribute(CATEGORY_LOOKUP, (Object)categoryLookup);
            } else {
                context.setAttribute(CATEGORY_LOOKUP, (Object)new TicketCategory());
            }
            if (thisTicket.getSubCat1() > 0) {
                TicketCategory subCategory1Lookup = new TicketCategory(db, thisTicket.getSubCat1());
                context.setAttribute(SUBCATEGORY1_LOOKUP, (Object)subCategory1Lookup);
            } else {
                temp = new TicketCategory();
                context.setAttribute(SUBCATEGORY1_LOOKUP, (Object)temp);
            }
            if (thisTicket.getSubCat2() > 0) {
                TicketCategory subCategory2Lookup = new TicketCategory(db, thisTicket.getSubCat2());
                context.setAttribute(SUBCATEGORY2_LOOKUP, (Object)subCategory2Lookup);
            } else {
                temp = new TicketCategory();
                context.setAttribute(SUBCATEGORY2_LOOKUP, (Object)temp);
            }
            if (thisTicket.getSubCat3() > 0) {
                TicketCategory subCategory3Lookup = new TicketCategory(db, thisTicket.getSubCat3());
                context.setAttribute(SUBCATEGORY3_LOOKUP, (Object)subCategory3Lookup);
            } else {
                temp = new TicketCategory();
                context.setAttribute(SUBCATEGORY3_LOOKUP, (Object)temp);
            }
            if (thisTicket.getSeverityCode() > 0) {
                LookupElement severityLookup = new LookupElement(db, thisTicket.getSeverityCode(), "ticket_severity");
                context.setAttribute(SEVERITY_LOOKUP, severityLookup);
            } else {
                context.setAttribute(SEVERITY_LOOKUP, new LookupElement());
            }
            if (thisTicket.getPriorityCode() > 0) {
                priorityLookup = new LookupElement(db, thisTicket.getPriorityCode(), "ticket_priority");
                context.setAttribute(PRIORITY_LOOKUP, priorityLookup);
            } else {
                priorityLookup = new LookupElement();
                context.setAttribute(PRIORITY_LOOKUP, priorityLookup);
            }
            if (thisTicket.getModifiedBy() > 0) {
                user = new User(db, thisTicket.getModifiedBy());
                contact = new Contact(db, user.getContactId());
                context.setAttribute(MODIFIED_BY_CONTACT, (Object)contact);
            } else {
                context.setAttribute(MODIFIED_BY_CONTACT, (Object)new Contact());
            }
            if (thisTicket.getEnteredBy() > 0) {
                user = null;
                user = previousTicket != null ? new User(db, previousTicket.getEnteredBy()) : new User(db, thisTicket.getEnteredBy());
                contact = new Contact(db, user.getContactId());
                context.setAttribute(ENTERED_BY_CONTACT, (Object)contact);
            } else {
                context.setAttribute(ENTERED_BY_CONTACT, (Object)new Contact());
            }
            result = true;
        }
        catch (Exception e) {
        }
        finally {
            LoadTicketDetails.freeConnection(context, db);
        }
        return result;
    }
}

