/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.components;

import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.components.EmailDigestUtil;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.modules.troubletickets.components.LoadTicketDetails;

public class SendTicketListReport
extends ObjectHookComponent
implements ComponentInterface {
    public static final String REPORT_TICKET_CONTENT = "report.ticket.content";
    private static final String PREFIX = "TICKET";

    public String getDescription() {
        return "Sends a ticket report to specified users with the specified parameters";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        if (!context.hasObjects()) {
            return false;
        }
        boolean result = false;
        Connection db = null;
        HashMap mailList = new HashMap();
        TicketList tickets = (TicketList)context.getObjects();
        try {
            db = SendTicketListReport.getConnection(context);
            LoadTicketDetails loadTicket = new LoadTicketDetails();
            for (Ticket thisTicket : tickets) {
                context.setThisObject((Object)thisTicket);
                loadTicket.execute(context);
                String thisMessage = context.getParameter(REPORT_TICKET_CONTENT, (Object)thisTicket, null);
                EmailDigestUtil.appendEmailAddresses(mailList, context.getParameter("notification.to"), thisMessage, PREFIX + thisTicket.getId());
                EmailDigestUtil.appendEmailUsers(db, mailList, context.getParameter("notification.users.to", (Object)thisTicket, null), thisMessage, PREFIX + thisTicket.getId());
                EmailDigestUtil.appendEmailContacts(db, mailList, context.getParameter("notification.contacts.to", (Object)thisTicket, null), thisMessage, PREFIX + thisTicket.getId());
            }
            EmailDigestUtil.sendMail(context, mailList);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            SendTicketListReport.freeConnection(context, db);
        }
        return result;
    }
}

