/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.webservices;

import java.util.ArrayList;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldData;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.webservices.beans.WSCustomFolder;
import org.aspcfs.modules.webservices.beans.WSUserBean;
import org.aspcfs.utils.CRMConnection;
import org.aspcfs.utils.PasswordHash;

public class CentricServices {
    private CRMConnection crm = new CRMConnection();

    public void setAuthenticationInfo(AuthenticationItem auth) {
        this.crm.setUrl(auth.getUrl());
        this.crm.setId(auth.getId());
        this.crm.setSystemId(auth.getSystemId());
        this.crm.setClientId(auth.getClientId());
        this.crm.setUsername(auth.getUsername());
        this.crm.setCode(auth.getCode());
    }

    public int validateUser(AuthenticationItem in0, String in1, String in2) {
        try {
            String username = in1;
            String password = in2;
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("id");
            this.crm.setTransactionMeta(meta);
            DataRecord login = new DataRecord();
            login.setName("userList");
            login.setAction("select");
            login.addField("username", username);
            login.addField("password", PasswordHash.encrypt(password));
            this.crm.save(login);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            return this.crm.getRecordCount() == 1 ? Integer.parseInt(this.crm.getResponseValue("id")) : -1;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return -1;
        }
    }

    public WSUserBean[] retrievePhoneUsers(AuthenticationItem in0) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("id");
            meta.add("username");
            this.crm.setTransactionMeta(meta);
            DataRecord login = new DataRecord();
            login.setName("userList");
            login.setAction("select");
            login.addField("enabled", 1);
            this.crm.save(login);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.apps.axis.beans.WSUserBean").toArray();
            WSUserBean[] logins = new WSUserBean[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                WSUserBean thisUser = (WSUserBean)((Object)objects[i]);
                Contact contact = this.getContact(in0, thisUser.getId());
                if (contact != null) {
                    thisUser.setNameFirst(contact.getNameFirst());
                    thisUser.setNameLast(contact.getNameLast());
                }
                logins[i] = thisUser;
            }
            return logins;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private Contact getContact(AuthenticationItem in0, int in1) {
        try {
            int userId = in1;
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("nameFirst");
            meta.add("nameLast");
            this.crm.setTransactionMeta(meta);
            DataRecord contact = new DataRecord();
            contact.setName("contactList");
            contact.setAction("select");
            contact.addField("contactUserId", userId);
            this.crm.save(contact);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            ArrayList contacts = this.crm.getRecords("org.aspcfs.modules.contacts.base.Contact");
            if (contacts.size() == 1) {
                return (Contact)((Object)contacts.get(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public WSCustomFolder[] retrieveAccountFolders(AuthenticationItem in0, int in1) {
        try {
            int accountId = in1;
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("id");
            meta.add("linkItemId");
            meta.add("name");
            meta.add("description");
            this.crm.setTransactionMeta(meta);
            DataRecord category = new DataRecord();
            category.setName("customFieldCategoryList");
            category.setAction("select");
            category.addField("linkModuleId", 1);
            category.addField("linkItemId", accountId);
            this.crm.save(category);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.apps.axis.beans.WSCustomFolder").toArray();
            WSCustomFolder[] folders = new WSCustomFolder[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                folders[i] = (WSCustomFolder)((Object)objects[i]);
            }
            return folders;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public CustomField[] retrieveCustomFields(AuthenticationItem in0, int in1) {
        try {
            int folderId = in1;
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("id");
            meta.add("name");
            this.crm.setTransactionMeta(meta);
            DataRecord category = new DataRecord();
            category.setName("customFieldList");
            category.setAction("select");
            category.addField("categoryId", folderId);
            this.crm.save(category);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.base.CustomField").toArray();
            CustomField[] fields = new CustomField[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                fields[i] = (CustomField)objects[i];
            }
            return fields;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public CustomFieldData[] retrieveCustomData(AuthenticationItem in0, int in1, int in2, int in3) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            int accountId = in1;
            int folderId = in2;
            int fieldId = in3;
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("enteredValue");
            this.crm.setTransactionMeta(meta);
            DataRecord category = new DataRecord();
            category.setName("customFieldDataList");
            category.setAction("select");
            category.addField("linkModuleId", 1);
            category.addField("linkItemId", accountId);
            category.addField("categoryId", folderId);
            category.addField("fieldId", fieldId);
            this.crm.save(category);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.base.CustomFieldData").toArray();
            CustomFieldData[] data = new CustomFieldData[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                data[i] = (CustomFieldData)((Object)objects[i]);
            }
            return data;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public boolean addCustomRecord(AuthenticationItem in0, int in1, int in2, int in3, int in4, int in5) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            int userId = in1;
            int folderId = in2;
            int fieldId = in3;
            int accountId = in4;
            int input = in5;
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("id");
            this.crm.setTransactionMeta(meta);
            DataRecord customRecord = new DataRecord();
            customRecord.setName("customFieldRecord");
            customRecord.setAction("insert");
            customRecord.setShareKey(true);
            customRecord.addField("linkModuleId", 1);
            customRecord.addField("linkItemId", accountId);
            customRecord.addField("categoryId", folderId);
            customRecord.addField("enteredBy", userId);
            customRecord.addField("modifiedBy", userId);
            this.crm.save(customRecord);
            DataRecord customData = new DataRecord();
            customData.setName("customFieldData");
            customData.setAction("insert");
            customData.setShareKey(true);
            customData.addField("recordId", "$C{customFieldRecord.id}");
            customData.addField("fieldId", fieldId);
            customData.addField("enteredValue", input);
            customData.addField("enteredNumber", input);
            customData.addField("enteredDouble", input);
            this.crm.save(customData);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return this.crm.getStatus() == 0;
    }
}

