/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.Tab;
import org.aspcfs.modules.website.icelet.HtmlContentPortlet;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;

public final class PageGroups
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return PageGroups.getReturn(context, "Default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        String nextPageGroupId;
        String previousPageGroupId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        PageGroup pageGroup = (PageGroup)((Object)context.getFormBean());
        String tabId = context.getRequest().getParameter("tabId");
        if (tabId == null || "".equals(tabId.trim())) {
            tabId = (String)context.getRequest().getAttribute("tabId");
        }
        if (tabId != null && !"".equals(tabId.trim())) {
            pageGroup.setTabId(tabId);
        }
        if ((previousPageGroupId = context.getRequest().getParameter("previousPageGroupId")) == null || "".equals(previousPageGroupId.trim())) {
            previousPageGroupId = (String)context.getRequest().getAttribute("previousPageGroupId");
        }
        if (previousPageGroupId != null && !"".equals(previousPageGroupId)) {
            pageGroup.setPreviousPageGroupId(previousPageGroupId);
            context.getRequest().setAttribute("previousPageGroupId", (Object)previousPageGroupId);
        }
        if ((nextPageGroupId = context.getRequest().getParameter("nextPageGroupId")) == null || "".equals(nextPageGroupId.trim())) {
            nextPageGroupId = (String)context.getRequest().getAttribute("nextPageGroupId");
        }
        if (nextPageGroupId != null && !"".equals(nextPageGroupId)) {
            pageGroup.setNextPageGroupId(nextPageGroupId);
        }
        Tab tab = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            tab = new Tab();
            tab.queryRecord(db, Integer.parseInt(tabId));
            tab.buildPageGroupList(db);
            context.getRequest().setAttribute("tab", (Object)tab);
            context.getRequest().setAttribute("thisPageGroup", (Object)pageGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageGroups.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        String pageGroupId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String tabId = context.getRequest().getParameter("tabId");
        if (tabId == null || "".equals(tabId.trim())) {
            tabId = (String)context.getRequest().getAttribute("tabId");
        }
        if ((pageGroupId = context.getRequest().getParameter("pageGroupId")) == null || "".equals(pageGroupId.trim())) {
            pageGroupId = (String)context.getRequest().getAttribute("pageGroupId");
        }
        PageGroup pageGroup = (PageGroup)((Object)context.getFormBean());
        Tab tab = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            tab = new Tab();
            tab.queryRecord(db, Integer.parseInt(tabId));
            tab.buildPageGroupList(db);
            context.getRequest().setAttribute("tab", (Object)tab);
            if (pageGroup.getId() == -1) {
                pageGroup = new PageGroup(db, Integer.parseInt(pageGroupId));
            }
            pageGroup.setTabId(tabId);
            context.getRequest().setAttribute("thisPageGroup", (Object)pageGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageGroups.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String tabId = context.getRequest().getParameter("tabId");
        if (tabId == null || "".equals(tabId.trim())) {
            tabId = (String)context.getRequest().getAttribute("tabId");
        }
        String previousPageId = context.getRequest().getParameter("previousPageId");
        String nextPageId = context.getRequest().getParameter("nextPageId");
        boolean isValid = false;
        boolean recordInserted = false;
        int recordCount = -1;
        PageGroup pageGroup = (PageGroup)((Object)context.getFormBean());
        Object tab = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (pageGroup.getTabId() == -1) {
                pageGroup.setTabId(tabId);
            }
            pageGroup.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)pageGroup);
            if (isValid) {
                if (pageGroup.getId() > -1) {
                    recordCount = pageGroup.update(db);
                } else {
                    pageGroup.setPosition(pageGroup.computePageGroupPosition(db));
                    recordInserted = pageGroup.insert(db);
                    if (recordInserted) {
                        this.insertDefaultData(context, db, pageGroup.getId());
                    }
                }
            }
            if (!isValid || !recordInserted && recordCount == -1) {
                if (nextPageId != null && !"".equals(nextPageId.trim())) {
                    context.getRequest().setAttribute("nextPageId", (Object)nextPageId);
                }
                if (previousPageId != null && !"".equals(previousPageId.trim())) {
                    context.getRequest().setAttribute("previousPageId", (Object)previousPageId);
                }
                if (pageGroup.getId() > -1) {
                    String string = this.executeCommandModify(context);
                    return string;
                }
                String string = this.executeCommandAdd(context);
                return string;
            }
            context.getRequest().setAttribute("tabId", (Object)String.valueOf(pageGroup.getTabId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageGroups.getReturn(context, "Save");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageGroupId = context.getRequest().getParameter("pageGroupId");
        String movePageGroupUp = context.getRequest().getParameter("movePageGroupUp");
        if (movePageGroupUp == null || "".equals(movePageGroupUp.trim())) {
            movePageGroupUp = new String("YES");
        }
        PageGroup pageGroup = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageGroup = new PageGroup(db, Integer.parseInt(pageGroupId));
            pageGroup.move(db, DatabaseUtils.parseBoolean(movePageGroupUp));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageGroups.getReturn(context, "Move");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        String pageGroupId;
        String tabId;
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((tabId = context.getRequest().getParameter("tabId")) == null || "".equals(tabId.trim())) {
            tabId = (String)context.getRequest().getAttribute("tabId");
        }
        if ((pageGroupId = context.getRequest().getParameter("pageGroupId")) == null || "".equals(pageGroupId.trim())) {
            pageGroupId = (String)context.getRequest().getAttribute("pageGroupId");
        }
        PageGroup pageGroup = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageGroup = new PageGroup(db, Integer.parseInt(pageGroupId));
            DependencyList dependencies = pageGroup.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("actionphase.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='PageGroups.do?command=Delete&pageGroupId=" + pageGroup.getId() + "&siteId=" + siteId + "&popup=true'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageGroups.getReturn(context, "ConfirmDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        String pageGroupId;
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId != null && !"".equals(siteId)) {
            context.getRequest().setAttribute("siteId", (Object)siteId);
        }
        if ((pageGroupId = context.getRequest().getParameter("pageGroupId")) == null || "".equals(pageGroupId)) {
            pageGroupId = (String)context.getRequest().getAttribute("pageGroupId");
        }
        PageGroup pageGroup = null;
        int tabId = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageGroup = new PageGroup();
            pageGroup.queryRecord(db, Integer.parseInt(pageGroupId));
            pageGroup.buildPageList(db);
            tabId = pageGroup.getTabId();
            pageGroup.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("Sites.do?command=Details&siteId=" + siteId + "&tabId=" + tabId + "&pageId=-1&popup=true"));
        return PageGroups.getReturn(context, "Delete");
    }

    public void insertDefaultData(ActionContext context, Connection db, int pageGroupId) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        int userId = this.getUserId(context);
        PageVersion pageVersion = new PageVersion();
        pageVersion.setVersionNumber(1);
        pageVersion.setModifiedBy(userId);
        pageVersion.insert(db);
        Page page = new Page();
        page.setName(systemStatus.getLabel("", "Home"));
        page.setPageGroupId(pageGroupId);
        page.setConstructionPageVersionId(pageVersion.getId());
        page.setActivePageVersionId(pageVersion.getId());
        page.setPosition(0);
        page.setEnabled(true);
        page.setModifiedBy(userId);
        page.insert(db);
        pageVersion = new PageVersion(db, pageVersion.getId());
        pageVersion.setOverride(true);
        pageVersion.setPageId(page.getId());
        pageVersion.update(db);
        PageRow pageRow = new PageRow();
        pageRow.setPageVersionId(page.getConstructionPageVersionId());
        pageRow.setPosition(0);
        pageRow.setEnabled(true);
        pageRow.setModifiedBy(userId);
        pageRow.insert(db);
        Icelet htmlIcelet = null;
        IceletList iceletList = new IceletList();
        iceletList.setConfiguratorClass("HtmlContentPortlet");
        iceletList.buildList(db);
        if (iceletList.size() > 0) {
            htmlIcelet = (Icelet)((Object)iceletList.get(0));
        }
        RowColumn rowColumn = new RowColumn();
        rowColumn.setPageRowId(pageRow.getId());
        rowColumn.setModifiedBy(userId);
        rowColumn.setEnabled(true);
        rowColumn.setWidth(100);
        rowColumn.setPosition(0);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            rowColumn.setIceletId(htmlIcelet.getId());
        }
        rowColumn.insert(db);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            IceletProperty property = new IceletProperty();
            property.setRowColumnId(rowColumn.getId());
            property.setValue("Please enter your html text here");
            property.setTypeConstant(HtmlContentPortlet.PROPERTY_HTMLTEXT);
            property.setModifiedBy(userId);
            property.insert(db);
        }
    }
}

