/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.icelet.HtmlContentPortlet;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;

public final class PageRows
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return PageRows.getReturn(context, "Default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        String nextPageRowId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageVersionId = context.getRequest().getParameter("pageVersionId");
        String rowColumnId = context.getRequest().getParameter("rowColumnId");
        PageRow pageRow = (PageRow)((Object)context.getFormBean());
        String previousPageRowId = context.getRequest().getParameter("previousPageRowId");
        if (previousPageRowId != null && !"".equals(previousPageRowId.trim())) {
            pageRow.setPreviousPageRowId(previousPageRowId);
        }
        if ((nextPageRowId = context.getRequest().getParameter("nextPageRowId")) != null && !"".equals(nextPageRowId.trim())) {
            pageRow.setNextPageRowId(nextPageRowId);
        }
        PageVersion pageVersion = null;
        RowColumn rowColumn = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (pageVersionId != null && !"".equals(pageVersionId.trim()) && !"-1".equals(pageVersionId.trim())) {
                pageVersion = new PageVersion(db, Integer.parseInt(pageVersionId));
                if (pageRow.getPageVersionId() == -1) {
                    pageRow.setPageVersionId(pageVersionId);
                }
            } else if (rowColumnId != null && !"".equals(rowColumnId.trim()) && !"-1".equals(rowColumnId.trim())) {
                rowColumn = new RowColumn(db, Integer.parseInt(rowColumnId));
                if (pageRow.getRowColumnId() == -1) {
                    pageRow.setRowColumnId(rowColumnId);
                }
            }
            pageRow.setModifiedBy(this.getUserId(context));
            pageRow.setEnabled(true);
            pageRow.setPosition(pageRow.computePageRowPosition(db));
            pageRow.insert(db);
            this.insertDefaultData(context, db, pageRow.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageRows.getReturn(context, "Save");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageVersionId = context.getRequest().getParameter("pageVersionId");
        String rowColumnId = context.getRequest().getParameter("rowColumnId");
        String pageRowId = context.getRequest().getParameter("pageRowId");
        String movePageRowUp = context.getRequest().getParameter("movePageRowUp");
        if (movePageRowUp == null || "".equals(movePageRowUp.trim())) {
            movePageRowUp = new String("YES");
        }
        PageVersion pageVersion = null;
        RowColumn rowColumn = null;
        PageRow pageRow = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageRow = new PageRow(db, Integer.parseInt(pageRowId));
            if (pageVersionId != null && !"".equals(pageVersionId.trim()) && !"-1".equals(pageVersionId.trim())) {
                pageVersion = new PageVersion(db, Integer.parseInt(pageVersionId));
                if (pageRow.getPageVersionId() == -1) {
                    pageRow.setPageVersionId(pageVersionId);
                }
            } else if (rowColumnId != null && !"".equals(rowColumnId.trim()) && !"-1".equals(rowColumnId.trim())) {
                rowColumn = new RowColumn(db, Integer.parseInt(rowColumnId));
                if (pageRow.getRowColumnId() == -1) {
                    pageRow.setRowColumnId(rowColumnId);
                }
            }
            pageRow.move(db, DatabaseUtils.parseBoolean(movePageRowUp));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageRows.getReturn(context, "Move");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        String pageVersionId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((pageVersionId = context.getRequest().getParameter("pageVersionId")) == null || "".equals(pageVersionId.trim())) {
            pageVersionId = (String)context.getRequest().getAttribute("pageVersionId");
        }
        String rowColumnId = context.getRequest().getParameter("rowColumnId");
        String pageRowId = context.getRequest().getParameter("pageRowId");
        if (pageRowId == null || "".equals(pageRowId.trim())) {
            pageRowId = (String)context.getRequest().getAttribute("pageRowId");
        }
        RowColumn rowColumn = null;
        PageRow pageRow = null;
        Object pageVersion = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageRow = new PageRow(db, Integer.parseInt(pageRowId));
            if (rowColumnId != null && !"".equals(rowColumnId.trim()) && !"-1".equals(rowColumnId.trim())) {
                rowColumn = new RowColumn(db, Integer.parseInt(rowColumnId));
            }
            DependencyList dependencies = pageRow.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("actionphase.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='PageRows.do?command=Delete" + (pageRow.getPageVersionId() != -1 ? "&pageVersionId=" + pageRow.getPageVersionId() : "") + "&pageRowId=" + pageRow.getId() + "&siteId=" + siteId + "&popup=true'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return PageRows.getReturn(context, "ConfirmDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        String pageRowId;
        String pageVersionId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((pageVersionId = context.getRequest().getParameter("pageVersionId")) != null && !"".equals(pageVersionId)) {
            context.getRequest().setAttribute("pageVersionId", (Object)pageVersionId);
        }
        if ((pageRowId = context.getRequest().getParameter("pageRowId")) == null || "".equals(pageRowId)) {
            pageRowId = (String)context.getRequest().getAttribute("pageRowId");
        }
        PageVersion pageVersion = null;
        PageRow pageRow = null;
        int tabId = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (pageVersionId != null && !"".equals(pageVersionId.trim()) && !"-1".equals(pageVersionId.trim())) {
                pageVersion = new PageVersion(db, Integer.parseInt(pageVersionId));
                tabId = pageVersion.getTabIdByPageVersionId(db);
            }
            pageRow = new PageRow();
            pageRow.queryRecord(db, Integer.parseInt(pageRowId));
            pageRow.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("Sites.do?command=Details&siteId=" + siteId + "&tabId=" + tabId + "&pageId=" + (pageVersion != null ? pageVersion.getPageId() : -1) + "&popup=true"));
        return PageRows.getReturn(context, "Delete");
    }

    public void insertDefaultData(ActionContext context, Connection db, int rowId) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        int userId = this.getUserId(context);
        Icelet htmlIcelet = null;
        IceletList iceletList = new IceletList();
        iceletList.setConfiguratorClass("HtmlContentPortlet");
        iceletList.buildList(db);
        if (iceletList.size() > 0) {
            htmlIcelet = (Icelet)((Object)iceletList.get(0));
        }
        RowColumn rowColumn = new RowColumn();
        rowColumn.setPageRowId(rowId);
        rowColumn.setModifiedBy(userId);
        rowColumn.setEnabled(true);
        rowColumn.setWidth(100);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            rowColumn.setIceletId(htmlIcelet.getId());
        }
        rowColumn.setPosition(0);
        rowColumn.insert(db);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            IceletProperty property = new IceletProperty();
            property.setRowColumnId(rowColumn.getId());
            property.setValue("Please enter your html text here");
            property.setTypeConstant(HtmlContentPortlet.PROPERTY_HTMLTEXT);
            property.setModifiedBy(userId);
            property.insert(db);
        }
    }
}

