/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.icelet.HtmlContentPortlet;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;

public final class Pages
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return Pages.getReturn(context, "Default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        String nextPageId;
        String previousPageId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        Page page = (Page)((Object)context.getFormBean());
        String pageGroupId = context.getRequest().getParameter("pageGroupId");
        if (pageGroupId == null || "".equals(pageGroupId.trim())) {
            pageGroupId = (String)context.getRequest().getAttribute("pageGroupId");
        }
        if (pageGroupId != null && !"".equals(pageGroupId.trim())) {
            page.setPageGroupId(pageGroupId);
        }
        if ((previousPageId = context.getRequest().getParameter("previousPageId")) == null || "".equals(previousPageId.trim())) {
            previousPageId = (String)context.getRequest().getAttribute("previousPageId");
        }
        if (previousPageId != null && !"".equals(previousPageId)) {
            page.setPreviousPageId(previousPageId);
            context.getRequest().setAttribute("previousPageId", (Object)previousPageId);
        }
        if ((nextPageId = context.getRequest().getParameter("nextPageId")) == null || "".equals(nextPageId.trim())) {
            nextPageId = (String)context.getRequest().getAttribute("nextPageId");
        }
        if (nextPageId != null && !"".equals(nextPageId)) {
            page.setNextPageId(nextPageId);
        }
        PageGroup pageGroup = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageGroup = new PageGroup();
            pageGroup.queryRecord(db, Integer.parseInt(pageGroupId));
            pageGroup.buildPageList(db);
            context.getRequest().setAttribute("pageGroup", (Object)pageGroup);
            context.getRequest().setAttribute("thisPage", (Object)page);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Pages.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        String pageId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageGroupId = context.getRequest().getParameter("pageGroupId");
        if (pageGroupId == null || "".equals(pageGroupId.trim())) {
            pageGroupId = (String)context.getRequest().getAttribute("pageGroupId");
        }
        if ((pageId = context.getRequest().getParameter("pageId")) == null || "".equals(pageId.trim())) {
            pageId = (String)context.getRequest().getAttribute("pageId");
        }
        Page page = (Page)((Object)context.getFormBean());
        PageGroup pageGroup = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageGroup = new PageGroup();
            pageGroup.queryRecord(db, Integer.parseInt(pageGroupId));
            pageGroup.buildPageList(db);
            context.getRequest().setAttribute("pageGroup", (Object)pageGroup);
            if (page.getId() == -1) {
                page = new Page(db, Integer.parseInt(pageId));
            }
            page.setPageGroupId(pageGroupId);
            context.getRequest().setAttribute("thisPage", (Object)page);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Pages.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageGroupId = context.getRequest().getParameter("pageGroupId");
        if (pageGroupId == null || "".equals(pageGroupId.trim())) {
            pageGroupId = (String)context.getRequest().getAttribute("pageGroupId");
        }
        String previousPageId = context.getRequest().getParameter("previousPageId");
        String nextPageId = context.getRequest().getParameter("nextPageId");
        boolean isValid = false;
        boolean recordInserted = false;
        int recordCount = -1;
        Page page = (Page)((Object)context.getFormBean());
        Object pageGroup = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (page.getPageGroupId() == -1) {
                page.setPageGroupId(pageGroupId);
            }
            page.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)page);
            if (isValid) {
                if (page.getId() > -1) {
                    recordCount = page.update(db);
                } else {
                    page.setPosition(page.computePagePosition(db));
                    recordInserted = page.insert(db);
                    if (recordInserted) {
                        this.insertDefaultData(context, db, page);
                    }
                }
            }
            if (!isValid || !recordInserted && recordCount == -1) {
                if (nextPageId != null && !"".equals(nextPageId.trim())) {
                    context.getRequest().setAttribute("nextPageId", (Object)nextPageId);
                }
                if (previousPageId != null && !"".equals(previousPageId.trim())) {
                    context.getRequest().setAttribute("previousPageId", (Object)previousPageId);
                }
                if (page.getId() > -1) {
                    String string = this.executeCommandModify(context);
                    return string;
                }
                String string = this.executeCommandAdd(context);
                return string;
            }
            context.getRequest().setAttribute("pageGroupId", (Object)String.valueOf(page.getPageGroupId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Pages.getReturn(context, "Save");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageId = context.getRequest().getParameter("pageId");
        String movePageUp = context.getRequest().getParameter("movePageUp");
        if (movePageUp == null || "".equals(movePageUp.trim())) {
            movePageUp = new String("YES");
        }
        Page page = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            page = new Page(db, Integer.parseInt(pageId));
            page.move(db, DatabaseUtils.parseBoolean(movePageUp));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Pages.getReturn(context, "Move");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        String pageId;
        String pageGroupId;
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((pageGroupId = context.getRequest().getParameter("pageGroupId")) == null || "".equals(pageGroupId.trim())) {
            pageGroupId = (String)context.getRequest().getAttribute("pageGroupId");
        }
        if ((pageId = context.getRequest().getParameter("pageId")) == null || "".equals(pageId.trim())) {
            pageId = (String)context.getRequest().getAttribute("pageId");
        }
        Page page = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            page = new Page(db, Integer.parseInt(pageId));
            DependencyList dependencies = page.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("actionphase.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='Pages.do?command=Delete&pageGroupId=" + pageGroupId + "&pageId=" + page.getId() + "&siteId=" + siteId + "&popup=true'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Pages.getReturn(context, "ConfirmDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        String pageId;
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId != null && !"".equals(siteId)) {
            context.getRequest().setAttribute("siteId", (Object)siteId);
        }
        if ((pageId = context.getRequest().getParameter("pageId")) == null || "".equals(pageId)) {
            pageId = (String)context.getRequest().getAttribute("pageId");
        }
        Page page = null;
        int tabId = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            page = new Page();
            page.queryRecord(db, Integer.parseInt(pageId));
            page.buildPageVersionToView(db);
            tabId = page.getPageVersionToView().getTabIdByPageVersionId(db);
            page.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("Sites.do?command=Details&siteId=" + siteId + "&tabId=" + tabId + "&pageId=-1&popup=true"));
        return Pages.getReturn(context, "Delete");
    }

    public void insertDefaultData(ActionContext context, Connection db, Page page) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        int userId = this.getUserId(context);
        PageVersion pageVersion = new PageVersion();
        pageVersion.setPageId(page.getId());
        pageVersion.setVersionNumber(1);
        pageVersion.setModifiedBy(userId);
        pageVersion.insert(db);
        page.setConstructionPageVersionId(pageVersion.getId());
        page.setActivePageVersionId(pageVersion.getId());
        page.setOverride(true);
        page.update(db);
        PageRow pageRow = new PageRow();
        pageRow.setPageVersionId(page.getConstructionPageVersionId());
        pageRow.setPosition(0);
        pageRow.setEnabled(true);
        pageRow.setModifiedBy(userId);
        pageRow.insert(db);
        Icelet htmlIcelet = null;
        IceletList iceletList = new IceletList();
        iceletList.setConfiguratorClass("HtmlContentPortlet");
        iceletList.buildList(db);
        if (iceletList.size() > 0) {
            htmlIcelet = (Icelet)((Object)iceletList.get(0));
        }
        RowColumn rowColumn = new RowColumn();
        rowColumn.setPageRowId(pageRow.getId());
        rowColumn.setModifiedBy(userId);
        rowColumn.setEnabled(true);
        rowColumn.setWidth(100);
        rowColumn.setPosition(0);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            rowColumn.setIceletId(htmlIcelet.getId());
        }
        rowColumn.insert(db);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            IceletProperty property = new IceletProperty();
            property.setRowColumnId(rowColumn.getId());
            property.setValue("Please enter your html text here");
            property.setTypeConstant(HtmlContentPortlet.PROPERTY_HTMLTEXT);
            property.setModifiedBy(userId);
            property.insert(db);
        }
    }
}

