/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.iteam.base.Thumbnail;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.PortfolioCategory;
import org.aspcfs.modules.website.base.PortfolioCategoryHierarchy;
import org.aspcfs.modules.website.base.PortfolioCategoryList;
import org.aspcfs.modules.website.base.PortfolioItem;
import org.aspcfs.modules.website.base.PortfolioItemList;
import org.aspcfs.utils.ImageUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class PortfolioEditor
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-view")) {
            return "PermissionError";
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-view")) {
            return "PermissionError";
        }
        String categoryId = (String)context.getRequest().getAttribute("categoryId");
        if (categoryId == null || "".equals(categoryId.trim())) {
            categoryId = context.getRequest().getParameter("categoryId");
        }
        Connection db = null;
        PortfolioCategoryList categoryList = new PortfolioCategoryList();
        PortfolioItemList itemList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (!(categoryId == null || "".equals(categoryId.trim()) || "null".equals(categoryId.trim()) || "-1".equals(categoryId.trim()))) {
                categoryList.setParentId(categoryId);
            }
            categoryList.setBuildResources(true);
            categoryList.buildList(db);
            categoryList = categoryList.reorder();
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            if (categoryList.getParentId() > 0) {
                PortfolioCategory parentCategory = new PortfolioCategory(db, categoryList.getParentId());
                context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
                PortfolioEditor.buildHierarchy(db, context);
            }
            itemList = new PortfolioItemList();
            itemList.setCategoryId(categoryList.getParentId());
            itemList.buildList(db);
            itemList = itemList.reorder();
            context.getRequest().setAttribute("itemList", (Object)itemList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddCategory(ActionContext context) {
        String parentId;
        if (!this.hasPermission(context, "website-portfolio-add")) {
            return "PermissionError";
        }
        String from = context.getRequest().getParameter("return");
        if (from != null && !"".equals(from)) {
            context.getRequest().setAttribute("return", (Object)from);
        }
        if ((parentId = (String)context.getRequest().getAttribute("parentId")) == null || "".equals(parentId.trim())) {
            parentId = context.getRequest().getParameter("parentId");
        }
        String positionId = context.getRequest().getParameter("positionId");
        String doSubmit = context.getRequest().getParameter("dosubmit");
        Connection db = null;
        PortfolioCategory category = (PortfolioCategory)((Object)context.getFormBean());
        if (category.getPositionId() == -1 && positionId != null && !"".equals(positionId.trim())) {
            category.setPositionId(positionId);
        }
        if (doSubmit == null || "".equals(doSubmit.trim())) {
            category.setEnabled(true);
        }
        PortfolioCategory parentCategory = new PortfolioCategory();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (parentId != null && !"".equals(parentId.trim()) && !"null".equals(parentId.trim())) {
                category.setParentId(parentId);
                if (category.getParentId() != -1) {
                    context.getRequest().setAttribute("categoryId", (Object)String.valueOf(category.getParentId()));
                    PortfolioEditor.buildHierarchy(db, context);
                    parentCategory.queryRecord(db, category.getParentId());
                    context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
                }
            }
            context.getRequest().setAttribute("category", (Object)category);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddCategoryOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyCategory(ActionContext context) {
        String categoryId;
        if (!this.hasPermission(context, "website-portfolio-edit")) {
            return "PermissionError";
        }
        String from = context.getRequest().getParameter("return");
        if (from != null && !"".equals(from)) {
            context.getRequest().setAttribute("return", (Object)from);
        }
        if ((categoryId = context.getRequest().getParameter("categoryId")) == null || "".equals(categoryId.trim())) {
            categoryId = (String)context.getRequest().getAttribute("categoryId");
        }
        PortfolioCategory category = (PortfolioCategory)((Object)context.getFormBean());
        PortfolioCategory parentCategory = null;
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (category.getId() == -1) {
                category.queryRecord(db, Integer.parseInt(categoryId));
            }
            if (category.getParentId() != -1) {
                PortfolioEditor.buildHierarchy(db, context);
                parentCategory = new PortfolioCategory(db, category.getParentId());
                context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
            }
            context.getRequest().setAttribute("category", (Object)category);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyCategoryOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveCategory(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-edit")) {
            return "PermissionError";
        }
        String from = context.getRequest().getParameter("return");
        Connection db = null;
        boolean isValid = false;
        boolean recordInserted = false;
        int resultCount = -1;
        PortfolioCategory category = (PortfolioCategory)((Object)context.getFormBean());
        PortfolioCategory oldCategory = null;
        Object parentCategory = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (category.getId() > 0) {
                oldCategory = new PortfolioCategory(db, category.getId());
            }
            category.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)category);
            if (isValid) {
                if (category.getId() > -1) {
                    resultCount = category.update(db);
                    this.processUpdateHook(context, (Object)oldCategory, (Object)category);
                } else {
                    recordInserted = category.insert(db);
                    this.processInsertHook(context, (Object)category);
                }
            }
            if (recordInserted || resultCount > 0) {
                context.getRequest().setAttribute("categoryId", (Object)String.valueOf(category.getId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!isValid || resultCount < 1 && !recordInserted) {
            if (category.getId() > -1) {
                return this.executeCommandModifyCategory(context);
            }
            return this.executeCommandAddCategory(context);
        }
        if (from != null && "list".equals(from)) {
            context.getRequest().setAttribute("categoryId", (Object)String.valueOf(category.getParentId()));
            return this.executeCommandList(context);
        }
        return "SaveCategoryOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDeleteCategory(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-delete")) {
            return "PermissionError";
        }
        String categoryId = context.getRequest().getParameter("categoryId");
        if (categoryId == null || "".equals(categoryId)) {
            categoryId = (String)context.getRequest().getAttribute("categoryId");
        }
        Connection db = null;
        PortfolioCategory category = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            category = new PortfolioCategory();
            category.queryRecord(db, Integer.parseInt(categoryId));
            DependencyList dependencies = category.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("website.portfolio.category.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='PortfolioEditor.do?command=DeleteCategory&categoryId=" + category.getId() + "';");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteCategory(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-delete")) {
            return "PermissionError";
        }
        String categoryId = context.getRequest().getParameter("categoryId");
        if (categoryId != null && !"".equals(categoryId)) {
            context.getRequest().setAttribute("categoryId", (Object)categoryId);
        }
        PortfolioCategory category = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            category = new PortfolioCategory();
            category.queryRecord(db, Integer.parseInt(categoryId));
            category.delete(db, PortfolioEditor.getDbNamePath(context));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("PortfolioEditor.do?command=List&categoryId=" + category.getParentId()));
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddItem(ActionContext context) {
        String categoryId;
        if (!this.hasPermission(context, "website-portfolio-add")) {
            return "PermissionError";
        }
        String from = context.getRequest().getParameter("return");
        if (from != null && !"".equals(from)) {
            context.getRequest().setAttribute("return", (Object)from);
        }
        if ((categoryId = (String)context.getRequest().getAttribute("categoryId")) == null || "".equals(categoryId.trim())) {
            categoryId = context.getRequest().getParameter("categoryId");
        }
        String name = context.getRequest().getParameter("name");
        String description = context.getRequest().getParameter("description");
        String caption = context.getRequest().getParameter("caption");
        String enabled = context.getRequest().getParameter("enabled");
        String positionId = context.getRequest().getParameter("positionId");
        String doSubmit = context.getRequest().getParameter("dosubmit");
        Connection db = null;
        PortfolioCategory category = null;
        PortfolioItem item = new PortfolioItem();
        if (item.getCategoryId() == -1) {
            item.setCategoryId(categoryId);
        }
        if (doSubmit == null || "".equals(doSubmit.trim())) {
            item.setEnabled(true);
        }
        item.setName(name);
        item.setDescription(description);
        item.setPositionId(positionId);
        item.setCaption(caption);
        if (enabled != null && !"".equals(enabled.trim())) {
            item.setEnabled(enabled);
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (item.getCategoryId() != -1) {
                category = new PortfolioCategory(db, item.getCategoryId());
                context.getRequest().setAttribute("category", (Object)category);
            }
            PortfolioEditor.buildHierarchy(db, context);
            context.getRequest().setAttribute("item", (Object)item);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddItemOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyItem(ActionContext context) {
        String itemId;
        if (!this.hasPermission(context, "website-portfolio-edit")) {
            return "PermissionError";
        }
        String from = context.getRequest().getParameter("return");
        if (from != null && !"".equals(from)) {
            context.getRequest().setAttribute("return", (Object)from);
        }
        if ((itemId = (String)context.getRequest().getAttribute("itemId")) == null || "".equals(itemId.trim())) {
            itemId = context.getRequest().getParameter("itemId");
        }
        String name = context.getRequest().getParameter("name");
        String description = context.getRequest().getParameter("description");
        String categoryId = context.getRequest().getParameter("categoryId");
        String caption = context.getRequest().getParameter("caption");
        String enabled = context.getRequest().getParameter("enabled");
        String positionId = context.getRequest().getParameter("positionId");
        Connection db = null;
        PortfolioCategory category = null;
        PortfolioItem item = new PortfolioItem();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (item.getId() == -1) {
                item = new PortfolioItem();
                item.setBuildResources(true);
                item.queryRecord(db, Integer.parseInt(itemId));
            } else {
                item.setName(name);
                item.setDescription(description);
                item.setCaption(caption);
                item.setPositionId(positionId);
                if (enabled != null && !"".equals(enabled.trim())) {
                    item.setEnabled(enabled);
                } else {
                    item.setEnabled(false);
                }
                if (categoryId != null && !"".equals(categoryId)) {
                    item.setCategoryId(categoryId);
                }
            }
            if (item.getImageId() != -1) {
                FileItem thisFile = new FileItem(db, item.getImageId(), item.getId(), 223061228);
                context.getRequest().setAttribute("fileItem", (Object)thisFile);
            }
            context.getRequest().setAttribute("categoryId", (Object)String.valueOf(item.getCategoryId()));
            PortfolioEditor.buildHierarchy(db, context);
            if (item.getCategoryId() != -1) {
                category = new PortfolioCategory(db, item.getCategoryId());
                context.getRequest().setAttribute("category", (Object)category);
            }
            context.getRequest().setAttribute("item", (Object)item);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyItemOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeCommandSaveItem(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-edit")) {
            return "PermissionError";
        }
        String from = context.getRequest().getParameter("return");
        boolean isValid = false;
        boolean recordInserted = false;
        boolean fileInserted = false;
        int resultCount = -1;
        Object category = null;
        PortfolioItem item = new PortfolioItem();
        Object oldItem = null;
        FileItem thisFileItem = null;
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            String filePath = this.getPath(context, "portfolioitem");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String itemId = (String)parts.get("id");
            item.setId(itemId);
            db = this.getConnection(context);
            if (item.getId() > 0) {
                item.setBuildResources(true);
                item.queryRecord(db, item.getId());
            }
            String fileText = (String)parts.get("fileText");
            String name = (String)parts.get("name");
            String description = (String)parts.get("description");
            String caption = (String)parts.get("caption");
            String enabled = (String)parts.get("enabled");
            String categoryId = (String)parts.get("categoryId");
            String positionId = (String)parts.get("positionId");
            String imageId = (String)parts.get("imageId");
            String versionId = (String)parts.get("versionId");
            if (from == null || "".equals(from.trim())) {
                from = (String)parts.get("return");
            }
            item.setModifiedBy(this.getUserId(context));
            item.setName(name);
            item.setDescription(description);
            item.setCaption(caption);
            item.setPositionId(positionId);
            if (enabled != null && !"".equals(enabled.trim())) {
                item.setEnabled(enabled);
            } else {
                item.setEnabled(false);
            }
            if (categoryId != null && !"".equals(categoryId)) {
                item.setCategoryId(categoryId);
            }
            if (imageId != null || !"".equals(imageId.trim())) {
                item.setImageId(imageId);
            }
            isValid = this.validateObject(context, db, (Object)item);
            if (!(parts.get("imageId1") instanceof FileInfo) && fileText != null && !"".equals(fileText.trim())) {
                isValid = false;
            }
            if (isValid) {
                if (item.getId() == -1) {
                    recordInserted = item.insert(db);
                } else {
                    resultCount = item.update(db);
                }
                if (parts.get("imageId1") instanceof FileInfo) {
                    FileInfo newFileInfo = (FileInfo)parts.get("imageId1");
                    thisFileItem = new FileItem();
                    thisFileItem.setLinkModuleId(223061228);
                    thisFileItem.setLinkItemId(item.getId());
                    thisFileItem.setEnteredBy(this.getUserId(context));
                    thisFileItem.setModifiedBy(this.getUserId(context));
                    thisFileItem.setFolderId(-1);
                    thisFileItem.setId(item.getImageId());
                    thisFileItem.setSubject(caption != null && !"".equals(caption.trim()) ? caption : name);
                    thisFileItem.setClientFilename(newFileInfo.getClientFileName());
                    thisFileItem.setFilename(newFileInfo.getRealFilename());
                    thisFileItem.setVersion(Double.parseDouble(versionId));
                    thisFileItem.setSize(newFileInfo.getSize());
                    isValid = this.validateObject(context, db, thisFileItem);
                    if (isValid && (recordInserted || resultCount > -1)) {
                        if (thisFileItem.getId() != -1) {
                            recordInserted = thisFileItem.insertVersion(db);
                        } else {
                            fileInserted = thisFileItem.insert(db);
                        }
                        thisFileItem.setDirectory(filePath);
                        if (thisFileItem.isImageFormat()) {
                            File thumbnailFile = new File(newFileInfo.getLocalFile().getPath() + "TH");
                            ImageUtils.saveThumbnail(newFileInfo.getLocalFile(), thumbnailFile, 133.0, 133.0);
                            Thumbnail thumbnail = new Thumbnail();
                            thumbnail.setId(thisFileItem.getId());
                            thumbnail.setFilename(newFileInfo.getRealFilename() + "TH");
                            thumbnail.setVersion(thisFileItem.getVersion());
                            thumbnail.setSize((int)thumbnailFile.length());
                            thumbnail.setEnteredBy(thisFileItem.getEnteredBy());
                            thumbnail.setModifiedBy(thisFileItem.getModifiedBy());
                            thumbnail.insert(db);
                        }
                        if (fileInserted) {
                            item = new PortfolioItem(db, item.getId());
                            item.setImageId(thisFileItem.getId());
                            resultCount = item.update(db);
                        }
                    }
                }
            }
            HashMap<String, String> errors = new HashMap<String, String>();
            if (parts.get("imageId1") instanceof FileInfo) {
                if (!fileInserted) {
                    errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                    this.processErrors(context, errors);
                }
            } else if (fileText != null && !"".equals(fileText.trim())) {
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("itemId", (Object)String.valueOf(item.getId()));
            if (!isValid || !recordInserted && resultCount == -1) {
                String string;
                context.getRequest().setAttribute("item", (Object)item);
                if (item.getId() == -1) {
                    context.getRequest().setAttribute("categoryId", (Object)String.valueOf(item.getCategoryId()));
                    if (item.getName() != null) {
                        context.getRequest().setAttribute("name", (Object)item.getName());
                    }
                    if (item.getDescription() != null) {
                        context.getRequest().setAttribute("description", (Object)item.getDescription());
                    }
                    if (item.getCaption() != null) {
                        context.getRequest().setAttribute("caption", (Object)item.getCaption());
                    }
                    if (item.getEnabled()) {
                        context.getRequest().setAttribute("enabled", (Object)"true");
                    }
                    string = this.executeCommandAddItem(context);
                    this.freeConnection(context, db);
                    return string;
                }
                string = this.executeCommandModifyItem(context);
                this.freeConnection(context, db);
                return string;
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        if (from == null) return "SaveItemOK";
        if (!"list".equals(from)) return "SaveItemOK";
        context.getRequest().setAttribute("categoryId", (Object)String.valueOf(item.getCategoryId()));
        return "SaveItemAndListOK";
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandItemDetails(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-view")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("itemId");
        if (itemId == null || "".equals(itemId)) {
            itemId = (String)context.getRequest().getAttribute("itemId");
        }
        PortfolioItem item = new PortfolioItem();
        Connection db = null;
        try {
            db = this.getConnection(context);
            item.setBuildResources(true);
            item.queryRecord(db, Integer.parseInt(itemId));
            if (item.getCategoryId() != -1) {
                PortfolioCategory category = new PortfolioCategory(db, item.getCategoryId());
                context.getRequest().setAttribute("categoryId", (Object)String.valueOf(item.getCategoryId()));
                context.getRequest().setAttribute("category", (Object)category);
            }
            PortfolioEditor.buildHierarchy(db, context);
            context.getRequest().setAttribute("item", (Object)item);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ItemDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        block25: {
            Object errorMessage = null;
            String imageId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            String categoryId = context.getRequest().getParameter("categoryId");
            String itemId = context.getRequest().getParameter("itemId");
            String view = context.getRequest().getParameter("view");
            FileItem thisImage = null;
            Connection db = null;
            PortfolioItem item = null;
            try {
                db = this.getConnection(context);
                item = new PortfolioItem(db, Integer.parseInt(itemId));
                thisImage = new FileItem(db, Integer.parseInt(imageId), Integer.parseInt(itemId), 223061228);
                if (version != null) {
                    thisImage.buildVersionList(db);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisImage;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "portfolioitem") + PortfolioEditor.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if (view != null && "true".equals(view)) {
                            fileDownload.setFileTimestamp(thisImage.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("PortfolioItemEditor -> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                        String string = this.executeCommandItemDetails(context);
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block25;
                }
                FileItemVersion itemToDownload = thisImage.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "portfolioitem") + PortfolioEditor.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block25;
                }
                db = null;
                System.err.println("PortfolioItemEditor -> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                String string = this.executeCommandItemDetails(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    se.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDeleteItem(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-delete")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("itemId");
        if (itemId == null || "".equals(itemId)) {
            itemId = (String)context.getRequest().getAttribute("itemId");
        }
        Connection db = null;
        PortfolioItem item = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            item = new PortfolioItem(db, Integer.parseInt(itemId));
            DependencyList dependencies = item.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("website.portfolio.item.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='PortfolioItemEditor.do?command=DeleteItem&categoryId=" + item.getCategoryId() + "&itemId=" + item.getId() + "';");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteItem(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-delete")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("itemId");
        if (itemId != null && !"".equals(itemId)) {
            context.getRequest().setAttribute("itemId", (Object)itemId);
        }
        PortfolioItem item = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            item = new PortfolioItem(db, Integer.parseInt(itemId));
            item.delete(db, PortfolioEditor.getDbNamePath(context));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("PortfolioEditor.do?command=List&categoryId=" + item.getCategoryId()));
        return "DeleteOK";
    }

    public static final void buildHierarchy(Connection db, ActionContext context) throws SQLException {
        String categoryId = (String)context.getRequest().getAttribute("categoryId");
        if (categoryId == null || "".equals(categoryId.trim())) {
            categoryId = context.getRequest().getParameter("categoryId");
        }
        if (categoryId != null && !"-1".equals(categoryId) && !"0".equals(categoryId)) {
            LinkedHashMap categoryLevels = new LinkedHashMap();
            PortfolioCategory.buildHierarchy(db, categoryLevels, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("categoryLevels", categoryLevels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReorder(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-view")) {
            return "PermissionError";
        }
        String categoryId = (String)context.getRequest().getAttribute("categoryId");
        if (categoryId == null || "".equals(categoryId.trim())) {
            categoryId = context.getRequest().getParameter("categoryId");
        }
        Connection db = null;
        PortfolioCategoryList categoryList = new PortfolioCategoryList();
        PortfolioItemList itemList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (!(categoryId == null || "".equals(categoryId.trim()) || "null".equals(categoryId.trim()) || "-1".equals(categoryId.trim()))) {
                categoryList.setParentId(categoryId);
            }
            categoryList.setBuildResources(true);
            categoryList.buildList(db);
            categoryList.reset(context, db);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            if (categoryList.getParentId() > 0) {
                PortfolioCategory parentCategory = new PortfolioCategory(db, categoryList.getParentId());
                context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
            }
            PortfolioEditor.buildHierarchy(db, context);
            itemList = new PortfolioItemList();
            itemList.setCategoryId(categoryList.getParentId());
            itemList.buildList(db);
            itemList.reset(context, db);
            context.getRequest().setAttribute("itemList", (Object)itemList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ReorderOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-edit")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("itemId");
        if (itemId != null && !"".equals(itemId)) {
            context.getRequest().setAttribute("itemId", (Object)itemId);
        }
        Connection db = null;
        PortfolioItem item = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            item = new PortfolioItem(db, Integer.parseInt(itemId));
            PortfolioCategoryHierarchy hierarchy = new PortfolioCategoryHierarchy();
            hierarchy.build(db);
            context.getRequest().setAttribute("categoryHierarchy", (Object)hierarchy);
            context.getRequest().setAttribute("item", (Object)item);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "MoveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateMove(ActionContext context) {
        String itemId;
        if (!this.hasPermission(context, "website-portfolio-edit")) {
            return "PermissionError";
        }
        String categoryId = (String)context.getRequest().getAttribute("categoryId");
        if (categoryId == null || "".equals(categoryId.trim())) {
            categoryId = context.getRequest().getParameter("categoryId");
        }
        if ((itemId = context.getRequest().getParameter("itemId")) != null && !"".equals(itemId)) {
            context.getRequest().setAttribute("itemId", (Object)itemId);
        }
        Connection db = null;
        PortfolioItem item = null;
        Object category = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            item = new PortfolioItem(db, Integer.parseInt(itemId));
            if (categoryId != null && !"".equals(categoryId)) {
                item.setCategoryId(categoryId);
            }
            item.updateCategory(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "UpdateMoveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPopupSingleSelector(ActionContext context) {
        Connection db = null;
        PortfolioCategoryList categoryList = null;
        String categoryId = (String)context.getRequest().getAttribute("categoryId");
        if (categoryId == null || "".equals(categoryId.trim())) {
            categoryId = context.getRequest().getParameter("categoryId");
        }
        try {
            db = this.getConnection(context);
            String displayFieldId = context.getRequest().getParameter("displayFieldId");
            String hiddenFieldId = context.getRequest().getParameter("hiddenFieldId");
            PagedListInfo categoryPagedInfo = this.getPagedListInfo(context, "portfolioCategoryInfo");
            categoryPagedInfo.setLink("PortfolioEditor.do?command=PopupSingleSelector&hiddenFieldId=" + hiddenFieldId + "&displayFieldId=" + displayFieldId);
            PortfolioEditor.buildHierarchy(db, context);
            categoryList = new PortfolioCategoryList();
            categoryList.setPagedListInfo(categoryPagedInfo);
            if (!(categoryId == null || "".equals(categoryId.trim()) || "null".equals(categoryId.trim()) || "-1".equals(categoryId.trim()))) {
                categoryList.setParentId(categoryId);
            }
            categoryList.setEnabledOnly(1);
            categoryList.setBuildResources(true);
            categoryList.buildList(db);
            categoryList = categoryList.reorder();
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            if (categoryList.getParentId() > 0) {
                PortfolioCategory parentCategory = new PortfolioCategory(db, categoryList.getParentId());
                context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
                PortfolioEditor.buildHierarchy(db, context);
            }
            context.getRequest().setAttribute("displayFieldId", (Object)displayFieldId);
            context.getRequest().setAttribute("hiddenFieldId", (Object)hiddenFieldId);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListSingleOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandXXX(ActionContext context) {
        if (!this.hasPermission(context, "website-portfolio-view")) {
            return "PermissionError";
        }
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "XXXOK";
    }
}

