/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.RowColumnList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;

public final class RowColumns
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return RowColumns.getReturn(context, "Default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String rowColumnId = context.getRequest().getParameter("rowColumnId");
        String moveRowColumnLeft = context.getRequest().getParameter("moveRowColumnLeft");
        if (moveRowColumnLeft == null || "".equals(moveRowColumnLeft.trim())) {
            moveRowColumnLeft = new String("YES");
        }
        RowColumn rowColumn = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            rowColumn = new RowColumn(db, Integer.parseInt(rowColumnId));
            rowColumn.move(db, DatabaseUtils.parseBoolean(moveRowColumnLeft));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return RowColumns.getReturn(context, "Move");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddSubRow(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String rowColumnId = context.getRequest().getParameter("rowColumnId");
        RowColumn rowColumn = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            rowColumn = new RowColumn();
            rowColumn.setBuildSubRows(true);
            rowColumn.queryRecord(db, Integer.parseInt(rowColumnId));
            rowColumn.addSubRow(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return RowColumns.getReturn(context, "Move");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        String rowColumnId;
        String pageVersionId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((pageVersionId = context.getRequest().getParameter("pageVersionId")) == null || "".equals(pageVersionId.trim())) {
            pageVersionId = (String)context.getRequest().getAttribute("pageVersionId");
        }
        if ((rowColumnId = context.getRequest().getParameter("rowColumnId")) == null || "".equals(rowColumnId.trim())) {
            rowColumnId = (String)context.getRequest().getAttribute("rowColumnId");
        }
        RowColumn rowColumn = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            rowColumn = new RowColumn(db, Integer.parseInt(rowColumnId));
            DependencyList dependencies = rowColumn.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("actionphase.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='RowColumns.do?command=Delete&pageVersionId=" + pageVersionId + "&rowColumnId=" + rowColumn.getId() + "&siteId=" + siteId + "&popup=true'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return RowColumns.getReturn(context, "ConfirmDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        String rowColumnId;
        String pageVersionId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((pageVersionId = context.getRequest().getParameter("pageVersionId")) != null && !"".equals(pageVersionId)) {
            context.getRequest().setAttribute("pageVersionId", (Object)pageVersionId);
        }
        if ((rowColumnId = context.getRequest().getParameter("rowColumnId")) == null || "".equals(rowColumnId)) {
            rowColumnId = (String)context.getRequest().getAttribute("rowColumnId");
        }
        PageVersion pageVersion = null;
        RowColumn rowColumn = null;
        int tabId = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (pageVersionId != null && !"".equals(pageVersionId.trim()) && !"-1".equals(pageVersionId.trim())) {
                pageVersion = new PageVersion(db, Integer.parseInt(pageVersionId));
                tabId = pageVersion.getTabIdByPageVersionId(db);
            }
            rowColumn = new RowColumn();
            rowColumn.queryRecord(db, Integer.parseInt(rowColumnId));
            rowColumn.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("Sites.do?command=Details&siteId=" + siteId + "&tabId=" + tabId + "&pageId=" + (pageVersion != null ? pageVersion.getPageId() : -1) + "&popup=true"));
        return RowColumns.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddIcelet(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageRowId = context.getRequest().getParameter("pageRowId");
        if (pageRowId == null || "".equals(pageRowId.trim())) {
            pageRowId = (String)context.getRequest().getAttribute("pageRowId");
        }
        RowColumn rowColumn = (RowColumn)((Object)context.getFormBean());
        String nextRowColumnId = context.getRequest().getParameter("nextRowColumnId");
        if (nextRowColumnId == null || "".equals(nextRowColumnId.trim())) {
            nextRowColumnId = (String)context.getRequest().getAttribute("nextRowColumnId");
        }
        if (nextRowColumnId != null && !"".equals(nextRowColumnId)) {
            rowColumn.setNextRowColumnId(nextRowColumnId);
            context.getRequest().setAttribute("nextRowColumnId", (Object)nextRowColumnId);
        }
        String buildLastColumn = context.getRequest().getParameter("buildLastColumn");
        PageRow pageRow = null;
        IceletList iceletList = new IceletList();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageRow = new PageRow();
            pageRow.setBuildRowColumnList(true);
            pageRow.queryRecord(db, Integer.parseInt(pageRowId));
            context.getRequest().setAttribute("pageRow", (Object)pageRow);
            if (buildLastColumn != null && DatabaseUtils.parseBoolean(buildLastColumn)) {
                RowColumnList columnList = new RowColumnList();
                columnList.setPageRowId(pageRowId);
                columnList.setBuildLastPosition(true);
                columnList.buildList(db);
                rowColumn.setPreviousRowColumnId(columnList.getLastPositionColumnId());
                context.getRequest().setAttribute("previousRowColumnId", (Object)String.valueOf(columnList.getLastPositionColumnId()));
            } else {
                String previousRowColumnId = context.getRequest().getParameter("previousRowColumnId");
                if (previousRowColumnId == null || "".equals(previousRowColumnId.trim())) {
                    previousRowColumnId = (String)context.getRequest().getAttribute("previousRowColumnId");
                }
                if (previousRowColumnId != null && !"".equals(previousRowColumnId)) {
                    rowColumn.setPreviousRowColumnId(previousRowColumnId);
                    context.getRequest().setAttribute("previousRowColumnId", (Object)String.valueOf(previousRowColumnId));
                }
            }
            iceletList.buildList(db);
            iceletList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("icelets", (Object)iceletList);
            rowColumn.setEnabled(true);
            rowColumn.setWidth(50);
            context.getRequest().setAttribute("rowColumn", (Object)rowColumn);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return RowColumns.getReturn(context, "AddIcelet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReplaceIcelet(ActionContext context) {
        String rowColumnId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageRowId = context.getRequest().getParameter("pageRowId");
        if (pageRowId == null || "".equals(pageRowId.trim())) {
            pageRowId = (String)context.getRequest().getAttribute("pageRowId");
        }
        if ((rowColumnId = context.getRequest().getParameter("rowColumnId")) == null || "".equals(rowColumnId.trim())) {
            rowColumnId = (String)context.getRequest().getAttribute("rowColumnId");
        }
        RowColumn rowColumn = (RowColumn)((Object)context.getFormBean());
        String iceletId = context.getRequest().getParameter("iceletId");
        String width = context.getRequest().getParameter("width");
        PageRow pageRow = null;
        IceletList iceletList = new IceletList();
        Icelet icelet = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            pageRow = new PageRow();
            pageRow.setBuildRowColumnList(true);
            pageRow.setBuildIcelet(false);
            pageRow.setBuildIceletPropertyMap(false);
            pageRow.queryRecord(db, Integer.parseInt(pageRowId));
            context.getRequest().setAttribute("pageRow", (Object)pageRow);
            if (rowColumn.getId() == -1) {
                rowColumn.queryRecord(db, Integer.parseInt(rowColumnId));
                if (rowColumn.getIceletId() != -1) {
                    rowColumn.buildIcelet(db);
                    rowColumn.setDefaultPropertyMap(this.getIcletPrefs(context, rowColumn.getIcelet().getConfiguratorClass()));
                    rowColumn.buildIceletPropertyMap(db);
                }
            }
            rowColumn.setModifiedBy(this.getUserId(context));
            if (width != null && !"".equals(width.trim())) {
                rowColumn.setWidth(width);
            }
            if (iceletId != null && !"".equals(iceletId.trim()) && rowColumn.getIceletId() != Integer.parseInt(iceletId)) {
                rowColumn.setIceletId(iceletId);
                rowColumn.setIcelet(null);
                rowColumn.setIceletPropertyMap(null);
            }
            iceletList.buildList(db);
            iceletList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            if (rowColumn.getIceletId() > -1) {
                icelet = iceletList.getIceletById(rowColumn.getIceletId());
                context.getRequest().setAttribute("icelet", (Object)icelet);
            }
            context.getRequest().setAttribute("icelets", (Object)iceletList);
            context.getRequest().setAttribute("rowColumn", (Object)rowColumn);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return RowColumns.getReturn(context, "ReplaceIcelet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyIceletProperties(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String rowColumnId = context.getRequest().getParameter("rowColumnId");
        if (rowColumnId == null || "".equals(rowColumnId.trim())) {
            rowColumnId = (String)context.getRequest().getAttribute("rowColumnId");
        }
        String iceletId = context.getRequest().getParameter("iceletId");
        String width = context.getRequest().getParameter("width");
        RowColumn rowColumn = (RowColumn)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        HashMap propertyMap = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (rowColumnId != null && !"".equals(rowColumnId.trim()) && !"-1".equals(rowColumnId.trim()) && rowColumn.getId() == -1) {
                rowColumn.setBuildIcelet(false);
                rowColumn.setBuildIceletPropertyMap(false);
                rowColumn.queryRecord(db, Integer.parseInt(rowColumnId.trim()));
                if (rowColumn.getIceletId() != -1) {
                    rowColumn.buildIcelet(db);
                    rowColumn.setBuildIceletPropertyMap(true);
                    rowColumn.setDefaultPropertyMap(this.getIcletPrefs(context, rowColumn.getIcelet().getConfiguratorClass()));
                    rowColumn.buildIceletPropertyMap(db);
                }
            }
            if (iceletId != null && !"".equals(iceletId.trim())) {
                rowColumn.setIceletId(iceletId);
            }
            if (width != null && !"".equals(width.trim())) {
                rowColumn.setWidth(width);
            }
            context.getRequest().setAttribute("rowColumn", (Object)rowColumn);
            if (rowColumn.getIceletId() > -1) {
                Icelet icelet = new Icelet(db, Integer.parseInt(iceletId));
                propertyMap = this.getIcletPrefs(context, icelet.getConfiguratorClass());
                context.getRequest().setAttribute("icelet", (Object)icelet);
                context.getRequest().setAttribute("propertyMap", (Object)propertyMap);
                LookupList leadSourceSelect = systemStatus.getLookupList(db, "lookup_contact_source");
                leadSourceSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
                context.getRequest().setAttribute("leadSourceSelect", (Object)leadSourceSelect);
                RoleList roleList = new RoleList();
                roleList.setExcludeRoleType(0);
                roleList.setEnabledState(1);
                roleList.buildList(db);
                roleList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
                context.getRequest().setAttribute("rolelistSelect", (Object)roleList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (propertyMap == null || propertyMap.size() == 0) {
            return this.executeCommandSaveIcelet(context);
        }
        return RowColumns.getReturn(context, "ModifyIceletProperties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveIcelet(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String pageRowId = context.getRequest().getParameter("pageRowId");
        if (pageRowId == null || "".equals(pageRowId.trim())) {
            pageRowId = (String)context.getRequest().getAttribute("pageRowId");
        }
        String previousRowColumnId = context.getRequest().getParameter("previousRowColumnId");
        String nextRowColumnId = context.getRequest().getParameter("nextRowColumnId");
        String rowColumnId = context.getRequest().getParameter("rowColumnId");
        if (rowColumnId == null || "".equals(rowColumnId.trim())) {
            rowColumnId = (String)context.getRequest().getAttribute("rowColumnId");
        }
        String iceletId = context.getRequest().getParameter("iceletId");
        String width = context.getRequest().getParameter("width");
        RowColumn rowColumn = (RowColumn)((Object)context.getFormBean());
        if (iceletId != null && !"".equals(iceletId.trim())) {
            rowColumn.setIceletId(iceletId);
        }
        if (width != null && !"".equals(width.trim())) {
            rowColumn.setWidth(width);
        }
        RowColumn oldSelection = new RowColumn();
        boolean recordInserted = false;
        int recordCount = -1;
        boolean isValid = false;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (rowColumn.getId() != -1) {
                oldSelection.setBuildIcelet(true);
                oldSelection.setBuildIceletPropertyMap(true);
                oldSelection.queryRecord(db, Integer.parseInt(rowColumnId));
            }
            rowColumn.setModifiedBy(this.getUserId(context));
            rowColumn.setEnabled(true);
            if (rowColumn.getIceletPropertyMap() == null) {
                rowColumn.setIceletPropertyMap(new IceletPropertyMap());
            }
            rowColumn.getIceletPropertyMap().setModifiedBy(rowColumn.getModifiedBy());
            if (rowColumn.getId() > -1) {
                rowColumn.getIceletPropertyMap().setIceletRowColumnId(rowColumn.getId());
                rowColumn.getIceletPropertyMap().setRequestItems(context);
                if (oldSelection.getIceletId() > -1) {
                    rowColumn.parsePropertyMapEntries(db, oldSelection);
                    rowColumn.update(db);
                    rowColumn.queryRecord(db, rowColumn.getId());
                }
                rowColumn.getIceletPropertyMap().insert(db);
                rowColumn.setOverride(true);
                rowColumn.update(db);
                rowColumn.queryRecord(db, rowColumn.getId());
            }
            rowColumn.setPosition(rowColumn.computeRowColumnPosition(db));
            recordInserted = rowColumn.insert(db);
            rowColumn.queryRecord(db, rowColumn.getId());
            rowColumn.getIceletPropertyMap().setRequestItems(context);
            rowColumn.getIceletPropertyMap().addAdditionalInformation(rowColumn.getId(), rowColumn.getModifiedBy());
            rowColumn.getIceletPropertyMap().insert(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return RowColumns.getReturn(context, "SaveIcelet");
    }
}

