/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.webutils.FileDownload;
import java.sql.Connection;
import java.util.ArrayList;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Layout;
import org.aspcfs.modules.website.base.LayoutList;
import org.aspcfs.modules.website.base.PageList;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.modules.website.base.SiteList;
import org.aspcfs.modules.website.base.Style;
import org.aspcfs.modules.website.base.StyleList;
import org.aspcfs.modules.website.base.TabList;
import org.aspcfs.modules.website.base.Template;
import org.aspcfs.modules.website.base.TemplateList;
import org.aspcfs.modules.website.framework.IceletManager;
import org.aspcfs.modules.website.utils.SiteImporter;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class Sites
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        String string;
        if (!this.hasPermission(context, "site-editor-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ArrayList rowColumnList = new ArrayList();
        try {
            int siteId = Integer.parseInt(context.getRequest().getParameter("siteId"));
            int tabId = -1;
            String tabValue = context.getRequest().getParameter("tabId");
            int pageId = -1;
            String pageValue = context.getRequest().getParameter("pageId");
            db = this.getConnection(context);
            Site site = new Site(db, siteId);
            tabId = StringUtils.hasText(tabValue) ? Integer.parseInt(tabValue) : TabList.queryDefault(db, site.getId(), Site.EDIT_MODE);
            pageId = StringUtils.hasText(pageValue) ? Integer.parseInt(pageValue) : PageList.queryDefault(db, tabId, Site.EDIT_MODE);
            context.getRequest().setAttribute("tabId", (Object)String.valueOf(tabId));
            context.getRequest().setAttribute("pageId", (Object)String.valueOf(pageId));
            site.buildResources(db, tabId, pageId, Site.EDIT_MODE);
            site.buildRowsColumns(rowColumnList);
            context.getRequest().setAttribute("rowsColumns", rowColumnList);
            context.getRequest().setAttribute("site", (Object)site);
            IceletManager manager = IceletManager.getManager(context);
            boolean actionMode = manager.prepare(context, site, tabId, pageId, db);
            if (actionMode) {
                String string2 = "-none-";
                this.freeConnection(context, db);
                return string2;
            }
            string = "SiteOK";
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string3 = "SystemError";
            return string3;
        }
        finally {
            this.freeConnection(context, db);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-view")) {
            return "PermissionError";
        }
        SiteList sites = new SiteList();
        Connection db = null;
        PagedListInfo siteListInfo = this.getPagedListInfo(context, "siteListInfo");
        siteListInfo.setLink("Sites.do?command=List&popup=true");
        try {
            db = this.getConnection(context);
            sites.setPagedListInfo(siteListInfo);
            siteListInfo.setSearchCriteria(sites, context);
            sites.buildList(db);
            context.getRequest().setAttribute("sites", (Object)sites);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (sites.size() == 0) {
            return Sites.getReturn(context, "GotoTemplateList");
        }
        return Sites.getReturn(context, "List");
    }

    public String executeCommandTemplateList(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-add")) {
            return "PermissionError";
        }
        String fromList = context.getRequest().getParameter("fromList");
        if (fromList != null && "true".equals(fromList.trim())) {
            context.getRequest().setAttribute("fromList", (Object)fromList);
        }
        try {
            TemplateList templateList = new TemplateList();
            templateList.buildList(this.getWebInfPath(context, "portal_templates"), this.getSystemStatus(context).getLanguage());
            context.getRequest().setAttribute("templateList", (Object)templateList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return Sites.getReturn(context, "TemplateList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-add")) {
            return "PermissionError";
        }
        String fromList = context.getRequest().getParameter("fromList");
        if (fromList != null && "true".equals(fromList.trim())) {
            context.getRequest().setAttribute("fromList", (Object)fromList);
        }
        Site site = (Site)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            context.getRequest().setAttribute("site", (Object)site);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Sites.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        Site site = (Site)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (site.getId() == -1) {
                site = new Site(db, Integer.parseInt(siteId));
            }
            context.getRequest().setAttribute("site", (Object)site);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Sites.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Site site = (Site)((Object)context.getFormBean());
        int recordCount = -1;
        boolean isValid = false;
        boolean recordInserted = false;
        try {
            db = this.getConnection(context);
            site.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)site);
            if (isValid) {
                if (site.getId() > -1) {
                    recordCount = site.update(db);
                } else {
                    String templateFile = context.getRequest().getParameter("template");
                    TemplateList templateList = new TemplateList();
                    templateList.setTemplate(templateFile);
                    templateList.buildList(this.getWebInfPath(context, "portal_templates"), this.getSystemStatus(context).getLanguage());
                    if (templateList.size() == 1) {
                        Template thisTemplate = (Template)((Object)templateList.get(0));
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("Sites-> Importing template: " + templateFile);
                        }
                        String zipFile = templateList.getZipPath() + System.getProperty("file.separator") + thisTemplate.getFilename() + ".zip";
                        SiteImporter importer = new SiteImporter(zipFile, null, db, this.getUserId(context));
                        Site newSite = importer.getSite();
                        newSite.setName(site.getName());
                        newSite.setEnabled(site.getEnabled());
                        newSite.setInternalDescription(site.getInternalDescription());
                        newSite.setNotes(site.getNotes());
                        newSite.update(db);
                        context.getRequest().setAttribute("site", (Object)newSite);
                        recordInserted = newSite.getId() > 0;
                        site.setId(newSite.getId());
                    } else if (System.getProperty("DEBUG") != null) {
                        System.out.println("Sites-> None found..." + templateFile);
                    }
                }
            }
            if (isValid && (recordInserted || recordCount != -1)) {
                context.getRequest().setAttribute("siteId", (Object)String.valueOf(site.getId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!isValid && !recordInserted && recordCount == -1) {
            if (site.getId() > -1) {
                return this.executeCommandModify(context);
            }
            return this.executeCommandAdd(context);
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandActivate(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Site site = null;
        String siteId = context.getRequest().getParameter("siteId");
        String flag = context.getRequest().getParameter("enable");
        int recordCount = -1;
        try {
            db = this.getConnection(context);
            site = new Site(db, Integer.parseInt(siteId));
            if (flag != null && !"".equals(flag.trim())) {
                site.setEnabled(flag);
                if (site.getEnabled()) {
                    SiteList.disableOtherSites(db);
                }
                recordCount = site.update(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateLogo(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        String logoImageId = context.getRequest().getParameter("logoImageId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Site site = new Site(db, Integer.parseInt(siteId));
            site.updateLogoImageId(db, Integer.parseInt(logoImageId));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        int tabId = -1;
        String tabValue = context.getRequest().getParameter("tabId");
        int pageId = -1;
        String pageValue = context.getRequest().getParameter("pageId");
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        ArrayList rowColumnList = null;
        Site site = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (systemStatus != null) {
            context.getRequest().setAttribute("url", (Object)systemStatus.getUrl());
        } else {
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            context.getRequest().setAttribute("url", (Object)prefs.get("WEBSERVER.URL"));
        }
        Connection db = null;
        try {
            Style style;
            Layout layout;
            db = this.getConnection(context);
            site = new Site(db, Integer.parseInt(siteId));
            site.setBuildTabList(true);
            site.buildTabList(db);
            if (site.getTabList().size() == 0) {
                String string = Sites.getReturn(context, "GotoSiteList");
                return string;
            }
            tabId = StringUtils.hasText(tabValue) && !"-1".equals(tabValue) ? Integer.parseInt(tabValue) : TabList.queryDefault(db, site.getId(), Site.EDIT_MODE);
            pageId = StringUtils.hasText(pageValue) && !"-1".equals(pageValue) ? Integer.parseInt(pageValue) : PageList.queryDefault(db, tabId, Site.EDIT_MODE);
            context.getRequest().setAttribute("tabId", (Object)String.valueOf(tabId));
            context.getRequest().setAttribute("pageId", (Object)String.valueOf(pageId));
            site.buildResources(db, tabId, pageId, Site.EDIT_MODE);
            rowColumnList = new ArrayList();
            site.buildRowsColumns(rowColumnList);
            context.getRequest().setAttribute("rowsColumns", rowColumnList);
            IceletManager manager = IceletManager.getManager(context);
            manager.prepare(context, site, tabId, pageId, db);
            context.getRequest().setAttribute("site", (Object)site);
            if (site.getLayoutId() > -1) {
                layout = new Layout(db, site.getLayoutId());
                context.getRequest().setAttribute("layout", (Object)layout);
            } else {
                layout = new Layout();
                layout.setJsp("layout_2006051814_top_right.jsp");
                context.getRequest().setAttribute("layout", (Object)layout);
            }
            if (site.getStyleId() > -1) {
                style = new Style(db, site.getStyleId());
                context.getRequest().setAttribute("style", (Object)style);
            } else {
                style = new Style();
                style.setCss("style_2006051811_blue.css");
                context.getRequest().setAttribute("style", (Object)style);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Sites.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        String siteId = context.getRequest().getParameter("siteId");
        try {
            db = this.getConnection(context);
            Site site = new Site(db, Integer.parseInt(siteId));
            DependencyList dependencies = site.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (!dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.deleteRelatedOrdersFirst"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title", "Title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.dependencies", "Delete this Site"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='Sites.do?command=Delete&siteId=" + site.getId() + "&popup=true'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Sites.getReturn(context, "ConfirmDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Site site = new Site(db, Integer.parseInt(siteId));
            site.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)"Sites.do?command=List&popup=true");
        return Sites.getReturn(context, "Delete");
    }

    public String executeCommandTemplateThumbnail(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-view")) {
            return "PermissionError";
        }
        String template = context.getRequest().getParameter("template");
        try {
            TemplateList templateList = new TemplateList();
            templateList.setTemplate(template);
            templateList.buildList(this.getWebInfPath(context, "portal_templates"), this.getSystemStatus(context).getLanguage());
            if (templateList.size() == 1) {
                Template thisTemplate = (Template)((Object)templateList.get(0));
                FileDownload fileDownload = new FileDownload();
                fileDownload.setDisplayName(thisTemplate.getName());
                fileDownload.sendFileFromZip(context, templateList.getZipPath() + System.getProperty("file.separator") + thisTemplate.getFilename() + ".zip", "website/thumbnail.gif");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewLayouts(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            LayoutList layoutList = new LayoutList();
            layoutList.buildList(db);
            context.getRequest().setAttribute("layoutList", (Object)layoutList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewLayoutsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateLayout(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            String siteId = context.getRequest().getParameter("siteId");
            String layoutId = context.getRequest().getParameter("layoutId");
            db = this.getConnection(context);
            Site thisSite = new Site(db, Integer.parseInt(siteId));
            thisSite.updateLayoutId(db, Integer.parseInt(layoutId));
        }
        catch (Exception e) {
            String string;
            try {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return "UpdateLayoutOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewStyles(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            StyleList styleList = new StyleList();
            styleList.buildList(db);
            context.getRequest().setAttribute("styleList", (Object)styleList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewStylesOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateStyle(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            String siteId = context.getRequest().getParameter("siteId");
            String styleId = context.getRequest().getParameter("styleId");
            db = this.getConnection(context);
            Site thisSite = new Site(db, Integer.parseInt(siteId));
            thisSite.updateStyleId(db, Integer.parseInt(styleId));
        }
        catch (Exception e) {
            String string;
            try {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return "UpdateStyleOK";
    }
}

