/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.modules.website.base.Tab;
import org.aspcfs.modules.website.icelet.HtmlContentPortlet;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;

public final class Tabs
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return Tabs.getReturn(context, "Default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        String nextTabId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        Tab tab = (Tab)((Object)context.getFormBean());
        String previousTabId = context.getRequest().getParameter("previousTabId");
        if (previousTabId == null || "".equals(previousTabId.trim())) {
            previousTabId = (String)context.getRequest().getAttribute("previousTabId");
        }
        if (previousTabId != null && !"".equals(previousTabId)) {
            tab.setPreviousTabId(previousTabId);
            context.getRequest().setAttribute("previousTabId", (Object)previousTabId);
        }
        if ((nextTabId = context.getRequest().getParameter("nextTabId")) == null || "".equals(nextTabId.trim())) {
            nextTabId = (String)context.getRequest().getAttribute("nextTabId");
        }
        if (nextTabId != null && !"".equals(nextTabId)) {
            tab.setNextTabId(nextTabId);
            context.getRequest().setAttribute("nextTabId", (Object)nextTabId);
        }
        Site site = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            site = new Site();
            site.setBuildTabList(true);
            site.queryRecord(db, Integer.parseInt(siteId));
            context.getRequest().setAttribute("site", (Object)site);
            tab.setSiteId(siteId);
            context.getRequest().setAttribute("tab", (Object)tab);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Tabs.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        String tabId;
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((tabId = context.getRequest().getParameter("tabId")) == null || "".equals(tabId.trim())) {
            tabId = (String)context.getRequest().getAttribute("tabId");
        }
        Tab tab = (Tab)((Object)context.getFormBean());
        Site site = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            site = new Site();
            site.setBuildTabList(true);
            site.queryRecord(db, Integer.parseInt(siteId));
            context.getRequest().setAttribute("site", (Object)site);
            if (tab.getId() == -1) {
                tab = new Tab(db, Integer.parseInt(tabId));
            }
            tab.setSiteId(siteId);
            context.getRequest().setAttribute("tab", (Object)tab);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Tabs.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        String previousTabId = context.getRequest().getParameter("previousTabId");
        String nextTabId = context.getRequest().getParameter("nextTabId");
        boolean isValid = false;
        boolean recordInserted = false;
        int recordCount = -1;
        Tab tab = (Tab)((Object)context.getFormBean());
        Object site = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (tab.getSiteId() == -1) {
                tab.setSiteId(siteId);
            }
            tab.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)tab);
            if (isValid) {
                if (tab.getId() > -1) {
                    recordCount = tab.update(db);
                } else {
                    tab.setPosition(tab.computeTabPosition(db));
                    recordInserted = tab.insert(db);
                    if (recordInserted) {
                        this.insertDefaultData(context, db, tab.getId());
                    }
                }
            }
            if (!isValid || !recordInserted && recordCount == -1) {
                if (nextTabId != null && !"".equals(nextTabId.trim())) {
                    context.getRequest().setAttribute("nextTabId", (Object)nextTabId);
                }
                if (previousTabId != null && !"".equals(previousTabId.trim())) {
                    context.getRequest().setAttribute("previousTabId", (Object)previousTabId);
                }
                if (tab.getId() > -1) {
                    String string = this.executeCommandModify(context);
                    return string;
                }
                String string = this.executeCommandAdd(context);
                return string;
            }
            context.getRequest().setAttribute("siteId", (Object)String.valueOf(tab.getSiteId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Tabs.getReturn(context, "Save");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "site-editor-edit")) {
            return "PermissionError";
        }
        String tabId = context.getRequest().getParameter("tabId");
        String moveTabLeft = context.getRequest().getParameter("moveTabLeft");
        if (moveTabLeft == null || "".equals(moveTabLeft.trim())) {
            moveTabLeft = new String("YES");
        }
        Tab tab = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            tab = new Tab(db, Integer.parseInt(tabId));
            tab.move(db, DatabaseUtils.parseBoolean(moveTabLeft));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Tabs.getReturn(context, "Move");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        String tabId;
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId == null || "".equals(siteId.trim())) {
            siteId = (String)context.getRequest().getAttribute("siteId");
        }
        if ((tabId = context.getRequest().getParameter("tabId")) == null || "".equals(tabId.trim())) {
            tabId = (String)context.getRequest().getAttribute("tabId");
        }
        Tab tab = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            tab = new Tab(db, Integer.parseInt(tabId));
            DependencyList dependencies = tab.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("actionphase.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='Tabs.do?command=Delete&siteId=" + siteId + "&tabId=" + tab.getId() + "&popup=true'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Tabs.getReturn(context, "ConfirmDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        String tabId;
        if (!this.hasPermission(context, "site-editor-delete")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (siteId != null && !"".equals(siteId)) {
            context.getRequest().setAttribute("siteId", (Object)siteId);
        }
        if ((tabId = context.getRequest().getParameter("tabId")) == null || "".equals(tabId)) {
            tabId = (String)context.getRequest().getAttribute("tabId");
        }
        Tab tab = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            tab = new Tab();
            tab.queryRecord(db, Integer.parseInt(tabId));
            tab.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("Sites.do?command=Details&siteId=" + siteId + "&popup=true"));
        return Tabs.getReturn(context, "Delete");
    }

    public void insertDefaultData(ActionContext context, Connection db, int tabId) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        int userId = this.getUserId(context);
        PageVersion pageVersion = new PageVersion();
        pageVersion.setVersionNumber(1);
        pageVersion.setModifiedBy(userId);
        pageVersion.insert(db);
        PageGroup pageGroup = new PageGroup();
        pageGroup.setName(systemStatus.getLabel("", "Home"));
        pageGroup.setTabId(tabId);
        pageGroup.setPosition(0);
        pageGroup.setModifiedBy(userId);
        pageGroup.insert(db);
        Page page = new Page();
        page.setName(systemStatus.getLabel("", "Home"));
        page.setPageGroupId(pageGroup.getId());
        page.setConstructionPageVersionId(pageVersion.getId());
        page.setActivePageVersionId(pageVersion.getId());
        page.setPosition(0);
        page.setEnabled(true);
        page.setModifiedBy(userId);
        page.insert(db);
        pageVersion = new PageVersion(db, pageVersion.getId());
        pageVersion.setOverride(true);
        pageVersion.setPageId(page.getId());
        pageVersion.update(db);
        PageRow pageRow = new PageRow();
        pageRow.setPageVersionId(page.getConstructionPageVersionId());
        pageRow.setPosition(0);
        pageRow.setEnabled(true);
        pageRow.setModifiedBy(userId);
        pageRow.insert(db);
        Icelet htmlIcelet = null;
        IceletList iceletList = new IceletList();
        iceletList.setConfiguratorClass("HtmlContentPortlet");
        iceletList.buildList(db);
        if (iceletList.size() > 0) {
            htmlIcelet = (Icelet)((Object)iceletList.get(0));
        }
        RowColumn rowColumn = new RowColumn();
        rowColumn.setPageRowId(pageRow.getId());
        rowColumn.setModifiedBy(userId);
        rowColumn.setEnabled(true);
        rowColumn.setWidth(100);
        rowColumn.setPosition(0);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            rowColumn.setIceletId(htmlIcelet.getId());
        }
        rowColumn.insert(db);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            IceletProperty property = new IceletProperty();
            property.setRowColumnId(rowColumn.getId());
            property.setValue("Please enter your html text here");
            property.setTypeConstant(HtmlContentPortlet.PROPERTY_HTMLTEXT);
            property.setModifiedBy(userId);
            property.insert(db);
        }
    }
}

