/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolderHierarchy;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.iteam.base.Thumbnail;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.utils.ImageUtils;

public final class WebsiteMedia
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileFolderList folders = new FileFolderList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                folders.setTopLevelOnly(true);
            } else {
                folders.setParentId(Integer.parseInt(folderId));
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            folders.setLinkModuleId(2006051216);
            folders.setLinkItemId(2006051216);
            folders.setBuildItemCount(true);
            folders.buildList(db);
            FileItemList files = new FileItemList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                files.setTopLevelOnly(true);
            } else {
                files.setFolderId(Integer.parseInt(folderId));
            }
            files.setLinkModuleId(2006051216);
            files.setLinkItemId(2006051216);
            files.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)files);
            context.getRequest().setAttribute("fileFolderList", (Object)folders);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Website", "View Documents");
        if (errorMessage == null) {
            return WebsiteMedia.getReturn(context, "View");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String folderId = context.getRequest().getParameter("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Website", "Upload Document");
        if (errorMessage == null) {
            return WebsiteMedia.getReturn(context, "Add");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "website");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String subject = (String)parts.get("subject");
            String folderId = (String)parts.get("folderId");
            String actionStepWork = (String)parts.get("actionStepWork");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (actionStepWork != null) {
                context.getRequest().setAttribute("actionStepWork", (Object)actionStepWork);
            }
            db = this.getConnection(context);
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(2006051216);
                thisItem.setLinkItemId(2006051216);
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(Integer.parseInt(folderId));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
                if (recordInserted) {
                    thisItem.setDirectory(filePath);
                    if (thisItem.isImageFormat()) {
                        File thumbnailFile = new File(newFileInfo.getLocalFile().getPath() + "TH");
                        ImageUtils.saveThumbnail(newFileInfo.getLocalFile(), thumbnailFile, 133.0, 133.0);
                        Thumbnail thumbnail = new Thumbnail();
                        thumbnail.setId(thisItem.getId());
                        thumbnail.setFilename(newFileInfo.getRealFilename() + "TH");
                        thumbnail.setVersion(thisItem.getVersion());
                        thumbnail.setSize((int)thumbnailFile.length());
                        thumbnail.setEnteredBy(thisItem.getEnteredBy());
                        thumbnail.setModifiedBy(thisItem.getModifiedBy());
                        thumbnail.insert(db);
                    }
                    context.getRequest().setAttribute("fileItem", (Object)thisItem);
                    context.getRequest().setAttribute("subject", (Object)"");
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return WebsiteMedia.getReturn(context, "Upload");
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        String folderId;
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        if (itemId == null) {
            itemId = (String)context.getRequest().getAttribute("fid");
        }
        if ((folderId = context.getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisFile = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            context.getRequest().setAttribute("FileItem", (Object)thisFile);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Website", "Upload New Document Version");
        if (errorMessage == null) {
            return WebsiteMedia.getReturn(context, "AddVersion");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadVersion(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "website");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String itemId = (String)parts.get("fid");
            String subject = (String)parts.get("subject");
            String versionId = (String)parts.get("versionId");
            String folderId = (String)parts.get("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            db = this.getConnection(context);
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem previousItem = null;
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(2006051216);
                thisItem.setLinkItemId(2006051216);
                thisItem.setId(Integer.parseInt(itemId));
                previousItem = new FileItem(db, Integer.parseInt(itemId), thisItem.getLinkItemId(), thisItem.getLinkModuleId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(Double.parseDouble(versionId));
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insertVersion(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("fid", (Object)itemId);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return WebsiteMedia.getReturn(context, "Upload");
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        String folderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            thisItem.buildVersionList(db);
            if (folderId == null) {
                folderId = "" + thisItem.getFolderId();
            }
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (!(folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId.trim()))) {
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Website", "Document Details");
        if (errorMessage == null) {
            return WebsiteMedia.getReturn(context, "Details");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage;
        block27: {
            if (!this.hasPermission(context, "accounts-accounts-documents-view")) {
                return "PermissionError";
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            String view = context.getRequest().getParameter("view");
            FileItem thisItem = null;
            Connection db = null;
            try {
                db = this.getConnection(context);
                thisItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "website") + WebsiteMedia.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if (view != null && "true".equals(view)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("LeadsDocuments-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        String string = this.executeCommandView(context);
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block27;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "website") + WebsiteMedia.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block27;
                }
                db = null;
                System.err.println("LeadsDocuments-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "View Website", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Website", "Modify Document Information");
        if (errorMessage == null) {
            return WebsiteMedia.getReturn(context, "Modify");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-edit")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        String itemId = context.getRequest().getParameter("fid");
        String subject = context.getRequest().getParameter("subject");
        String filename = context.getRequest().getParameter("clientFilename");
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            FileItem previousItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            thisItem.setClientFilename(filename);
            thisItem.setSubject(subject);
            isValid = this.validateObject(context, db, thisItem);
            if (isValid) {
                recordInserted = thisItem.update(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Website", "");
        if (recordInserted && isValid) {
            return WebsiteMedia.getReturn(context, "Update");
        }
        context.getRequest().setAttribute("fid", (Object)itemId);
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            recordDeleted = thisItem.delete(db, this.getPath(context, "website"));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Website", "Delete Document");
        if (errorMessage == null) {
            if (recordDeleted) {
                return WebsiteMedia.getReturn(context, "Delete");
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(2006051216);
            hierarchy.setLinkItemId(2006051216);
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = WebsiteMedia.getReturn(context, "Move");
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        Connection db = null;
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), 2006051216, 2006051216);
            thisItem.updateFolderId(db, Integer.parseInt(newFolderId));
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

