/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.modules.website.base.RowColumnList;
import org.aspcfs.utils.DatabaseUtils;

public class Icelet
extends GenericBean {
    private int id = -1;
    private String name = null;
    private String description = null;
    private String configuratorClass = null;
    private int version = -1;
    private boolean enabled = false;
    private IceletPropertyMap iceletPropertyMap = null;

    public Icelet() {
    }

    public Icelet(Connection db, int tmpIceletId) throws SQLException {
        this.queryRecord(db, tmpIceletId);
    }

    public Icelet(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setConfiguratorClass(String tmp) {
        this.configuratorClass = tmp;
    }

    public void setVersion(int tmp) {
        this.version = tmp;
    }

    public void setVersion(String tmp) {
        this.version = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIceletPropertyMap(IceletPropertyMap tmp) {
        this.iceletPropertyMap = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getConfiguratorClass() {
        return this.configuratorClass;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public IceletPropertyMap getIceletPropertyMap() {
        return this.iceletPropertyMap;
    }

    public boolean queryRecord(Connection db, int tmpIceletId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_icelet  WHERE icelet_id = ? ");
        pst.setInt(1, tmpIceletId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_icelet_icelet_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_icelet (" + (this.id > -1 ? "icelet_id, " : "") + "icelet_name , " + "icelet_description , " + "icelet_configurator_class , " + "icelet_version , " + "enabled )  " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.name);
        pst.setString(++i, this.description);
        pst.setString(++i, this.configuratorClass);
        DatabaseUtils.setInt(pst, ++i, this.version);
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_icelet_icelet_id_seq", this.id);
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = db.prepareStatement("UPDATE web_icelet SET icelet_name = ? , icelet_description = ? , icelet_configurator_class = ? , icelet_version = ? , enabled = ?  WHERE icelet_id = ? ");
        int i = 0;
        pst.setString(++i, this.name);
        pst.setString(++i, this.description);
        pst.setString(++i, this.configuratorClass);
        DatabaseUtils.setInt(pst, ++i, this.version);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            RowColumnList tmpRowColumnList = new RowColumnList();
            tmpRowColumnList.setIceletId(this.getId());
            tmpRowColumnList.buildList(db);
            tmpRowColumnList.delete(db);
            tmpRowColumnList = null;
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_icelet WHERE icelet_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("icelet_id");
        this.name = rs.getString("icelet_name");
        this.description = rs.getString("icelet_description");
        this.configuratorClass = rs.getString("icelet_configurator_class");
        this.version = DatabaseUtils.getInt(rs, "icelet_version");
        this.enabled = rs.getBoolean("enabled");
    }
}

