/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;
import org.w3c.dom.Element;

public class IceletList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private String name = null;
    private String configuratorClass = null;
    private int enabled = -1;
    private String emptyHtmlSelectRecord = null;
    private String jsEvent = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setConfiguratorClass(String tmp) {
        this.configuratorClass = tmp;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getConfiguratorClass() {
        return this.configuratorClass;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Icelet thisIcelet = this.getObject(rs);
            this.add(thisIcelet);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public void buildList(HashMap map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Icelet thisIcelet = (Icelet)((Object)map.get(iter.next()));
            this.add(thisIcelet);
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_icelet WHERE icelet_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("icelet_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY icelet_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wi.* FROM web_icelet wi WHERE icelet_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND icelet_id = ? ");
        }
        if (this.name != null) {
            sqlFilter.append("AND icelet_name = ? ");
        }
        if (this.configuratorClass != null) {
            sqlFilter.append("AND icelet_configurator_class = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.name != null) {
            pst.setString(++i, this.name);
        }
        if (this.configuratorClass != null) {
            pst.setString(++i, this.configuratorClass);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getEmptyHtmlSelect(SystemStatus thisSystem, String selectName) {
        HtmlSelect iceletListSelect = new HtmlSelect();
        iceletListSelect.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        return iceletListSelect.getHtml(selectName);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect iceletListSelect = new HtmlSelect();
        iceletListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            iceletListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        boolean foundDefaultIcelet = false;
        for (Icelet thisIcelet : this) {
            if (!thisIcelet.getEnabled() && thisIcelet.getId() != defaultKey) continue;
            iceletListSelect.addItem(thisIcelet.getId(), thisIcelet.getName());
        }
        return iceletListSelect.getHtml(selectName, defaultKey);
    }

    public HtmlSelect getHtmlSelectObj() {
        HtmlSelect iceletListSelect = new HtmlSelect();
        iceletListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            iceletListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        boolean foundDefaultIcelet = false;
        for (Icelet thisIcelet : this) {
            if (!thisIcelet.getEnabled()) continue;
            iceletListSelect.addItem(thisIcelet.getId(), thisIcelet.getName());
        }
        return iceletListSelect;
    }

    public int getIdFromConfiguratorClass(String tmpConfiguratorClass) {
        for (Icelet icelet : this) {
            if (!tmpConfiguratorClass.equals(icelet.getConfiguratorClass())) continue;
            return icelet.getId();
        }
        return -1;
    }

    public Icelet getObject(ResultSet rs) throws SQLException {
        Icelet thisIcelet = new Icelet(rs);
        return thisIcelet;
    }

    public void delete(Connection db) throws SQLException {
        for (Icelet thisIcelet : this) {
            thisIcelet.delete(db);
        }
    }

    public static HashMap load(String filePath) throws Exception {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Reading from file:" + filePath);
        }
        File configFile = new File(filePath);
        XMLUtils xml = new XMLUtils(configFile);
        HashMap<String, Icelet> iceletMap = new HashMap<String, Icelet>();
        ArrayList iceletElements = new ArrayList();
        XMLUtils.getAllChildren(xml.getDocumentElement(), "icelet", iceletElements);
        Iterator iceletIterator = iceletElements.iterator();
        System.out.println("Reading values for icelets");
        while (iceletIterator.hasNext()) {
            Element iceletElement = (Element)iceletIterator.next();
            Element descriptionElement = XMLUtils.getFirstChild(iceletElement, "description");
            Icelet icelet = new Icelet();
            String value = "";
            if (iceletElement.hasAttribute("name")) {
                icelet.setName(iceletElement.getAttribute("name"));
            }
            if (iceletElement.hasAttribute("class")) {
                icelet.setConfiguratorClass(iceletElement.getAttribute("class"));
            }
            if (iceletElement.hasAttribute("version")) {
                icelet.setVersion(iceletElement.getAttribute("version"));
            }
            icelet.setDescription(XMLUtils.getNodeText(descriptionElement));
            IceletPropertyMap iceletPropertyMap = new IceletPropertyMap();
            ArrayList propertyElementList = new ArrayList();
            XMLUtils.getAllChildren(iceletElement, "property", propertyElementList);
            Iterator propertyElementIterator = propertyElementList.iterator();
            while (propertyElementIterator.hasNext()) {
                IceletProperty iceletProperty = new IceletProperty();
                Element propertyElement = (Element)propertyElementIterator.next();
                iceletProperty.setTypeConstant(propertyElement.getAttribute("constant"));
                iceletProperty.setDescription(propertyElement.getAttribute("description"));
                iceletProperty.setLabel(propertyElement.getAttribute("label"));
                iceletProperty.setType(propertyElement.getAttribute("type"));
                Element defaultValue = XMLUtils.getFirstChild(propertyElement, "defaultValue");
                if (defaultValue != null) {
                    iceletProperty.setDefaultValue(XMLUtils.getNodeText(defaultValue));
                } else {
                    iceletProperty.setDefaultValue(propertyElement.getAttribute("defaultValue"));
                }
                iceletProperty.setAdditionalText(propertyElement.getAttribute("additionalText"));
                iceletProperty.setAutoAdd(propertyElement.getAttribute("autoAdd"));
                iceletPropertyMap.put(new Integer(iceletProperty.getTypeConstant()), iceletProperty);
            }
            icelet.setIceletPropertyMap(iceletPropertyMap);
            iceletMap.put(icelet.getConfiguratorClass(), icelet);
        }
        return iceletMap;
    }

    public Icelet getIceletById(int id) {
        Icelet result = null;
        for (Icelet icelet : this) {
            if (icelet.getId() != id) continue;
            result = icelet;
        }
        return result;
    }
}

