/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class IceletPropertyMap
extends LinkedHashMap {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int iceletRowColumnId = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean buildNames = false;
    private IceletPropertyMap defaultProperties = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setIceletRowColumnId(int tmp) {
        this.iceletRowColumnId = tmp;
    }

    public void setIceletRowColumnId(String tmp) {
        this.iceletRowColumnId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getIceletRowColumnId() {
        return this.iceletRowColumnId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getBuildNames() {
        return this.buildNames;
    }

    public void setBuildNames(boolean tmp) {
        this.buildNames = tmp;
    }

    public void setBuildNames(String tmp) {
        this.buildNames = DatabaseUtils.parseBoolean(tmp);
    }

    public IceletPropertyMap getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(IceletPropertyMap tmp) {
        this.defaultProperties = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            IceletProperty defaultProperty;
            IceletProperty thisIceletProperty = this.getObject(rs);
            if (this.defaultProperties != null && (defaultProperty = (IceletProperty)((Object)this.defaultProperties.get(new Integer(thisIceletProperty.getTypeConstant())))) != null) {
                thisIceletProperty.setType(defaultProperty.getType());
            }
            this.put(new Integer(thisIceletProperty.getTypeConstant()), thisIceletProperty);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.getBuildNames()) {
            for (Integer name : this.keySet()) {
                IceletProperty tmpIceletProperty = (IceletProperty)((Object)this.get(name));
                tmpIceletProperty.buildValueString(db);
            }
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_icelet_property WHERE property_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("property_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY property_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wip.* FROM web_icelet_property wip WHERE property_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id > -1) {
            sqlFilter.append("AND property_id = ? ");
        }
        if (this.iceletRowColumnId > -1) {
            sqlFilter.append("AND row_column_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.iceletRowColumnId > -1) {
            pst.setInt(++i, this.iceletRowColumnId);
        }
        return i;
    }

    public IceletProperty getObject(ResultSet rs) throws SQLException {
        return new IceletProperty(rs);
    }

    public void setRequestItems(ActionContext context) {
        Map parameters = context.getRequest().getParameterMap();
        for (String thisParamName : parameters.keySet()) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("PARAM NAME  **** " + thisParamName);
            }
            if (thisParamName.indexOf("property_") == -1) continue;
            String[] values = thisParamName.split("_");
            Integer name = new Integer(values[2]);
            int propertyRowColumn = Integer.parseInt(values[1]);
            String value = context.getRequest().getParameter(thisParamName);
            IceletProperty tmpIceletProperty = new IceletProperty();
            tmpIceletProperty.setTypeConstant(name);
            tmpIceletProperty.setValue(value);
            tmpIceletProperty.setRowColumnId(this.iceletRowColumnId);
            tmpIceletProperty.setEnteredBy(this.enteredBy);
            tmpIceletProperty.setModifiedBy(this.modifiedBy);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("NAME *** " + name + " VALUE *** " + context.getRequest().getParameter(thisParamName));
            }
            if (propertyRowColumn != this.iceletRowColumnId) continue;
            this.put(name, tmpIceletProperty);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (Integer name : this.keySet()) {
            IceletProperty tmpIceletProperty = (IceletProperty)((Object)this.get(name));
            tmpIceletProperty.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        for (Integer name : this.keySet()) {
            IceletProperty tmpIceletProperty = (IceletProperty)((Object)this.get(name));
            tmpIceletProperty.insert(db);
        }
    }

    public void addAdditionalInformation(int rowColumnId, int modifiedBy) {
        for (Integer name : this.keySet()) {
            IceletProperty tmpIceletProperty = (IceletProperty)((Object)this.get(name));
            tmpIceletProperty.setRowColumnId(rowColumnId);
            tmpIceletProperty.setModifiedBy(modifiedBy);
        }
    }

    public String getValueFromConstant(int tmpPropertyConstant) {
        IceletProperty tmpIceletProperty = null;
        String tmpIceletPropertyValue = null;
        tmpIceletProperty = (IceletProperty)((Object)this.get(new Integer(tmpPropertyConstant)));
        tmpIceletPropertyValue = tmpIceletProperty == null ? "" : tmpIceletProperty.getValue();
        return tmpIceletPropertyValue;
    }

    public IceletProperty getProperty(int tmpPropertyConstant) {
        return (IceletProperty)((Object)this.get(new Integer(tmpPropertyConstant)));
    }

    public void setElements(String str) {
        StringTokenizer properties = new StringTokenizer(str, "|");
        while (properties.hasMoreTokens()) {
            IceletProperty tmpIceletProperty = new IceletProperty();
            StringTokenizer property = new StringTokenizer(properties.nextToken(), ",");
            tmpIceletProperty.setTypeConstant(property.nextToken());
            tmpIceletProperty.setValue(property.nextToken());
            this.put(new Integer(tmpIceletProperty.getTypeConstant()), tmpIceletProperty);
        }
    }

    public void updateEntries(Connection db, IceletPropertyMap oldMap) throws SQLException {
        for (Integer name : oldMap.keySet()) {
            IceletProperty tmpIceletProperty = (IceletProperty)((Object)this.get(name));
            IceletProperty newIcelet = (IceletProperty)((Object)this.get(name));
            tmpIceletProperty.setModifiedBy(newIcelet.getModifiedBy());
            tmpIceletProperty.update(db);
        }
    }
}

