/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.website.base.StyleList;
import org.aspcfs.utils.DatabaseUtils;

public class Layout
extends GenericBean {
    private int id = -1;
    private int constant = -1;
    private String name = null;
    private String jsp = null;
    private String thumbnail = null;
    private boolean custom = false;
    private boolean buildStyleList = false;
    private StyleList styleList = null;

    public Layout() {
    }

    public Layout(Connection db, int tmpLayoutId) throws SQLException {
        this.queryRecord(db, tmpLayoutId);
    }

    public Layout(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setConstant(int tmp) {
        this.constant = tmp;
    }

    public void setConstant(String tmp) {
        this.constant = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setJsp(String tmp) {
        this.jsp = tmp;
    }

    public void setThumbnail(String tmp) {
        this.thumbnail = tmp;
    }

    public void setCustom(boolean tmp) {
        this.custom = tmp;
    }

    public void setCustom(String tmp) {
        this.custom = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildStyleList(boolean tmp) {
        this.buildStyleList = tmp;
    }

    public void setBuildStyleList(String tmp) {
        this.buildStyleList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setStyleList(StyleList tmp) {
        this.styleList = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getConstant() {
        return this.constant;
    }

    public String getName() {
        return this.name;
    }

    public String getJsp() {
        return this.jsp;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public boolean getCustom() {
        return this.custom;
    }

    public boolean getBuildStyleList() {
        return this.buildStyleList;
    }

    public StyleList getStyleList() {
        return this.styleList;
    }

    public boolean queryRecord(Connection db, int tmpLayoutId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_layout  WHERE layout_id = ? ");
        pst.setInt(1, tmpLayoutId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Layout record not found");
        }
        if (this.buildStyleList) {
            this.buildStyleList(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_layout_layout_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_layout (" + (this.id > -1 ? "layout_id, " : "") + "layout_constant , " + "layout_name , " + "jsp , " + "thumbnail , " + "custom ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.constant);
        pst.setString(++i, this.name);
        pst.setString(++i, this.jsp);
        pst.setString(++i, this.thumbnail);
        pst.setBoolean(++i, this.custom);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_layout_layout_id_seq", this.id);
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_layout SET layout_constant = ? , layout_name = ? , jsp = ? , thumbnail = ? , custom = ? ");
        sql.append("WHERE layout_id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.constant);
        pst.setString(++i, this.name);
        pst.setString(++i, this.jsp);
        pst.setString(++i, this.thumbnail);
        pst.setBoolean(++i, this.custom);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            StyleList tmpStyleList = new StyleList();
            tmpStyleList.setLayoutId(this.getId());
            tmpStyleList.buildList(db);
            tmpStyleList.delete(db);
            tmpStyleList = null;
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_layout WHERE layout_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("layout_id");
        this.constant = DatabaseUtils.getInt(rs, "layout_constant");
        this.name = rs.getString("layout_name");
        this.jsp = rs.getString("jsp");
        this.thumbnail = rs.getString("thumbnail");
        this.custom = rs.getBoolean("custom");
    }

    public void buildStyleList(Connection db) throws SQLException {
        this.styleList = new StyleList();
        this.styleList.buildList(db);
    }
}

