/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.Layout;
import org.aspcfs.utils.web.PagedListInfo;

public class LayoutList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int constant = -1;
    private int custom = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setConstant(int tmp) {
        this.constant = tmp;
    }

    public void setConstant(String tmp) {
        this.constant = Integer.parseInt(tmp);
    }

    public void setCustom(int tmp) {
        this.custom = tmp;
    }

    public void setCustom(String tmp) {
        this.custom = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getConstant() {
        return this.constant;
    }

    public int getCustom() {
        return this.custom;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Layout thisLayout = this.getObject(rs);
            this.add(thisLayout);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_layout WHERE layout_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("layout_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY layout_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wl.* FROM web_layout wl WHERE layout_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND layout_id = ? ");
        }
        if (this.constant != -1) {
            sqlFilter.append("AND layout_constant = ? ");
        }
        if (this.custom != -1) {
            sqlFilter.append("AND custom = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.constant != -1) {
            pst.setInt(++i, this.constant);
        }
        if (this.custom != -1) {
            pst.setBoolean(++i, this.custom == 1);
        }
        return i;
    }

    public Layout getObject(ResultSet rs) throws SQLException {
        Layout thisLayout = new Layout(rs);
        return thisLayout;
    }

    public void delete(Connection db) throws SQLException {
        for (Layout thisLayout : this) {
            thisLayout.delete(db);
        }
    }
}

