/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.modules.website.base.PageList;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.PageVersionList;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.modules.website.base.TabBanner;
import org.aspcfs.utils.DatabaseUtils;

public class Page
extends GenericBean {
    public static final int INITIAL_POSITION = 0;
    private int id = -1;
    private String name = null;
    private int position = -1;
    private int activePageVersionId = -1;
    private int constructionPageVersionId = -1;
    private int pageGroupId = -1;
    private int tabBannerId = -1;
    private String notes = null;
    private boolean enabled = false;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean buildPageVersionList = false;
    private PageVersionList pageVersionList = null;
    private boolean override = false;
    private boolean buildTabBanner = false;
    private TabBanner tabBanner = null;
    private int mode = -1;
    private boolean buildPageVersionToView = false;
    private PageVersion pageVersionToView = null;
    private PageGroup pageGroup = null;
    private int previousPageId = -1;
    private int nextPageId = -1;

    public Page() {
    }

    public Page(Connection db, int tmpPageId) throws SQLException {
        this.queryRecord(db, tmpPageId);
    }

    public Page(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setActivePageVersionId(int tmp) {
        this.activePageVersionId = tmp;
    }

    public void setActivePageVersionId(String tmp) {
        this.activePageVersionId = Integer.parseInt(tmp);
    }

    public void setConstructionPageVersionId(int tmp) {
        this.constructionPageVersionId = tmp;
    }

    public void setConstructionPageVersionId(String tmp) {
        this.constructionPageVersionId = Integer.parseInt(tmp);
    }

    public void setPageGroupId(int tmp) {
        this.pageGroupId = tmp;
    }

    public void setPageGroupId(String tmp) {
        this.pageGroupId = Integer.parseInt(tmp);
    }

    public void setTabBannerId(int tmp) {
        this.tabBannerId = tmp;
    }

    public void setTabBannerId(String tmp) {
        this.tabBannerId = Integer.parseInt(tmp);
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setBuildPageVersionList(boolean tmp) {
        this.buildPageVersionList = tmp;
    }

    public void setBuildPageVersionList(String tmp) {
        this.buildPageVersionList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPageVersionList(PageVersionList tmp) {
        this.pageVersionList = tmp;
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildTabBanner(boolean tmp) {
        this.buildTabBanner = tmp;
    }

    public void setBuildTabBanner(String tmp) {
        this.buildTabBanner = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTabBanner(TabBanner tmp) {
        this.tabBanner = tmp;
    }

    public void setMode(int tmp) {
        this.mode = tmp;
    }

    public void setMode(String tmp) {
        this.mode = Integer.parseInt(tmp);
    }

    public void setBuildPageVersionToView(boolean tmp) {
        this.buildPageVersionToView = tmp;
    }

    public void setBuildPageVersionToView(String tmp) {
        this.buildPageVersionToView = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPageVersionToView(PageVersion tmp) {
        this.pageVersionToView = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public int getActivePageVersionId() {
        return this.activePageVersionId;
    }

    public int getConstructionPageVersionId() {
        return this.constructionPageVersionId;
    }

    public int getPageGroupId() {
        return this.pageGroupId;
    }

    public int getTabBannerId() {
        return this.tabBannerId;
    }

    public String getNotes() {
        return this.notes;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getBuildPageVersionList() {
        return this.buildPageVersionList;
    }

    public PageVersionList getPageVersionList() {
        return this.pageVersionList;
    }

    public boolean getOverride() {
        return this.override;
    }

    public boolean getBuildTabBanner() {
        return this.buildTabBanner;
    }

    public TabBanner getTabBanner() {
        return this.tabBanner;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getBuildPageVersionToView() {
        return this.buildPageVersionToView;
    }

    public PageVersion getPageVersionToView() {
        return this.pageVersionToView;
    }

    public int getPreviousPageId() {
        return this.previousPageId;
    }

    public void setPreviousPageId(int tmp) {
        this.previousPageId = tmp;
    }

    public void setPreviousPageId(String tmp) {
        this.previousPageId = Integer.parseInt(tmp);
    }

    public int getNextPageId() {
        return this.nextPageId;
    }

    public void setNextPageId(int tmp) {
        this.nextPageId = tmp;
    }

    public void setNextPageId(String tmp) {
        this.nextPageId = Integer.parseInt(tmp);
    }

    public PageGroup getPageGroup() {
        return this.pageGroup;
    }

    public void setPageGroup(PageGroup tmp) {
        this.pageGroup = tmp;
    }

    public boolean queryRecord(Connection db, int tmpPageId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT wp.*  FROM web_page wp  WHERE page_id = ? ");
        pst.setInt(1, tmpPageId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Page record not found");
        }
        if (this.buildTabBanner) {
            this.buildTabBanner(db);
        }
        if (this.buildPageVersionList) {
            this.buildPageVersionList(db);
        }
        if (this.buildPageVersionToView) {
            this.buildPageVersionToView(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_page_page_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_page (" + (this.id > -1 ? "page_id, " : "") + "page_name , " + "page_position , " + "active_page_version_id , " + "construction_page_version_id , " + "page_group_id , " + "tab_banner_id , " + "notes , " + "enabled , " + "enteredby , " + "modifiedby ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.name);
        pst.setInt(++i, this.position);
        DatabaseUtils.setInt(pst, ++i, this.activePageVersionId);
        DatabaseUtils.setInt(pst, ++i, this.constructionPageVersionId);
        DatabaseUtils.setInt(pst, ++i, this.pageGroupId);
        DatabaseUtils.setInt(pst, ++i, this.tabBannerId);
        pst.setString(++i, this.notes);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_page_page_id_seq", this.id);
        pst.close();
        this.updateRelatedPages(db, true);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_page SET page_name = ? , page_position = ? , active_page_version_id = ? , construction_page_version_id = ? , page_group_id = ? , tab_banner_id = ? , notes = ? , enabled = ?  ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE page_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.name);
        pst.setInt(++i, this.position);
        DatabaseUtils.setInt(pst, ++i, this.activePageVersionId);
        DatabaseUtils.setInt(pst, ++i, this.constructionPageVersionId);
        DatabaseUtils.setInt(pst, ++i, this.pageGroupId);
        DatabaseUtils.setInt(pst, ++i, this.tabBannerId);
        pst.setString(++i, this.notes);
        pst.setBoolean(++i, this.enabled);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("UPDATE web_page SET active_page_version_id = ?,  construction_page_version_id = ? WHERE page_id =  ? ");
            DatabaseUtils.setInt(pst, 1, -1);
            DatabaseUtils.setInt(pst, 2, -1);
            DatabaseUtils.setInt(pst, 3, this.getId());
            pst.execute();
            pst.close();
            this.pageVersionList = new PageVersionList();
            this.pageVersionList.setPageId(this.getId());
            this.pageVersionList.buildList(db);
            this.pageVersionList.delete(db);
            this.pageVersionList = null;
            this.updateRelatedPages(db, false);
            pst = db.prepareStatement("UPDATE web_page_access_log  SET page_id = ?  WHERE page_id = ? ");
            int i = 0;
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM web_page WHERE page_id =  ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("page_id");
        this.name = rs.getString("page_name");
        this.position = rs.getInt("page_position");
        this.activePageVersionId = DatabaseUtils.getInt(rs, "active_page_version_id");
        this.constructionPageVersionId = DatabaseUtils.getInt(rs, "construction_page_version_id");
        this.pageGroupId = DatabaseUtils.getInt(rs, "page_group_id");
        this.tabBannerId = DatabaseUtils.getInt(rs, "tab_banner_id");
        this.notes = rs.getString("notes");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public void buildTabBanner(Connection db) throws SQLException {
        this.tabBanner = new TabBanner(db, this.getTabBannerId());
    }

    public void buildPageVersionList(Connection db) throws SQLException {
        this.pageVersionList = new PageVersionList();
        this.pageVersionList.setPageId(this.getId());
        this.pageVersionList.buildList(db);
    }

    public void buildPageVersionToView(Connection db) throws SQLException {
        this.pageVersionToView = new PageVersion();
        this.pageVersionToView.setMode(this.mode);
        this.pageVersionToView.setBuildPageRowList(true);
        if (this.mode == Site.EDIT_MODE) {
            if (this.constructionPageVersionId != -1) {
                this.pageVersionToView.queryRecord(db, this.constructionPageVersionId);
            } else if (this.activePageVersionId != -1) {
                this.pageVersionToView.queryRecord(db, this.activePageVersionId);
            }
        } else {
            this.pageVersionToView.queryRecord(db, this.activePageVersionId);
        }
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Row ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        return dependencyList;
    }

    public int computePagePosition(Connection db) throws SQLException {
        int result = 0;
        Page otherPage = new Page();
        if (this.previousPageId != -1) {
            otherPage.queryRecord(db, this.previousPageId);
            result = otherPage.getPosition() + 1;
        } else if (this.nextPageId != -1) {
            otherPage.queryRecord(db, this.nextPageId);
            result = otherPage.getPosition();
        }
        return result;
    }

    public void updateRelatedPages(Connection db, boolean add) throws SQLException {
        if (this.previousPageId > -1) {
            PageList.updateRelatedPages(db, this.getId(), this.previousPageId, this.getPageGroupId(), false, add);
        } else if (this.nextPageId > -1) {
            PageList.updateRelatedPages(db, this.getId(), this.nextPageId, this.getPageGroupId(), true, add);
        } else if (!add) {
            PageList.updateRelatedPages(db, this.getId(), -1, this.getPageGroupId(), false, add);
        }
    }

    public void move(Connection db, boolean moveUp) throws SQLException {
        Page switchPage = null;
        PageList pages = new PageList();
        pages.setPageGroupId(this.getPageGroupId());
        pages.setPosition(moveUp ? this.getPosition() - 1 : this.getPosition() + 1);
        pages.buildList(db);
        if (pages.size() > 0) {
            switchPage = (Page)((Object)pages.get(0));
            int switchPagePosition = this.getPosition();
            this.setPosition(switchPage.getPosition());
            this.update(db);
            switchPage.setPosition(switchPagePosition);
            switchPage.update(db);
        }
    }
}

