/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroupList;
import org.aspcfs.modules.website.base.PageList;
import org.aspcfs.utils.DatabaseUtils;

public class PageGroup
extends GenericBean {
    public static final int INITIAL_POSITION = 0;
    private int id = -1;
    private String name = null;
    private String internalDescription = null;
    private int position = -1;
    private int tabId = -1;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private PageList pageList = null;
    private int pageToBuild = -1;
    private boolean override = true;
    private int mode = -1;
    private Page thisPageToBuild = null;
    private int previousPageGroupId = -1;
    private int nextPageGroupId = -1;

    public PageGroup() {
    }

    public PageGroup(Connection db, int tmpPageGroupId) throws SQLException {
        this.queryRecord(db, tmpPageGroupId);
    }

    public PageGroup(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setInternalDescription(String tmp) {
        this.internalDescription = tmp;
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setTabId(int tmp) {
        this.tabId = tmp;
    }

    public void setTabId(String tmp) {
        this.tabId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setPageList(PageList tmp) {
        this.pageList = tmp;
    }

    public void setPageToBuild(int tmp) {
        this.pageToBuild = tmp;
    }

    public void setPageToBuild(String tmp) {
        this.pageToBuild = Integer.parseInt(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setMode(int tmp) {
        this.mode = tmp;
    }

    public void setMode(String tmp) {
        this.mode = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public int getPosition() {
        return this.position;
    }

    public int getTabId() {
        return this.tabId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getPageToBuild() {
        return this.pageToBuild;
    }

    public boolean getOverride() {
        return this.override;
    }

    public int getMode() {
        return this.mode;
    }

    public PageList getPageList() {
        return this.pageList;
    }

    public Page getThisPageToBuild() {
        return this.thisPageToBuild;
    }

    public void setThisPageToBuild(Page tmp) {
        this.thisPageToBuild = tmp;
    }

    public int getPreviousPageGroupId() {
        return this.previousPageGroupId;
    }

    public void setPreviousPageGroupId(int tmp) {
        this.previousPageGroupId = tmp;
    }

    public void setPreviousPageGroupId(String tmp) {
        this.previousPageGroupId = Integer.parseInt(tmp);
    }

    public int getNextPageGroupId() {
        return this.nextPageGroupId;
    }

    public void setNextPageGroupId(int tmp) {
        this.nextPageGroupId = tmp;
    }

    public void setNextPageGroupId(String tmp) {
        this.nextPageGroupId = Integer.parseInt(tmp);
    }

    public boolean queryRecord(Connection db, int tmpPageGroupId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_page_group  WHERE page_group_id = ? ");
        pst.setInt(1, tmpPageGroupId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Page Group record not found");
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_page_group_page_group_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_page_group (" + (this.id > -1 ? "page_group_id, " : "") + "group_name , " + "internal_description , " + "group_position , " + "tab_id , " + "enteredby , " + "modifiedby ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.name);
        pst.setString(++i, this.internalDescription);
        pst.setInt(++i, this.position);
        pst.setInt(++i, this.tabId);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_page_group_page_group_id_seq", this.id);
        pst.close();
        this.updateRelatedPageGroups(db, true);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_page_group SET group_name = ? , internal_description = ? , group_position = ? , tab_id = ?  ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE page_group_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.name);
        pst.setString(++i, this.internalDescription);
        pst.setInt(++i, this.position);
        pst.setInt(++i, this.tabId);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PageList tmpPageList = new PageList();
            tmpPageList.setPageGroupId(this.getId());
            tmpPageList.buildList(db);
            tmpPageList.delete(db);
            tmpPageList = null;
            this.updateRelatedPageGroups(db, false);
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_page_group WHERE page_group_id =  ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("page_group_id");
        this.name = rs.getString("group_name");
        this.internalDescription = rs.getString("internal_description");
        this.position = rs.getInt("group_position");
        this.tabId = rs.getInt("tab_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public void buildPageList(Connection db) throws SQLException {
        this.pageList = new PageList();
        this.pageList.setPageGroupId(this.getId());
        this.pageList.setMode(this.mode);
        this.pageList.setPageToBuild(this.pageToBuild);
        this.pageList.buildList(db);
        if (this.pageToBuild != -1 && this.pageList.getThisPageToBuild() != null) {
            this.setThisPageToBuild(this.pageList.getThisPageToBuild());
        }
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Row ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int groupCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as groupcount FROM web_page_group WHERE tab_id = ? ");
            pst.setInt(++i, this.getTabId());
            rs = pst.executeQuery();
            if (rs.next() && (groupCount = rs.getInt("groupcount")) <= 1) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("onlyPageGroup");
                thisDependency.setCount(groupCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public int computePageGroupPosition(Connection db) throws SQLException {
        int result = 0;
        PageGroup otherPageGroup = new PageGroup();
        if (this.previousPageGroupId != -1) {
            otherPageGroup.queryRecord(db, this.previousPageGroupId);
            result = otherPageGroup.getPosition() + 1;
        } else if (this.nextPageGroupId != -1) {
            otherPageGroup.queryRecord(db, this.nextPageGroupId);
            result = otherPageGroup.getPosition();
        }
        return result;
    }

    public void updateRelatedPageGroups(Connection db, boolean add) throws SQLException {
        if (this.previousPageGroupId > -1) {
            PageGroupList.updateRelatedPageGroups(db, this.getId(), this.previousPageGroupId, this.getTabId(), false, add);
        } else if (this.nextPageGroupId > -1) {
            PageGroupList.updateRelatedPageGroups(db, this.getId(), this.nextPageGroupId, this.getTabId(), true, add);
        } else if (!add) {
            PageGroupList.updateRelatedPageGroups(db, this.getId(), -1, this.getTabId(), false, add);
        }
    }

    public void move(Connection db, boolean moveUp) throws SQLException {
        PageGroup switchPageGroup = null;
        PageGroupList groups = new PageGroupList();
        groups.setTabId(this.getTabId());
        groups.setPosition(moveUp ? this.getPosition() - 1 : this.getPosition() + 1);
        groups.buildList(db);
        if (groups.size() > 0) {
            switchPageGroup = (PageGroup)((Object)groups.get(0));
            int switchPageGroupPosition = this.getPosition();
            this.setPosition(switchPageGroup.getPosition());
            this.update(db);
            switchPageGroup.setPosition(switchPageGroupPosition);
            switchPageGroup.update(db);
        }
    }

    public boolean canDisplay() {
        return this.pageList != null && this.pageList.size() > 1;
    }
}

