/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class PageGroupList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int tabId = -1;
    private boolean buildPages = false;
    private int pageToBuild = -1;
    private int mode = -1;
    private Page thisPageToBuild = null;
    private int afterPosition = -1;
    private int beforePosition = -1;
    private int position = -1;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setTabId(int tmp) {
        this.tabId = tmp;
    }

    public void setTabId(String tmp) {
        this.tabId = Integer.parseInt(tmp);
    }

    public void setBuildPages(boolean tmp) {
        this.buildPages = tmp;
    }

    public void setBuildPages(String tmp) {
        this.buildPages = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPageToBuild(int tmp) {
        this.pageToBuild = tmp;
    }

    public void setPageToBuild(String tmp) {
        this.pageToBuild = Integer.parseInt(tmp);
    }

    public void setMode(int tmp) {
        this.mode = tmp;
    }

    public void setMode(String tmp) {
        this.mode = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getTabId() {
        return this.tabId;
    }

    public boolean getBuildPages() {
        return this.buildPages;
    }

    public int getPageToBuild() {
        return this.pageToBuild;
    }

    public int getMode() {
        return this.mode;
    }

    public Page getThisPageToBuild() {
        return this.thisPageToBuild;
    }

    public void setThisPageToBuild(Page tmp) {
        this.thisPageToBuild = tmp;
    }

    public int getAfterPosition() {
        return this.afterPosition;
    }

    public void setAfterPosition(int tmp) {
        this.afterPosition = tmp;
    }

    public void setAfterPosition(String tmp) {
        this.afterPosition = Integer.parseInt(tmp);
    }

    public int getBeforePosition() {
        return this.beforePosition;
    }

    public void setBeforePosition(int tmp) {
        this.beforePosition = tmp;
    }

    public void setBeforePosition(String tmp) {
        this.beforePosition = Integer.parseInt(tmp);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            PageGroup thisPageGroup = this.getObject(rs);
            this.add(thisPageGroup);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.buildPages) {
            for (PageGroup thisPageGroup : this) {
                thisPageGroup.setMode(this.getMode());
                thisPageGroup.setPageToBuild(this.pageToBuild);
                thisPageGroup.buildPageList(db);
                if (this.pageToBuild == -1 || thisPageGroup.getThisPageToBuild() == null) continue;
                this.setThisPageToBuild(thisPageGroup.getThisPageToBuild());
            }
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_page_group WHERE page_group_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("group_position", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY group_position ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wpg.* FROM web_page_group wpg WHERE page_group_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND page_group_id = ? ");
        }
        if (this.tabId != -1) {
            sqlFilter.append("AND tab_id = ? ");
        }
        if (this.position > -1) {
            sqlFilter.append("AND group_position = ? ");
        }
        if (this.afterPosition > -1) {
            sqlFilter.append("AND group_position > ? ");
        }
        if (this.beforePosition > -1) {
            sqlFilter.append("AND group_position < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.tabId != -1) {
            pst.setInt(++i, this.tabId);
        }
        if (this.position > 0) {
            pst.setInt(++i, this.position);
        }
        if (this.afterPosition > -1) {
            pst.setInt(++i, this.afterPosition);
        }
        if (this.beforePosition > -1) {
            pst.setInt(++i, this.beforePosition);
        }
        return i;
    }

    public PageGroup getObject(ResultSet rs) throws SQLException {
        return new PageGroup(rs);
    }

    public void delete(Connection db) throws SQLException {
        for (PageGroup thisPageGroup : this) {
            thisPageGroup.delete(db);
        }
    }

    public static void updateRelatedPageGroups(Connection db, int currentId, int adjacentId, int tabId, boolean changeAdjacentPosition, boolean addition) throws SQLException {
        if (addition) {
            PreparedStatement pst = db.prepareStatement("UPDATE web_page_group SET group_position = group_position + 1 WHERE page_group_id <> ? AND tab_id = ? AND " + (changeAdjacentPosition ? "group_position >= " : "group_position > ") + "(SELECT group_position FROM web_page_group WHERE page_group_id = ?) ");
            pst.setInt(1, currentId);
            pst.setInt(2, tabId);
            pst.setInt(3, adjacentId);
            pst.executeUpdate();
            pst.close();
        } else {
            PreparedStatement pst = db.prepareStatement("UPDATE web_page_group SET group_position = group_position - 1 WHERE tab_id = ? AND group_position > (SELECT group_position FROM web_page_group WHERE page_group_id = ?) ");
            pst.setInt(1, tabId);
            pst.setInt(2, currentId);
            pst.executeUpdate();
            pst.close();
        }
    }

    public boolean canDisplay() {
        if (this.size() > 1) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        PageGroup thisPageGroup = (PageGroup)((Object)this.get(0));
        return thisPageGroup.canDisplay();
    }

    public boolean getCanDisplay() {
        return this.canDisplay();
    }

    public int getCount() {
        return this.size();
    }

    public PageGroup getGroupById(int groupId) {
        PageGroup result = null;
        for (PageGroup thisPageGroup : this) {
            if (thisPageGroup.getId() != groupId) continue;
            result = thisPageGroup;
            break;
        }
        return result;
    }
}

