/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.utils.web.PagedListInfo;

public class PageList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int position = -1;
    private int activePageVersionId = -1;
    private int constructionPageVersionId = -1;
    private int pageGroupId = -1;
    private int tabBannerId = -1;
    private int enabled = -1;
    private int pageToBuild = -1;
    private int mode = -1;
    private Page thisPageToBuild = null;
    private int afterPosition = -1;
    private int beforePosition = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setActivePageVersionId(int tmp) {
        this.activePageVersionId = tmp;
    }

    public void setActivePageVersionId(String tmp) {
        this.activePageVersionId = Integer.parseInt(tmp);
    }

    public void setConstructionPageVersionId(int tmp) {
        this.constructionPageVersionId = tmp;
    }

    public void setConstructionPageVersionId(String tmp) {
        this.constructionPageVersionId = Integer.parseInt(tmp);
    }

    public void setPageGroupId(int tmp) {
        this.pageGroupId = tmp;
    }

    public void setPageGroupId(String tmp) {
        this.pageGroupId = Integer.parseInt(tmp);
    }

    public void setTabBannerId(int tmp) {
        this.tabBannerId = tmp;
    }

    public void setTabBannerId(String tmp) {
        this.tabBannerId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setPageToBuild(int tmp) {
        this.pageToBuild = tmp;
    }

    public void setPageToBuild(String tmp) {
        this.pageToBuild = Integer.parseInt(tmp);
    }

    public void setMode(int tmp) {
        this.mode = tmp;
        if (this.mode == Site.PORTAL_MODE) {
            this.setEnabled(1);
        }
    }

    public void setMode(String tmp) {
        this.mode = Integer.parseInt(tmp);
        if (this.mode == Site.PORTAL_MODE) {
            this.setEnabled(1);
        }
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getPosition() {
        return this.position;
    }

    public int getActivePageVersionId() {
        return this.activePageVersionId;
    }

    public int getConstructionPageVersionId() {
        return this.constructionPageVersionId;
    }

    public int getPageGroupId() {
        return this.pageGroupId;
    }

    public int getTabBannerId() {
        return this.tabBannerId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getPageToBuild() {
        return this.pageToBuild;
    }

    public int getMode() {
        return this.mode;
    }

    public Page getThisPageToBuild() {
        return this.thisPageToBuild;
    }

    public void setThisPageToBuild(Page tmp) {
        this.thisPageToBuild = tmp;
    }

    public int getAfterPosition() {
        return this.afterPosition;
    }

    public void setAfterPosition(int tmp) {
        this.afterPosition = tmp;
    }

    public void setAfterPosition(String tmp) {
        this.afterPosition = Integer.parseInt(tmp);
    }

    public int getBeforePosition() {
        return this.beforePosition;
    }

    public void setBeforePosition(int tmp) {
        this.beforePosition = tmp;
    }

    public void setBeforePosition(String tmp) {
        this.beforePosition = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Page thisPage = this.getObject(rs);
            this.add(thisPage);
            if (this.pageToBuild == -1 || thisPage.getId() != this.pageToBuild) continue;
            this.thisPageToBuild = thisPage;
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.thisPageToBuild != null) {
            this.thisPageToBuild.setMode(this.mode);
            this.thisPageToBuild.buildPageVersionToView(db);
            if (this.thisPageToBuild.getTabBannerId() > -1) {
                this.thisPageToBuild.buildTabBanner(db);
            }
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_page WHERE page_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("page_position", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY page_position ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wp.* FROM web_page wp WHERE page_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND page_id = ? ");
        }
        if (this.position > -1) {
            sqlFilter.append("AND page_position = ? ");
        }
        if (this.activePageVersionId != -1) {
            sqlFilter.append("AND active_page_version_id = ? ");
        }
        if (this.constructionPageVersionId != -1) {
            sqlFilter.append("AND construction_page_version_id = ? ");
        }
        if (this.pageGroupId != -1) {
            sqlFilter.append("AND page_group_id = ? ");
        }
        if (this.tabBannerId != -1) {
            sqlFilter.append("AND tab_banner_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
        if (this.afterPosition > -1) {
            sqlFilter.append("AND page_position > ? ");
        }
        if (this.beforePosition > -1) {
            sqlFilter.append("AND page_position < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.position > -1) {
            pst.setInt(++i, this.position);
        }
        if (this.activePageVersionId != -1) {
            pst.setInt(++i, this.activePageVersionId);
        }
        if (this.constructionPageVersionId != -1) {
            pst.setInt(++i, this.constructionPageVersionId);
        }
        if (this.pageGroupId != -1) {
            pst.setInt(++i, this.pageGroupId);
        }
        if (this.tabBannerId != -1) {
            pst.setInt(++i, this.tabBannerId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.afterPosition > -1) {
            pst.setInt(++i, this.afterPosition);
        }
        if (this.beforePosition > -1) {
            pst.setInt(++i, this.beforePosition);
        }
        return i;
    }

    public Page getObject(ResultSet rs) throws SQLException {
        return new Page(rs);
    }

    public void delete(Connection db) throws SQLException {
        for (Page thisPage : this) {
            thisPage.delete(db);
        }
    }

    public static int queryDefault(Connection db, int tmpTabId, int mode) throws SQLException {
        PageGroup defaultPageGroup = new PageGroup();
        Page defaultPage = new Page();
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_page_group  WHERE tab_id = ?  AND group_position = ?  ORDER BY group_position ");
        int i = 0;
        pst.setInt(++i, tmpTabId);
        pst.setInt(++i, 0);
        rs = pst.executeQuery();
        if (rs.next()) {
            defaultPageGroup = new PageGroup(rs);
        }
        rs.close();
        pst.close();
        if (defaultPageGroup.getId() != -1) {
            pst = db.prepareStatement(" SELECT *  FROM web_page  WHERE page_group_id = ?  AND page_position = ? " + (mode == Site.PORTAL_MODE ? "AND enabled = ? " : "") + " ORDER BY page_position ");
            i = 0;
            pst.setInt(++i, defaultPageGroup.getId());
            pst.setInt(++i, 0);
            if (mode == Site.PORTAL_MODE) {
                pst.setBoolean(++i, true);
            }
            if ((rs = pst.executeQuery()).next()) {
                defaultPage = new Page(rs);
            }
            rs.close();
            pst.close();
        }
        return defaultPage.getId();
    }

    public static void updateRelatedPages(Connection db, int currentId, int adjacentId, int pageGroupId, boolean changeAdjacentPosition, boolean addition) throws SQLException {
        if (addition) {
            PreparedStatement pst = db.prepareStatement("UPDATE web_page SET page_position = page_position + 1 WHERE page_id <> ? AND page_group_id = ? AND " + (changeAdjacentPosition ? "page_position >= " : "page_position > ") + "(SELECT page_position FROM web_page WHERE page_id = ?) ");
            pst.setInt(1, currentId);
            pst.setInt(2, pageGroupId);
            pst.setInt(3, adjacentId);
            pst.executeUpdate();
            pst.close();
        } else {
            PreparedStatement pst = db.prepareStatement("UPDATE web_page SET page_position = page_position - 1 WHERE page_group_id = ? AND page_position > (SELECT page_position FROM web_page WHERE page_id = ?) ");
            pst.setInt(1, pageGroupId);
            pst.setInt(2, currentId);
            pst.executeUpdate();
            pst.close();
        }
    }

    public int getCount() {
        return this.size();
    }

    public int getDefaultPageId() {
        int result = -1;
        for (Page thisPage : this) {
            if (thisPage.getPosition() != 0) continue;
            result = thisPage.getId();
            break;
        }
        return result;
    }
}

