/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.PageRowList;
import org.aspcfs.modules.website.base.RowColumnList;
import org.aspcfs.utils.DatabaseUtils;

public class PageRow
extends GenericBean {
    public static final int INITIAL_POSITION = 0;
    private int id = -1;
    private int position = -1;
    private int pageVersionId = -1;
    private int rowColumnId = -1;
    private boolean enabled = true;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean buildRowColumnList = false;
    private RowColumnList rowColumnList = null;
    private boolean override = false;
    private int previousPageRowId = -1;
    private int nextPageRowId = -1;
    private int totalColumnWidth = 0;
    private int level = -1;
    private boolean buildIcelet = true;
    private boolean buildIceletPropertyMap = true;
    private boolean buildSubRows = true;
    private boolean deletingFromList = false;

    public PageRow() {
    }

    public PageRow(Connection db, int tmpPageRowId) throws SQLException {
        this.queryRecord(db, tmpPageRowId);
    }

    public PageRow(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setPageVersionId(int tmp) {
        this.pageVersionId = tmp;
    }

    public void setPageVersionId(String tmp) {
        this.pageVersionId = Integer.parseInt(tmp);
    }

    public int getRowColumnId() {
        return this.rowColumnId;
    }

    public void setRowColumnId(int tmp) {
        this.rowColumnId = tmp;
    }

    public void setRowColumnId(String tmp) {
        this.rowColumnId = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setBuildRowColumnList(boolean tmp) {
        this.buildRowColumnList = tmp;
    }

    public void setBuildRowColumnList(String tmp) {
        this.buildRowColumnList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRowColumnList(RowColumnList tmp) {
        this.rowColumnList = tmp;
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPageVersionId() {
        return this.pageVersionId;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getBuildRowColumnList() {
        return this.buildRowColumnList;
    }

    public RowColumnList getRowColumnList() {
        return this.rowColumnList;
    }

    public boolean getOverride() {
        return this.override;
    }

    public int getPreviousPageRowId() {
        return this.previousPageRowId;
    }

    public void setPreviousPageRowId(int tmp) {
        this.previousPageRowId = tmp;
    }

    public void setPreviousPageRowId(String tmp) {
        this.previousPageRowId = Integer.parseInt(tmp);
    }

    public int getNextPageRowId() {
        return this.nextPageRowId;
    }

    public void setNextPageRowId(int tmp) {
        this.nextPageRowId = tmp;
    }

    public void setNextPageRowId(String tmp) {
        this.nextPageRowId = Integer.parseInt(tmp);
    }

    public int getTotalColumnWidth() {
        return this.totalColumnWidth;
    }

    public void setTotalColumnWidth(int tmp) {
        this.totalColumnWidth = tmp;
    }

    public void setTotalColumnWidth(String tmp) {
        this.totalColumnWidth = Integer.parseInt(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public boolean getDeletingFromList() {
        return this.deletingFromList;
    }

    public void setDeletingFromList(boolean tmp) {
        this.deletingFromList = tmp;
    }

    public void setDeletingFromList(String tmp) {
        this.deletingFromList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildIcelet() {
        return this.buildIcelet;
    }

    public void setBuildIcelet(boolean tmp) {
        this.buildIcelet = tmp;
    }

    public void setBuildIcelet(String tmp) {
        this.buildIcelet = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildIceletPropertyMap() {
        return this.buildIceletPropertyMap;
    }

    public void setBuildIceletPropertyMap(boolean tmp) {
        this.buildIceletPropertyMap = tmp;
    }

    public void setBuildIceletPropertyMap(String tmp) {
        this.buildIceletPropertyMap = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildSubRows() {
        return this.buildSubRows;
    }

    public void setBuildSubRows(boolean tmp) {
        this.buildSubRows = tmp;
    }

    public void setBuildSubRows(String tmp) {
        this.buildSubRows = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean queryRecord(Connection db, int tmpPageRowId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_page_row  WHERE page_row_id = ? ");
        pst.setInt(1, tmpPageRowId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Page Row record not found");
        }
        if (this.buildRowColumnList) {
            this.buildRowColumnList(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_page_row_page_row_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_page_row (" + (this.id > -1 ? "page_row_id, " : " ") + "row_position , " + "page_version_id , " + "row_column_id , " + "enabled , " + "enteredby , " + "modifiedby ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.position);
        DatabaseUtils.setInt(pst, ++i, this.pageVersionId);
        DatabaseUtils.setInt(pst, ++i, this.rowColumnId);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_page_row_page_row_id_seq", this.id);
        pst.close();
        this.updateRelatedPageRows(db, true);
        return true;
    }

    public boolean update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_page_row SET row_position = ? , page_version_id = ? , row_column_id = ? , enabled = ?  ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE page_row_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.position);
        DatabaseUtils.setInt(pst, ++i, this.pageVersionId);
        DatabaseUtils.setInt(pst, ++i, this.rowColumnId);
        pst.setBoolean(++i, this.enabled);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.rowColumnList = new RowColumnList();
            this.rowColumnList.setPageRowId(this.getId());
            this.rowColumnList.setBuildSubRows(true);
            this.rowColumnList.setBuildIceletPropertyMap(true);
            this.rowColumnList.buildList(db);
            this.rowColumnList.delete(db);
            this.rowColumnList = null;
            this.updateRelatedPageRows(db, false);
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_page_row WHERE page_row_id =  ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("page_row_id");
        this.position = rs.getInt("row_position");
        this.pageVersionId = DatabaseUtils.getInt(rs, "page_version_id");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.rowColumnId = DatabaseUtils.getInt(rs, "row_column_id");
    }

    public void buildRowColumnList(Connection db) throws SQLException {
        this.rowColumnList = new RowColumnList();
        this.rowColumnList.setPageRowId(this.getId());
        this.rowColumnList.setBuildIcelet(this.getBuildIcelet());
        this.rowColumnList.setBuildIceletPropertyMap(this.getBuildIceletPropertyMap());
        this.rowColumnList.setBuildSubRows(this.getBuildSubRows());
        this.rowColumnList.buildList(db);
        this.setTotalColumnWidth(this.rowColumnList.getTotalColumnWidth());
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Row ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        return dependencyList;
    }

    public int computePageRowPosition(Connection db) throws SQLException {
        int result = 0;
        PageRow otherPageRow = new PageRow();
        if (this.previousPageRowId != -1) {
            otherPageRow.queryRecord(db, this.previousPageRowId);
            result = otherPageRow.getPosition() + 1;
        } else if (this.nextPageRowId != -1) {
            otherPageRow.queryRecord(db, this.nextPageRowId);
            result = otherPageRow.getPosition();
        }
        return result;
    }

    public void updateRelatedPageRows(Connection db, boolean add) throws SQLException {
        if (this.previousPageRowId > -1) {
            PageRowList.updateRelatedPageRows(db, this.getId(), this.previousPageRowId, this.getPageVersionId(), this.getRowColumnId(), false, add);
        } else if (this.nextPageRowId > -1) {
            PageRowList.updateRelatedPageRows(db, this.getId(), this.nextPageRowId, this.getPageVersionId(), this.getRowColumnId(), true, add);
        } else if (!add) {
            PageRowList.updateRelatedPageRows(db, this.getId(), -1, this.getPageVersionId(), this.getRowColumnId(), false, add);
        }
    }

    public void move(Connection db, boolean moveUp) throws SQLException {
        PageRow switchPageRow = null;
        PageRowList rows = new PageRowList();
        rows.setPageVersionId(this.getPageVersionId());
        rows.setPosition(moveUp ? this.getPosition() - 1 : this.getPosition() + 1);
        rows.buildList(db);
        if (rows.size() > 0) {
            switchPageRow = (PageRow)((Object)rows.get(0));
            int switchPageRowPosition = this.getPosition();
            this.setPosition(switchPageRow.getPosition());
            this.update(db);
            switchPageRow.setPosition(switchPageRowPosition);
            switchPageRow.update(db);
        }
    }

    public void fixBlankSubRow(Connection db) throws SQLException {
        if (this.getRowColumnId() > -1) {
            this.buildRowColumnList(db);
            if (this.getRowColumnList() == null || this.getRowColumnList().size() == 0) {
                this.delete(db);
            }
        }
    }
}

