/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class PageRowList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int position = -1;
    private int pageVersionId = -1;
    private int rowColumnId = -1;
    private int enabled = -1;
    private boolean buildColumns = false;
    private int mode = -1;
    private int afterPosition = -1;
    private int beforePosition = -1;
    private int maxColumns = 1;
    private int lastPosition = 0;
    private int lastPositionPageRowId = -1;
    private boolean buildLastPosition = false;
    private boolean buildIcelet = true;
    private boolean buildIceletPropertyMap = true;
    private boolean buildSubRows = true;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setPageVersionId(int tmp) {
        this.pageVersionId = tmp;
    }

    public void setPageVersionId(String tmp) {
        this.pageVersionId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setBuildColumns(boolean tmp) {
        this.buildColumns = tmp;
    }

    public void setBuildColumns(String tmp) {
        this.buildColumns = DatabaseUtils.parseBoolean(tmp);
    }

    public void setMode(int tmp) {
        this.mode = tmp;
        if (this.mode == Site.PORTAL_MODE) {
            this.setEnabled(1);
        }
    }

    public void setMode(String tmp) {
        this.mode = Integer.parseInt(tmp);
        if (this.mode == Site.PORTAL_MODE) {
            this.setEnabled(1);
        }
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPageVersionId() {
        return this.pageVersionId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public boolean getBuildColumns() {
        return this.buildColumns;
    }

    public int getMode() {
        return this.mode;
    }

    public int getAfterPosition() {
        return this.afterPosition;
    }

    public void setAfterPosition(int tmp) {
        this.afterPosition = tmp;
    }

    public void setAfterPosition(String tmp) {
        this.afterPosition = Integer.parseInt(tmp);
    }

    public int getBeforePosition() {
        return this.beforePosition;
    }

    public void setBeforePosition(int tmp) {
        this.beforePosition = tmp;
    }

    public void setBeforePosition(String tmp) {
        this.beforePosition = Integer.parseInt(tmp);
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(int tmp) {
        this.maxColumns = tmp;
    }

    public void setMaxColumns(String tmp) {
        this.maxColumns = Integer.parseInt(tmp);
    }

    public int getRowColumnId() {
        return this.rowColumnId;
    }

    public void setRowColumnId(int tmp) {
        this.rowColumnId = tmp;
    }

    public void setRowColumnId(String tmp) {
        this.rowColumnId = Integer.parseInt(tmp);
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    public void setLastPosition(int tmp) {
        this.lastPosition = tmp;
    }

    public void setLastPosition(String tmp) {
        this.lastPosition = Integer.parseInt(tmp);
    }

    public int getLastPositionPageRowId() {
        return this.lastPositionPageRowId;
    }

    public void setLastPositionPageRowId(int tmp) {
        this.lastPositionPageRowId = tmp;
    }

    public void setLastPositionPageRowId(String tmp) {
        this.lastPositionPageRowId = Integer.parseInt(tmp);
    }

    public boolean getBuildLastPosition() {
        return this.buildLastPosition;
    }

    public void setBuildLastPosition(boolean tmp) {
        this.buildLastPosition = tmp;
    }

    public void setBuildLastPosition(String tmp) {
        this.buildLastPosition = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildIcelet() {
        return this.buildIcelet;
    }

    public void setBuildIcelet(boolean tmp) {
        this.buildIcelet = tmp;
    }

    public void setBuildIcelet(String tmp) {
        this.buildIcelet = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildIceletPropertyMap() {
        return this.buildIceletPropertyMap;
    }

    public void setBuildIceletPropertyMap(boolean tmp) {
        this.buildIceletPropertyMap = tmp;
    }

    public void setBuildIceletPropertyMap(String tmp) {
        this.buildIceletPropertyMap = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildSubRows() {
        return this.buildSubRows;
    }

    public void setBuildSubRows(boolean tmp) {
        this.buildSubRows = tmp;
    }

    public void setBuildSubRows(String tmp) {
        this.buildSubRows = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            PageRow thisPageRow = this.getObject(rs);
            this.add(thisPageRow);
            if (!this.buildLastPosition) continue;
            this.lastPosition = thisPageRow.getPosition() > this.getLastPosition() ? thisPageRow.getPosition() : this.lastPosition;
            this.lastPositionPageRowId = this.lastPosition == thisPageRow.getPosition() ? thisPageRow.getId() : this.lastPositionPageRowId;
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.buildColumns) {
            for (PageRow thisPageRow : this) {
                thisPageRow.setBuildIcelet(this.getBuildIcelet());
                thisPageRow.setBuildIceletPropertyMap(this.getBuildIceletPropertyMap());
                thisPageRow.setBuildSubRows(this.getBuildSubRows());
                thisPageRow.buildRowColumnList(db);
                this.maxColumns = thisPageRow.getRowColumnList().size() > this.maxColumns ? thisPageRow.getRowColumnList().size() : this.maxColumns;
            }
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_page_row WHERE page_row_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("row_position", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY row_position ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wpr.* FROM web_page_row wpr WHERE page_row_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id > -1) {
            sqlFilter.append("AND page_row_id = ? ");
        }
        if (this.position > -1) {
            sqlFilter.append("AND row_position = ? ");
        }
        if (this.pageVersionId > -1) {
            sqlFilter.append("AND page_version_id = ? ");
        } else if (this.rowColumnId > -1) {
            sqlFilter.append("AND row_column_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
        if (this.afterPosition > -1) {
            sqlFilter.append("AND row_position > ? ");
        }
        if (this.beforePosition > -1) {
            sqlFilter.append("AND row_position < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.position > -1) {
            pst.setInt(++i, this.position);
        }
        if (this.pageVersionId > -1) {
            pst.setInt(++i, this.pageVersionId);
        } else if (this.rowColumnId > -1) {
            pst.setInt(++i, this.rowColumnId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.afterPosition > -1) {
            pst.setInt(++i, this.afterPosition);
        }
        if (this.beforePosition > -1) {
            pst.setInt(++i, this.beforePosition);
        }
        return i;
    }

    public PageRow getObject(ResultSet rs) throws SQLException {
        return new PageRow(rs);
    }

    public void delete(Connection db) throws SQLException {
        for (PageRow thisPageRow : this) {
            thisPageRow.setDeletingFromList(true);
            thisPageRow.delete(db);
        }
    }

    public static void updateRelatedPageRows(Connection db, int currentId, int adjacentId, int pageVersionId, int rowColumnId, boolean changeAdjacentPosition, boolean addition) throws SQLException {
        if (addition) {
            PreparedStatement pst = db.prepareStatement("UPDATE web_page_row SET row_position = row_position + 1 WHERE page_row_id <> ? AND " + (pageVersionId == -1 ? " row_column_id = ? " : "page_version_id = ? ") + "AND " + (changeAdjacentPosition ? "row_position >= " : "row_position > ") + "(SELECT row_position FROM web_page_row WHERE page_row_id = ?) ");
            pst.setInt(1, currentId);
            pst.setInt(2, pageVersionId == -1 ? rowColumnId : pageVersionId);
            pst.setInt(3, adjacentId);
            pst.executeUpdate();
            pst.close();
        } else {
            PreparedStatement pst = db.prepareStatement("UPDATE web_page_row SET row_position = row_position - 1 WHERE " + (pageVersionId == -1 ? " row_column_id = ? " : "page_version_id = ? ") + "AND row_position > " + "(SELECT row_position FROM web_page_row WHERE page_row_id = ?) ");
            pst.setInt(1, pageVersionId == -1 ? rowColumnId : pageVersionId);
            pst.setInt(2, currentId);
            pst.executeUpdate();
            pst.close();
        }
    }

    public void buildRowsColumns(ArrayList rowsColumns, int level) {
        for (PageRow thisPageRow : this) {
            thisPageRow.setLevel(level);
            rowsColumns.add(thisPageRow);
            for (RowColumn thisRowColumn : thisPageRow.getRowColumnList()) {
                thisRowColumn.setLevel(level);
                thisRowColumn.setParentRow(thisPageRow);
                rowsColumns.add(thisRowColumn);
                if (thisRowColumn.getSubRows() == null || thisRowColumn.getSubRows().size() <= 0) continue;
                thisRowColumn.getSubRows().buildRowsColumns(rowsColumns, level + 1);
            }
        }
    }
}

