/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageRowList;
import org.aspcfs.modules.website.base.PageVersionList;
import org.aspcfs.utils.DatabaseUtils;

public class PageVersion
extends GenericBean {
    public static final int INITIAL_VERSION = 1;
    private int id = -1;
    private int versionNumber = -1;
    private String internalDescription = null;
    private String notes = null;
    private int parentPageVersionId = -1;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private int pageId = -1;
    private boolean override = false;
    private boolean buildPageRowList = false;
    private PageRowList pageRowList = null;
    private int mode = -1;
    private boolean isActive = false;
    private boolean isConstruction = false;

    public PageVersion() {
    }

    public PageVersion(Connection db, int tmpPageVersionId) throws SQLException {
        this.queryRecord(db, tmpPageVersionId);
    }

    public PageVersion(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setVersionNumber(int tmp) {
        this.versionNumber = tmp;
    }

    public void setVersionNumber(String tmp) {
        this.versionNumber = Integer.parseInt(tmp);
    }

    public void setInternalDescription(String tmp) {
        this.internalDescription = tmp;
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setParentPageVersionId(int tmp) {
        this.parentPageVersionId = tmp;
    }

    public void setParentPageVersionId(String tmp) {
        this.parentPageVersionId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setPageId(int tmp) {
        this.pageId = tmp;
    }

    public void setPageId(String tmp) {
        this.pageId = Integer.parseInt(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildPageRowList(boolean tmp) {
        this.buildPageRowList = tmp;
    }

    public void setBuildPageRowList(String tmp) {
        this.buildPageRowList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPageRowList(PageRowList tmp) {
        this.pageRowList = tmp;
    }

    public void setMode(int tmp) {
        this.mode = tmp;
    }

    public void setMode(String tmp) {
        this.mode = Integer.parseInt(tmp);
    }

    public void setIsActive(boolean tmp) {
        this.isActive = tmp;
    }

    public void setIsActive(String tmp) {
        this.isActive = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIsConstruction(boolean tmp) {
        this.isConstruction = tmp;
    }

    public void setIsConstruction(String tmp) {
        this.isConstruction = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getParentPageVersionId() {
        return this.parentPageVersionId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getPageId() {
        return this.pageId;
    }

    public boolean getOverride() {
        return this.override;
    }

    public boolean getBuildPageRowList() {
        return this.buildPageRowList;
    }

    public PageRowList getPageRowList() {
        return this.pageRowList;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public boolean getIsConstruction() {
        return this.isConstruction;
    }

    public boolean queryRecord(Connection db, int tmpPageVersionId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_page_version  WHERE page_version_id = ? ");
        pst.setInt(1, tmpPageVersionId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Page Version record not found");
        }
        if (this.buildPageRowList) {
            this.buildPageRowList(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_page_version_page_version_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_page_version (" + (this.id > -1 ? "page_version_id, " : "") + "version_number , " + "internal_description , " + "notes , " + "parent_page_version_id , " + "enteredby , " + "modifiedby, " + "page_id ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.versionNumber);
        pst.setString(++i, this.internalDescription);
        pst.setString(++i, this.notes);
        DatabaseUtils.setInt(pst, ++i, this.parentPageVersionId);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.modifiedBy);
        DatabaseUtils.setInt(pst, ++i, this.pageId);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_page_version_page_version_id_seq", this.id);
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_page_version SET version_number = ? , internal_description = ? , notes = ? , parent_page_version_id = ?  , page_id = ? ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE page_version_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.versionNumber);
        pst.setString(++i, this.internalDescription);
        pst.setString(++i, this.notes);
        DatabaseUtils.setInt(pst, ++i, this.parentPageVersionId);
        DatabaseUtils.setInt(pst, ++i, this.pageId);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PageVersionList tmpParentPageVersionList = new PageVersionList();
            tmpParentPageVersionList.setParentPageVersionId(this.getId());
            tmpParentPageVersionList.buildList(db);
            tmpParentPageVersionList.removeParentId(db);
            tmpParentPageVersionList = null;
            Page tmpPage = new Page(db, this.getPageId());
            if (tmpPage.getConstructionPageVersionId() == this.getId() || tmpPage.getActivePageVersionId() == this.getId()) {
                if (tmpPage.getConstructionPageVersionId() == this.getId()) {
                    tmpPage.setConstructionPageVersionId(-1);
                }
                if (tmpPage.getActivePageVersionId() == this.getId()) {
                    tmpPage.setActivePageVersionId(-1);
                }
                tmpPage.update(db);
            }
            PageRowList tmpPageRowList = new PageRowList();
            tmpPageRowList.setPageVersionId(this.getId());
            tmpPageRowList.buildList(db);
            tmpPageRowList.delete(db);
            tmpPageRowList = null;
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_page_version WHERE page_version_id =  ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("page_version_id");
        this.versionNumber = DatabaseUtils.getInt(rs, "version_number");
        this.internalDescription = rs.getString("internal_description");
        this.notes = rs.getString("notes");
        this.parentPageVersionId = DatabaseUtils.getInt(rs, "parent_page_version_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.pageId = DatabaseUtils.getInt(rs, "page_id");
    }

    public void buildPageRowList(Connection db) throws SQLException {
        this.pageRowList = new PageRowList();
        this.pageRowList.setPageVersionId(this.getId());
        this.pageRowList.setMode(this.mode);
        this.pageRowList.setBuildColumns(true);
        this.pageRowList.setBuildIcelet(true);
        this.pageRowList.setBuildIceletPropertyMap(true);
        this.pageRowList.setBuildSubRows(true);
        this.pageRowList.buildList(db);
    }

    public int getTabIdByPageVersionId(Connection db) throws SQLException {
        int tabId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT tab_id FROM web_page_group WHERE page_group_id IN (SELECT page_group_id FROM web_page  WHERE page_id IN (SELECT page_id FROM web_page_version   WHERE page_version_id = ? )) ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            tabId = rs.getInt("tab_id");
        }
        rs.close();
        pst.close();
        return tabId;
    }
}

