/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.utils.web.PagedListInfo;

public class PageVersionList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int versionNumber = -1;
    private int parentPageVersionId = -1;
    private int pageId = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setVersionNumber(int tmp) {
        this.versionNumber = tmp;
    }

    public void setVersionNumber(String tmp) {
        this.versionNumber = Integer.parseInt(tmp);
    }

    public void setParentPageVersionId(int tmp) {
        this.parentPageVersionId = tmp;
    }

    public void setParentPageVersionId(String tmp) {
        this.parentPageVersionId = Integer.parseInt(tmp);
    }

    public void setPageId(int tmp) {
        this.pageId = tmp;
    }

    public void setPageId(String tmp) {
        this.pageId = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public int getParentPageVersionId() {
        return this.parentPageVersionId;
    }

    public int getPageId() {
        return this.pageId;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            PageVersion thisPageVersion = this.getObject(rs);
            this.add(thisPageVersion);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_page_version WHERE page_version_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("version_number", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY version_number ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wpv.* FROM web_page_version wpv WHERE page_version_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND page_version_id = ? ");
        }
        if (this.versionNumber != -1) {
            sqlFilter.append("AND version_number = ? ");
        }
        if (this.parentPageVersionId != -1) {
            sqlFilter.append("AND parent_page_version_id = ? ");
        }
        if (this.pageId != -1) {
            sqlFilter.append("AND page_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.versionNumber != -1) {
            pst.setInt(++i, this.versionNumber);
        }
        if (this.parentPageVersionId != -1) {
            pst.setInt(++i, this.parentPageVersionId);
        }
        if (this.pageId != -1) {
            pst.setInt(++i, this.pageId);
        }
        return i;
    }

    public PageVersion getObject(ResultSet rs) throws SQLException {
        return new PageVersion(rs);
    }

    public void delete(Connection db) throws SQLException {
        for (PageVersion thisPageVersion : this) {
            thisPageVersion.delete(db);
        }
    }

    public void removeParentId(Connection db) throws SQLException {
        for (PageVersion thisPageVersion : this) {
            thisPageVersion.setParentPageVersionId(-1);
            thisPageVersion.update(db);
        }
    }
}

