/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.PortfolioCategoryList;
import org.aspcfs.modules.website.base.PortfolioItemList;
import org.aspcfs.utils.DatabaseUtils;

public class PortfolioCategory
extends GenericBean {
    private int id = -1;
    private String name = null;
    private String description = null;
    private int positionId = -1;
    private int parentId = -1;
    private boolean enabled = false;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean buildChildCategories = false;
    private PortfolioCategoryList childCategories = null;
    private boolean buildItems = false;
    private PortfolioItemList items = null;
    private int enabledOnly = -1;
    private boolean positionIdHasChanged = false;
    private int level = -1;

    public PortfolioCategory() {
    }

    public PortfolioCategory(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public PortfolioCategory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Portfolio Category ID");
        }
        StringBuffer sb = new StringBuffer(" SELECT pc.*  FROM portfolio_category pc  WHERE pc.category_id = ? ");
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("category_id"));
        this.name = rs.getString("category_name");
        this.description = rs.getString("category_description");
        this.positionId = DatabaseUtils.getInt(rs, "category_position_id");
        this.parentId = DatabaseUtils.getInt(rs, "parent_category_id");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "portfolio_cat_y_category_id_seq");
            sql.append("INSERT INTO portfolio_category (category_name, category_description, category_position_id, parent_category_id, enabled, ");
            if (this.id > -1) {
                sql.append("category_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("enteredby, ");
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("modifiedby )");
            sql.append(" VALUES (?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getPositionId());
            DatabaseUtils.setInt(pst, ++i, this.getParentId());
            pst.setBoolean(++i, this.getEnabled());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setInt(++i, this.getModifiedBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "portfolio_cat_y_category_id_seq", this.id);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        boolean commit = false;
        if (this.getId() == -1) {
            return -1;
        }
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE portfolio_category SET category_name = ?, category_description = ?, category_position_id = ?, parent_category_id = ?, enabled = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "modifiedby = ? " + "WHERE category_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getPositionId());
            DatabaseUtils.setInt(pst, ++i, this.getParentId());
            pst.setBoolean(++i, this.getEnabled());
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        if (this.getId() == -1) {
            throw new SQLException("Portfolio Category ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int itemCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as itemcount FROM portfolio_item WHERE portfolio_category_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (itemCount = rs.getInt("itemcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("portfolioItems");
                thisDependency.setCount(itemCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            int categoryCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as categorycount FROM portfolio_category WHERE parent_category_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (categoryCount = rs.getInt("categorycount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("portfolioCategories");
                thisDependency.setCount(categoryCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Portfolio Category ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            Object rs = null;
            this.setBuildChildCategories(true);
            this.setBuildItems(true);
            this.buildResources(db);
            this.getChildCategories().delete(db, baseFilePath);
            this.getItems().delete(db, baseFilePath);
            int nextPositionId = this.getNextPositionId(db);
            if (nextPositionId != -1) {
                PortfolioCategory nextPosition = new PortfolioCategory(db, nextPositionId);
                nextPosition.setPositionId(this.getPositionId());
                nextPosition.update(db);
            }
            pst = db.prepareStatement("DELETE FROM portfolio_category WHERE category_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("entered");
        thisList.add("modified");
        return thisList;
    }

    public void buildResources(Connection db) throws SQLException {
        if (this.buildChildCategories) {
            this.childCategories = new PortfolioCategoryList();
            this.childCategories.setParentId(this.getId());
            this.childCategories.setEnabledOnly(this.getEnabledOnly());
            this.childCategories.buildList(db);
        }
        if (this.buildItems) {
            this.items = new PortfolioItemList();
            this.items.setCategoryId(this.getId());
            this.items.setEnabledOnly(this.getEnabledOnly());
            this.items.buildList(db);
        }
    }

    public static void buildHierarchy(Connection db, Map hierarchy, int currentId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT parent_category_id, category_name FROM portfolio_category WHERE category_id = ? ");
        pst.setInt(1, currentId);
        ResultSet rs = pst.executeQuery();
        int parentId = 0;
        String name = null;
        if (rs.next()) {
            parentId = DatabaseUtils.getInt(rs, "parent_category_id");
            name = rs.getString("category_name");
        }
        rs.close();
        pst.close();
        hierarchy.put(new Integer(currentId), new String[]{name});
        if (parentId > -1) {
            PortfolioCategory.buildHierarchy(db, hierarchy, parentId);
        }
    }

    public int getNextPositionId(Connection db) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT category_id FROM portfolio_category WHERE category_position_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = DatabaseUtils.getInt(rs, "category_id");
        }
        rs.close();
        pst.close();
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getPositionId() {
        return this.positionId;
    }

    public void setPositionId(int tmp) {
        if (this.positionId != tmp) {
            this.setPositionIdHasChanged(true);
        }
        this.positionId = tmp;
    }

    public void setPositionId(String tmp) {
        if (Integer.parseInt(tmp) != this.positionId) {
            this.setPositionIdHasChanged(true);
        }
        this.positionId = Integer.parseInt(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public boolean getBuildChildCategories() {
        return this.buildChildCategories;
    }

    public void setBuildChildCategories(boolean tmp) {
        this.buildChildCategories = tmp;
    }

    public void setBuildChildCategories(String tmp) {
        this.buildChildCategories = DatabaseUtils.parseBoolean(tmp);
    }

    public PortfolioCategoryList getChildCategories() {
        return this.childCategories;
    }

    public void setChildCategories(PortfolioCategoryList tmp) {
        this.childCategories = tmp;
    }

    public boolean getBuildItems() {
        return this.buildItems;
    }

    public void setBuildItems(boolean tmp) {
        this.buildItems = tmp;
    }

    public void setBuildItems(String tmp) {
        this.buildItems = DatabaseUtils.parseBoolean(tmp);
    }

    public PortfolioItemList getItems() {
        return this.items;
    }

    public void setItems(PortfolioItemList tmp) {
        this.items = tmp;
    }

    public int getEnabledOnly() {
        return this.enabledOnly;
    }

    public void setEnabledOnly(int tmp) {
        this.enabledOnly = tmp;
    }

    public void setEnabledOnly(String tmp) {
        this.enabledOnly = Integer.parseInt(tmp);
    }

    public boolean getPositionIdHasChanged() {
        return this.positionIdHasChanged;
    }

    public void setPositionIdHasChanged(boolean tmp) {
        this.positionIdHasChanged = tmp;
    }

    public void setPositionIdHasChanged(String tmp) {
        this.positionIdHasChanged = DatabaseUtils.parseBoolean(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }
}

