/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.modules.website.base.PortfolioCategory;
import org.aspcfs.modules.website.base.PortfolioCategoryList;

public class PortfolioCategoryHierarchy {
    private PortfolioCategoryList hierarchy = null;

    public void setHierarchy(PortfolioCategoryList tmp) {
        this.hierarchy = tmp;
    }

    public PortfolioCategoryList getHierarchy() {
        return this.hierarchy;
    }

    public void build(Connection db) throws SQLException {
        this.hierarchy = new PortfolioCategoryList();
        this.hierarchy.setParentId(-1);
        this.hierarchy.buildList(db);
        this.buildItems(db, this.hierarchy, 1);
        PortfolioCategoryList buffer = this.hierarchy.buildCompleteHierarchy();
    }

    public void build(Connection db, int parentId) throws SQLException {
        this.hierarchy = new PortfolioCategoryList();
        this.hierarchy.setParentId(parentId);
        this.hierarchy.buildList(db);
        this.buildItems(db, this.hierarchy, 1);
        PortfolioCategoryList buffer = this.hierarchy.buildCompleteHierarchy();
    }

    private void buildItems(Connection db, PortfolioCategoryList categoryList) throws SQLException {
        for (PortfolioCategory category : categoryList) {
            category.setBuildChildCategories(true);
            category.buildResources(db);
            this.buildItems(db, category.getChildCategories());
        }
    }

    private void buildItems(Connection db, PortfolioCategoryList categoryList, int level) throws SQLException {
        for (PortfolioCategory category : categoryList) {
            category.setLevel(level);
            category.setBuildChildCategories(true);
            category.buildResources(db);
            this.buildItems(db, category.getChildCategories(), level + 1);
        }
    }
}

