/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.website.base.PortfolioCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class PortfolioCategoryList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int parentId = -1;
    private int enabledOnly = -1;
    private boolean buildResources = false;

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM portfolio_category pc  WHERE pc.category_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("pc.entered", null);
            boolean flag = true;
            if (DatabaseUtils.getType(db) == 2 && this.pagedListInfo.getColumnToSortBy().equals("pc.category_name")) {
                sqlOrder.append("ORDER BY " + DatabaseUtils.convertToVarChar(db, "pc.category_name") + (this.pagedListInfo.getSortOrder() != null ? " DESC " : " "));
                flag = false;
            }
            if (flag) {
                this.pagedListInfo.appendSqlTail(db, sqlOrder);
            }
        } else {
            sqlOrder.append("ORDER BY pc.category_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" pc.*  FROM portfolio_category pc  WHERE pc.category_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            PortfolioCategory thisCategory = new PortfolioCategory(rs);
            this.add(thisCategory);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            this.buildEntries(db);
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND pc.category_id = ? ");
        }
        if (this.parentId > -1) {
            sqlFilter.append(" AND pc.parent_category_id = ? ");
        } else {
            sqlFilter.append(" AND pc.parent_category_id IS NULL ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.parentId > -1) {
            pst.setInt(++i, this.parentId);
        }
        return i;
    }

    public void buildEntries(Connection db) throws SQLException {
        for (PortfolioCategory category : this) {
            category.setBuildChildCategories(true);
            category.setBuildItems(true);
            category.setEnabledOnly(this.getEnabledOnly());
            category.buildResources(db);
        }
    }

    public PortfolioCategoryList reorder() {
        HashMap positionMap = this.getCategoryIdsAsHashMap();
        HashMap categories = this.getCategoriesByPositionAsHashMap();
        PortfolioCategoryList reorderedList = new PortfolioCategoryList();
        reorderedList.setEnabledOnly(this.getEnabledOnly());
        reorderedList.setParentId(this.getParentId());
        String tempCategoryId = "-1";
        for (int i = 0; i < this.size(); ++i) {
            PortfolioCategory thisCategory = (PortfolioCategory)((Object)categories.get(tempCategoryId));
            if (thisCategory == null) continue;
            tempCategoryId = (String)positionMap.get(tempCategoryId);
            if (this.enabledOnly != -1) {
                if (thisCategory.getEnabled() != (this.enabledOnly == 1)) continue;
                reorderedList.add(thisCategory);
                continue;
            }
            reorderedList.add(thisCategory);
        }
        return reorderedList;
    }

    public PortfolioCategoryList reset(ActionContext context, Connection db) throws SQLException {
        PortfolioCategoryList oldList = this.reorder();
        HashMap oldOrder = oldList.getCategoryPositionsAsHashMap();
        HashMap<String, Object> newOrder = new HashMap<String, Object>();
        for (PortfolioCategory category : oldList) {
            String position = context.getRequest().getParameter("category" + category.getId());
            if (position.indexOf(".") > -1) {
                try {
                    position = new Integer((int)Math.ceil(Double.parseDouble(context.getRequest().getParameter("category" + category.getId())))).toString();
                }
                catch (NumberFormatException e) {
                    position = (String)oldOrder.get(String.valueOf(category.getId()));
                }
            }
            if (position == null || "".equals(position.trim())) {
                position = (String)oldOrder.get(String.valueOf(category.getId()));
            }
            if (newOrder.get(position) != null) {
                Object content = newOrder.get(position);
                if (content instanceof ArrayList) {
                    ArrayList tempList = (ArrayList)content;
                    int oldPosition = Integer.parseInt((String)oldOrder.get(String.valueOf(category.getId())));
                    if (oldPosition > Integer.parseInt(position)) {
                        tempList.add(0, String.valueOf(category.getId()));
                    } else {
                        tempList.add(String.valueOf(category.getId()));
                    }
                    newOrder.put(position, tempList);
                    continue;
                }
                if (!(content instanceof String)) continue;
                String oldCatId = (String)content;
                ArrayList<String> tempList = new ArrayList<String>();
                tempList.add(oldCatId);
                int oldPosition = Integer.parseInt((String)oldOrder.get(String.valueOf(category.getId())));
                if (oldPosition > Integer.parseInt(position)) {
                    tempList.add(0, String.valueOf(category.getId()));
                } else {
                    tempList.add(String.valueOf(category.getId()));
                }
                newOrder.put(position, tempList);
                continue;
            }
            newOrder.put(position, String.valueOf(category.getId()));
        }
        HashMap categoriesMap = oldList.getCategoriesAsHashMap();
        PortfolioCategoryList currentList = new PortfolioCategoryList();
        int categoryCounter = 0;
        int currentSize = this.size();
        int i = 1;
        while (true) {
            if (newOrder.get(String.valueOf(i)) != null) {
                Object content = newOrder.get(String.valueOf(i));
                if (content instanceof String) {
                    PortfolioCategory tempCategory = (PortfolioCategory)((Object)categoriesMap.get((String)content));
                    currentList.add(tempCategory);
                    ++categoryCounter;
                } else if (content instanceof ArrayList) {
                    ArrayList tempList = (ArrayList)content;
                    for (int j = 0; j < tempList.size(); ++j) {
                        PortfolioCategory tempCategory = (PortfolioCategory)((Object)categoriesMap.get((String)tempList.get(j)));
                        currentList.add(tempCategory);
                        ++categoryCounter;
                    }
                }
            }
            if (categoryCounter >= currentSize) break;
            ++i;
        }
        currentList.setEnabledOnly(this.getEnabledOnly());
        currentList.setParentId(this.getParentId());
        Iterator iter = currentList.iterator();
        if (iter.hasNext()) {
            PortfolioCategory firstCategory = (PortfolioCategory)((Object)iter.next());
            firstCategory.setPositionId(-1);
            if (firstCategory.getPositionIdHasChanged()) {
                firstCategory.update(db);
            }
            Iterator iter2 = currentList.iterator();
            while (iter.hasNext()) {
                PortfolioCategory parentCategory = (PortfolioCategory)((Object)iter2.next());
                PortfolioCategory category = (PortfolioCategory)((Object)iter.next());
                category.setPositionId(parentCategory.getId());
                if (!category.getPositionIdHasChanged()) continue;
                category.update(db);
            }
        }
        return currentList;
    }

    public String printArray(ArrayList list) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            str.append("\nprintList:: list[" + i + "] = " + list.get(i));
        }
        return str.toString();
    }

    public HashMap getCategoryIdsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (PortfolioCategory category : this) {
            map.put(String.valueOf(category.getPositionId()), String.valueOf(category.getId()));
        }
        return map;
    }

    public HashMap getCategoriesByPositionAsHashMap() {
        HashMap<String, PortfolioCategory> map = new HashMap<String, PortfolioCategory>();
        for (PortfolioCategory category : this) {
            map.put(String.valueOf(category.getPositionId()), category);
        }
        return map;
    }

    public HashMap getCategoriesAsHashMap() {
        HashMap<String, PortfolioCategory> map = new HashMap<String, PortfolioCategory>();
        for (PortfolioCategory category : this) {
            map.put(String.valueOf(category.getId()), category);
        }
        return map;
    }

    public HashMap getCategoryPositionsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = this.iterator();
        int i = 1;
        while (iter.hasNext()) {
            PortfolioCategory category = (PortfolioCategory)((Object)iter.next());
            map.put(String.valueOf(category.getId()), String.valueOf(i));
            ++i;
        }
        return map;
    }

    public PortfolioCategory getCategoryById(int id) {
        PortfolioCategory result = null;
        for (PortfolioCategory category : this) {
            if (category.getId() != id) continue;
            result = category;
            break;
        }
        return result;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        for (PortfolioCategory category : this) {
            category.delete(db, baseFilePath);
        }
        return true;
    }

    public int getIdByIndex(int index) {
        PortfolioCategory category;
        int result = -1;
        if (this.size() > 0 && index < this.size() && (category = (PortfolioCategory)((Object)this.get(index))) != null) {
            result = category.getId();
        }
        return result;
    }

    public int getLastCategoryId() {
        return this.getIdByIndex(this.size() - 1);
    }

    public PortfolioCategoryList buildCompleteHierarchy() throws SQLException {
        for (int i = 0; i < this.size(); ++i) {
            PortfolioCategory thisCategory = (PortfolioCategory)((Object)this.get(i));
            if (thisCategory.getChildCategories().size() <= 0) continue;
            this.addAll(i + 1, thisCategory.getChildCategories());
        }
        return this;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public int getEnabledOnly() {
        return this.enabledOnly;
    }

    public void setEnabledOnly(int tmp) {
        this.enabledOnly = tmp;
    }

    public void setEnabledOnly(String tmp) {
        this.enabledOnly = Integer.parseInt(tmp);
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }
}

